/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer;

import com.linkedin.kafka.cruisecontrol.analyzer.GoalOptimizationHistoryOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizerResultReplicaMovements;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalOptimizationResult;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.ProposalStats;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionProposal;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelStats;
import com.linkedin.kafka.cruisecontrol.model.util.ClusterModelStatsComparator;
import com.linkedin.kafka.cruisecontrol.monitor.BrokerStats;
import com.linkedin.kafka.cruisecontrol.monitor.ModelGeneration;
import com.linkedin.kafka.cruisecontrol.monitor.SingleBrokerStats;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;

public class OptimizerResult {
    private static final String NUM_INTER_BROKER_REPLICA_MOVEMENTS = "numReplicaMovements";
    private static final String INTER_BROKER_DATA_TO_MOVE_MB = "dataToMoveMB";
    private static final String NUM_INTRA_BROKER_REPLICA_MOVEMENTS = "numIntraBrokerReplicaMovements";
    private static final String INTRA_BROKER_DATA_TO_MOVE_MB = "intraBrokerDataToMoveMB";
    private static final String NUM_LEADER_MOVEMENTS = "numLeaderMovements";
    private static final String RECENT_WINDOWS = "recentWindows";
    private static final String MONITORED_PARTITIONS_PERCENTAGE = "monitoredPartitionsPercentage";
    private static final String EXCLUDED_TOPICS = "excludedTopics";
    private static final String EXCLUDED_BROKERS_FOR_LEADERSHIP = "excludedBrokersForLeadership";
    private static final String EXCLUDED_BROKERS_FOR_REPLICA_MOVE = "excludedBrokersForReplicaMove";
    private static final String ON_DEMAND_BALANCEDNESS_SCORE_AFTER = "onDemandBalancednessScoreAfter";
    private static final String ON_DEMAND_BALANCEDNESS_SCORE_BEFORE = "onDemandBalancednessScoreBefore";
    private final Map<String, GoalOptimizationResult.GoalOptimizationResultState> goalOptimizationResultStateByGoalName;
    private final Map<String, ClusterModelStatsComparator> clusterModelStatsComparatorByGoalName;
    private final LinkedHashMap<String, ClusterModelStats> clusterStatsByGoalName;
    private final Map<String, ProposalStats> proposalStatsByGoalName;
    private final Set<ExecutionProposal> proposals;
    private final OptimizerResultReplicaMovements replicaMovements;
    private final Set<String> skippedGoals;
    private final Set<String> violatedGoalNamesBeforeOptimization;
    private final Set<String> violatedGoalNamesAfterOptimization;
    private final Set<String> goalNamesWithProposals;
    private final BrokerStats brokerStatsBeforeOptimization;
    private final BrokerStats brokerStatsAfterOptimization;
    private final ModelGeneration modelGeneration;
    private final ClusterModelStats clusterModelStats;
    private final Map<Integer, String> capacityEstimationInfoByBrokerId;
    private final OptimizationOptions optimizationOptions;
    private final double onDemandBalancednessScoreBefore;
    private final double onDemandBalancednessScoreAfter;

    OptimizerResult(Map<String, GoalOptimizationResult.GoalOptimizationResultState> goalOptimizationResultStateByGoalName, LinkedHashMap<Goal, ClusterModelStats> statsByGoalPriority, Set<String> skippedGoals, Set<String> violatedGoalNamesBeforeOptimization, Set<String> violatedGoalNamesAfterOptimization, Set<String> goalNamesWithProposals, Set<ExecutionProposal> proposals, BrokerStats brokerStatsBeforeOptimization, BrokerStats brokerStatsAfterOptimization, ModelGeneration modelGeneration, ClusterModelStats clusterModelStats, Map<Integer, String> capacityEstimationInfoByBrokerId, OptimizationOptions optimizationOptions, Map<String, Double> balancednessCostByGoal, Map<String, ProposalStats> goalStatsByGoal) {
        this.goalOptimizationResultStateByGoalName = goalOptimizationResultStateByGoalName;
        this.clusterModelStatsComparatorByGoalName = new LinkedHashMap<String, ClusterModelStatsComparator>(statsByGoalPriority.size());
        this.clusterStatsByGoalName = new LinkedHashMap(statsByGoalPriority.size());
        for (Map.Entry<Goal, ClusterModelStats> entry : statsByGoalPriority.entrySet()) {
            String goalName = entry.getKey().name();
            ClusterModelStatsComparator comparator = entry.getKey().clusterModelStatsComparator();
            this.clusterModelStatsComparatorByGoalName.put(goalName, comparator);
            this.clusterStatsByGoalName.put(goalName, entry.getValue());
        }
        this.proposalStatsByGoalName = Collections.unmodifiableMap(goalStatsByGoal);
        this.skippedGoals = Collections.unmodifiableSet(skippedGoals);
        this.violatedGoalNamesBeforeOptimization = violatedGoalNamesBeforeOptimization;
        this.violatedGoalNamesAfterOptimization = violatedGoalNamesAfterOptimization;
        this.goalNamesWithProposals = Collections.unmodifiableSet(goalNamesWithProposals);
        this.proposals = proposals;
        this.brokerStatsBeforeOptimization = brokerStatsBeforeOptimization;
        this.brokerStatsAfterOptimization = brokerStatsAfterOptimization;
        this.modelGeneration = modelGeneration;
        this.clusterModelStats = clusterModelStats;
        this.capacityEstimationInfoByBrokerId = capacityEstimationInfoByBrokerId;
        this.optimizationOptions = optimizationOptions;
        this.onDemandBalancednessScoreBefore = this.onDemandBalancednessScore(balancednessCostByGoal, this.violatedGoalNamesBeforeOptimization);
        this.onDemandBalancednessScoreAfter = this.onDemandBalancednessScore(balancednessCostByGoal, this.violatedGoalNamesAfterOptimization);
        this.replicaMovements = new OptimizerResultReplicaMovements(proposals);
    }

    private double onDemandBalancednessScore(Map<String, Double> balancednessCostByGoal, Set<String> violatedGoals) {
        double onDemandBalancednessScore = 100.0;
        for (String goalName : this.clusterStatsByGoalName.keySet()) {
            if (!violatedGoals.contains(goalName)) continue;
            onDemandBalancednessScore -= balancednessCostByGoal.get(goalName).doubleValue();
        }
        return onDemandBalancednessScore;
    }

    public Map<String, GoalOptimizationResult.GoalOptimizationResultState> goalOptimizationResultStateByGoalName() {
        return Collections.unmodifiableMap(this.goalOptimizationResultStateByGoalName);
    }

    public Map<String, ClusterModelStatsComparator> clusterModelStatsComparatorByGoalName() {
        return this.clusterModelStatsComparatorByGoalName;
    }

    public LinkedHashMap<String, ClusterModelStats> clusterStatsByGoalName() {
        return this.clusterStatsByGoalName;
    }

    public Map<String, ProposalStats> proposalStatsByGoalName() {
        return this.proposalStatsByGoalName;
    }

    public Set<ExecutionProposal> goalProposals() {
        return this.proposals;
    }

    public Set<String> violatedGoalsBeforeOptimization() {
        return this.violatedGoalNamesBeforeOptimization;
    }

    public Set<String> skippedGoals() {
        return this.skippedGoals;
    }

    public Set<String> violatedGoalsAfterOptimization() {
        return this.violatedGoalNamesAfterOptimization;
    }

    public Set<String> goalNamesWithProposals() {
        return this.goalNamesWithProposals;
    }

    public ModelGeneration modelGeneration() {
        return this.modelGeneration;
    }

    public ClusterModelStats clusterModelStats() {
        return this.clusterModelStats;
    }

    public BrokerStats brokerStatsBeforeOptimization() {
        return this.brokerStatsBeforeOptimization;
    }

    public BrokerStats brokerStatsAfterOptimization() {
        return this.brokerStatsAfterOptimization;
    }

    public boolean isCapacityEstimated() {
        return !this.capacityEstimationInfoByBrokerId.isEmpty();
    }

    public Map<Integer, String> capacityEstimationInfoByBrokerId() {
        return Collections.unmodifiableMap(this.capacityEstimationInfoByBrokerId);
    }

    public Set<String> excludedTopics() {
        return this.optimizationOptions.excludedTopics();
    }

    public Set<Integer> excludedBrokersForLeadership() {
        return this.optimizationOptions.excludedBrokersForLeadership();
    }

    public Set<Integer> excludedBrokersForReplicaMove() {
        return this.optimizationOptions.excludedBrokersForReplicaMove();
    }

    public Set<TopicPartition> suspendedTopicPartitions() {
        return this.optimizationOptions.goalOptimizationHistoryOptions().map(GoalOptimizationHistoryOptions::suspendedTopicPartitions).orElse(Collections.emptySet());
    }

    public OptimizerResultReplicaMovements replicaMovements() {
        return this.replicaMovements;
    }

    public double onDemandBalancednessScoreBefore() {
        return this.onDemandBalancednessScoreBefore;
    }

    public double onDemandBalancednessScoreAfter() {
        return this.onDemandBalancednessScoreAfter;
    }

    public Set<String> topicsWithReplicationFactorChange() {
        HashSet<String> topics = new HashSet<String>(this.proposals.size());
        this.proposals.stream().filter(p -> p.newReplicas().size() != p.oldReplicas().size()).forEach(p -> topics.add(p.topic()));
        return topics;
    }

    public SortedSet<Integer> brokersWithState(Broker.Strategy strategy) {
        return this.brokerStatsBeforeOptimization.stats().stream().filter(broker -> broker.strategy() == strategy).mapToInt(SingleBrokerStats::id).boxed().collect(Collectors.toCollection(TreeSet::new));
    }

    public String getProposalSummary() {
        String newLine = System.lineSeparator();
        SortedSet<Integer> newBrokers = this.brokersWithState(Broker.Strategy.NEW);
        SortedSet<Integer> deadOrRemovedBrokers = this.brokersWithState(Broker.Strategy.DEAD);
        String replicaMovementsStr = String.format("Optimization has %d inter-broker replica(%d MB) moves, %d intra-broker replica(%d MB) moves and %d leadership moves with a cluster model of %d recent windows and %.3f%% of the partitions covered.", this.replicaMovements.numInterBrokerReplicaMovements(), this.replicaMovements.interBrokerDataToMove(), this.replicaMovements.numIntraBrokerReplicaMovements(), this.replicaMovements.intraBrokerDataToMove(), this.replicaMovements.numLeadershipMovements(), this.clusterModelStats.numSnapshotWindows(), this.clusterModelStats.monitoredPartitionsPercentage());
        return String.join((CharSequence)newLine, replicaMovementsStr, String.format("New brokers: %s.", newBrokers), String.format("Dead or removed brokers: %s.", deadOrRemovedBrokers), String.format("Violated goals before optimization: %s.", this.violatedGoalsBeforeOptimization()), String.format("Violated goals after optimization: %s.", this.violatedGoalsAfterOptimization()), String.format("Skipped goals: %s", this.skippedGoals()), String.format("Goals which generated movements: %s", this.goalNamesWithProposals()), String.format("Excluded topics: %s.", this.excludedTopics()), String.format("Excluded brokers for leadership: %s.", this.excludedBrokersForLeadership()), String.format("Excluded brokers for replica move: %s.", this.excludedBrokersForReplicaMove()), String.format("Suspended topic partitions: %s", this.suspendedTopicPartitions()), String.format("Counts: %s", this.clusterModelStats.toStringCounts()), String.format("On-demand balancedness score before and after: %.3f -> %.3f.", this.onDemandBalancednessScoreBefore, this.onDemandBalancednessScoreAfter));
    }

    public Map<String, Object> getProposalSummaryForJson() {
        HashMap<String, Object> ret = new HashMap<String, Object>(12);
        ret.put(NUM_INTER_BROKER_REPLICA_MOVEMENTS, this.replicaMovements.numInterBrokerReplicaMovements());
        ret.put(INTER_BROKER_DATA_TO_MOVE_MB, this.replicaMovements.interBrokerDataToMove());
        ret.put(NUM_INTRA_BROKER_REPLICA_MOVEMENTS, this.replicaMovements.numIntraBrokerReplicaMovements());
        ret.put(INTRA_BROKER_DATA_TO_MOVE_MB, this.replicaMovements.intraBrokerDataToMove());
        ret.put(NUM_LEADER_MOVEMENTS, this.replicaMovements.numLeadershipMovements());
        ret.put(RECENT_WINDOWS, this.clusterModelStats.numSnapshotWindows());
        ret.put(MONITORED_PARTITIONS_PERCENTAGE, this.clusterModelStats.monitoredPartitionsPercentage());
        ret.put(EXCLUDED_TOPICS, this.excludedTopics());
        ret.put(EXCLUDED_BROKERS_FOR_LEADERSHIP, this.excludedBrokersForLeadership());
        ret.put(EXCLUDED_BROKERS_FOR_REPLICA_MOVE, this.excludedBrokersForReplicaMove());
        ret.put(ON_DEMAND_BALANCEDNESS_SCORE_BEFORE, this.onDemandBalancednessScoreBefore);
        ret.put(ON_DEMAND_BALANCEDNESS_SCORE_AFTER, this.onDemandBalancednessScoreAfter);
        return ret;
    }
}

