/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.PartitionBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.AbstractGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.OptimizationMetrics;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelStats;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.util.ClusterModelStatsComparator;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PotentialNwOutGoal
extends AbstractGoal {
    private static final Logger LOG = LoggerFactory.getLogger(PotentialNwOutGoal.class);
    private boolean fixOfflineReplicasOnly;

    public PotentialNwOutGoal() {
    }

    PotentialNwOutGoal(BalancingConstraint constraint) {
        this.balancingConstraint = constraint;
    }

    @Override
    public ActionAcceptance replicaActionAcceptance(ReplicaBalancingAction action, ClusterModel clusterModel) {
        switch (action.balancingAction()) {
            case LEADERSHIP_MOVEMENT: {
                return ActionAcceptance.ACCEPT;
            }
            case INTER_BROKER_REPLICA_SWAP: 
            case INTER_BROKER_REPLICA_MOVEMENT: {
                return this.isReplicaRelocationAcceptable(action, clusterModel);
            }
        }
        throw new IllegalArgumentException("Unsupported balancing action " + (Object)((Object)action.balancingAction()) + " is provided.");
    }

    @Override
    public ActionAcceptance partitionActionAcceptance(PartitionBalancingAction action, ClusterModel clusterModel) {
        return ActionAcceptance.REPLICA_REJECT;
    }

    private ActionAcceptance isReplicaRelocationAcceptable(ReplicaBalancingAction action, ClusterModel clusterModel) {
        if (this.selfSatisfied(clusterModel, action)) {
            return ActionAcceptance.ACCEPT;
        }
        Replica replica = clusterModel.broker(action.sourceBrokerId()).replica(action.topicPartition());
        double destinationBrokerUtilization = clusterModel.potentialLeadershipLoadFor(clusterModel.broker(action.destinationBrokerId()).id()).expectedUtilizationFor(Resource.NW_OUT);
        double sourceBrokerUtilization = clusterModel.potentialLeadershipLoadFor(replica.broker().id()).expectedUtilizationFor(Resource.NW_OUT);
        double sourceReplicaUtilization = clusterModel.partition(replica.topicPartition()).leader().load().expectedUtilizationFor(Resource.NW_OUT);
        double maxUtilization = Math.max(destinationBrokerUtilization, sourceBrokerUtilization);
        switch (action.balancingAction()) {
            case INTER_BROKER_REPLICA_SWAP: {
                double destinationReplicaUtilization = clusterModel.partition(action.destinationTopicPartition()).leader().load().expectedUtilizationFor(Resource.NW_OUT);
                if (sourceBrokerUtilization + destinationReplicaUtilization - sourceReplicaUtilization > maxUtilization) {
                    return ActionAcceptance.REPLICA_REJECT;
                }
                return destinationBrokerUtilization + sourceReplicaUtilization - destinationReplicaUtilization <= maxUtilization ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
            }
            case INTER_BROKER_REPLICA_MOVEMENT: {
                return destinationBrokerUtilization + sourceReplicaUtilization <= maxUtilization ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
            }
        }
        throw new IllegalArgumentException("Unsupported balancing action " + (Object)((Object)action.balancingAction()) + " is provided.");
    }

    @Override
    public ClusterModelStatsComparator clusterModelStatsComparator() {
        return new PotentialNwOutGoalStatsComparator();
    }

    @Override
    public ModelCompletenessRequirements clusterModelCompletenessRequirements() {
        return new ModelCompletenessRequirements(Math.max(1, this.numWindows / 2), this.minMonitoredPartitionPercentage, false);
    }

    @Override
    public String name() {
        return PotentialNwOutGoal.class.getSimpleName();
    }

    @Override
    public boolean isHardGoal() {
        return false;
    }

    @Override
    protected SortedSet<Broker> brokersToBalance(ClusterModel clusterModel) {
        SortedSet<Broker> brokenBrokers = clusterModel.deadBrokers();
        brokenBrokers.addAll(clusterModel.brokersHavingOfflineReplicasOnBadDisks());
        return brokenBrokers.isEmpty() ? clusterModel.allBrokers() : brokenBrokers;
    }

    @Override
    public boolean replicaActionSelfSatisfied(ClusterModel clusterModel, ReplicaBalancingAction action) {
        Replica sourceReplica = clusterModel.broker(action.sourceBrokerId()).replica(action.topicPartition());
        ActionType actionType = action.balancingAction();
        Broker sourceBroker = sourceReplica.broker();
        if (this.fixOfflineReplicasOnly && sourceReplica.isCurrentOffline()) {
            return action.balancingAction() == ActionType.INTER_BROKER_REPLICA_MOVEMENT;
        }
        Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
        double destinationBrokerUtilization = clusterModel.potentialLeadershipLoadFor(destinationBroker.id()).expectedUtilizationFor(Resource.NW_OUT);
        double destinationCapacity = this.balancingConstraint.allowedCapacityForBroker(Resource.NW_OUT, destinationBroker.capacity());
        double sourceReplicaUtilization = clusterModel.partition(sourceReplica.topicPartition()).leader().load().expectedUtilizationFor(Resource.NW_OUT);
        if (actionType != ActionType.INTER_BROKER_REPLICA_SWAP) {
            return destinationCapacity >= destinationBrokerUtilization + sourceReplicaUtilization;
        }
        double destinationReplicaUtilization = clusterModel.partition(action.destinationTopicPartition()).leader().load().expectedUtilizationFor(Resource.NW_OUT);
        if (destinationCapacity < destinationBrokerUtilization + sourceReplicaUtilization - destinationReplicaUtilization) {
            return false;
        }
        double sourceBrokerUtilization = clusterModel.potentialLeadershipLoadFor(sourceBroker.id()).expectedUtilizationFor(Resource.NW_OUT);
        double sourceCapacity = this.balancingConstraint.allowedCapacityForBroker(Resource.NW_OUT, sourceBroker.capacity());
        return sourceCapacity >= sourceBrokerUtilization + destinationReplicaUtilization - sourceReplicaUtilization;
    }

    @Override
    public boolean partitionActionSelfSatisfied(ClusterModel clusterModel, PartitionBalancingAction action) {
        return false;
    }

    @Override
    protected void initGoalState(ClusterModel clusterModel, OptimizationOptions optimizationOptions, Optional<OptimizationMetrics> optimizationMetricsOpt) {
        this.fixOfflineReplicasOnly = false;
    }

    @Override
    protected void updateGoalState(ClusterModel clusterModel, Set<String> excludedTopics) throws OptimizationFailureException {
        try {
            GoalUtils.ensureNoOfflineReplicas(clusterModel, this.name());
        }
        catch (OptimizationFailureException ofe) {
            if (this.fixOfflineReplicasOnly) {
                throw ofe;
            }
            this.fixOfflineReplicasOnly = true;
            LOG.warn("Ignoring potential network outbound limit to move offline replicas from dead brokers/disks.");
            return;
        }
        GoalUtils.ensureReplicasMoveOffBrokersWithBadDisks(clusterModel, this.name());
        this.finish();
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    protected void rebalanceForBroker(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        boolean estimatedMaxPossibleNwOutOverLimit;
        double capacityLimit = this.balancingConstraint.allowedCapacityForBroker(Resource.NW_OUT, broker.capacity());
        boolean bl = estimatedMaxPossibleNwOutOverLimit = !broker.replicas().isEmpty() && clusterModel.potentialLeadershipLoadFor(broker.id()).expectedUtilizationFor(Resource.NW_OUT) > capacityLimit;
        if (!(estimatedMaxPossibleNwOutOverLimit || this.fixOfflineReplicasOnly && !broker.currentOfflineReplicas().isEmpty())) {
            return;
        }
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        Set<Broker> candidateBrokers = this.fixOfflineReplicasOnly ? clusterModel.aliveBrokers() : this.brokersUnderEstimatedMaxPossibleNwOut(clusterModel);
        TreeSet<Replica> replicas = new TreeSet<Replica>(broker.replicas());
        for (Replica replica : replicas) {
            double destCapacityLimit;
            double updatedDestBrokerPotentialNwOut;
            if (PotentialNwOutGoal.shouldExclude(replica, excludedTopics)) continue;
            ArrayList<Broker> eligibleBrokers = new ArrayList<Broker>(candidateBrokers);
            eligibleBrokers.removeAll(clusterModel.partition(replica.topicPartition()).partitionBrokers());
            eligibleBrokers.sort((b1, b2) -> Double.compare(b2.leadershipLoadForNwResources().expectedUtilizationFor(Resource.NW_OUT), b1.leadershipLoadForNwResources().expectedUtilizationFor(Resource.NW_OUT)));
            Broker destinationBroker = this.maybeApplyBalancingAction(clusterModel, replica, eligibleBrokers, ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizedGoals, optimizationOptions, Optional.empty());
            if (destinationBroker == null) continue;
            int destinationBrokerId = destinationBroker.id();
            boolean bl2 = estimatedMaxPossibleNwOutOverLimit = !broker.replicas().isEmpty() && clusterModel.potentialLeadershipLoadFor(broker.id()).expectedUtilizationFor(Resource.NW_OUT) > capacityLimit;
            if (!estimatedMaxPossibleNwOutOverLimit && (!this.fixOfflineReplicasOnly || broker.currentOfflineReplicas().isEmpty())) break;
            if (this.fixOfflineReplicasOnly || !((updatedDestBrokerPotentialNwOut = clusterModel.potentialLeadershipLoadFor(destinationBrokerId).expectedUtilizationFor(Resource.NW_OUT)) > (destCapacityLimit = this.balancingConstraint.allowedCapacityForBroker(Resource.NW_OUT, destinationBroker.capacity())))) continue;
            candidateBrokers.remove(clusterModel.broker(destinationBrokerId));
        }
        if (estimatedMaxPossibleNwOutOverLimit) {
            LOG.warn("Violated estimated max possible network out limit for broker id:{} limit:{} utilization:{}.", new Object[]{broker.id(), capacityLimit, clusterModel.potentialLeadershipLoadFor(broker.id()).expectedUtilizationFor(Resource.NW_OUT)});
            this.optimizationResultBuilder.markUnsuccessfulOptimization();
        }
    }

    private Set<Broker> brokersUnderEstimatedMaxPossibleNwOut(ClusterModel clusterModel) {
        HashSet<Broker> brokersUnderEstimatedMaxPossibleNwOut = new HashSet<Broker>();
        for (Broker aliveBroker : clusterModel.aliveBrokers()) {
            double capacityLimit = this.balancingConstraint.allowedCapacityForBroker(Resource.NW_OUT, aliveBroker.capacity());
            if (!(clusterModel.potentialLeadershipLoadFor(aliveBroker.id()).expectedUtilizationFor(Resource.NW_OUT) < capacityLimit)) continue;
            brokersUnderEstimatedMaxPossibleNwOut.add(aliveBroker);
        }
        return brokersUnderEstimatedMaxPossibleNwOut;
    }

    private class PotentialNwOutGoalStatsComparator
    implements ClusterModelStatsComparator {
        private String reasonForLastNegativeResult;

        private PotentialNwOutGoalStatsComparator() {
        }

        @Override
        public int compare(ClusterModelStats stats1, ClusterModelStats stats2) {
            int stat2;
            int stat1 = stats1.numBrokersUnderPotentialNwOut();
            int result = Integer.compare(stat1, stat2 = stats2.numBrokersUnderPotentialNwOut());
            if (result < 0) {
                this.reasonForLastNegativeResult = String.format("Violated %s. [Number of brokers under potential NwOut] post-optimization:%d pre-optimization:%d", PotentialNwOutGoal.this.name(), stat1, stat2);
            }
            return result;
        }

        @Override
        public String explainLastComparison() {
            return this.reasonForLastNegativeResult;
        }
    }
}

