/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.AnalyzerUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.PartitionBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.ReplicaBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.ReplicaDistributionAbstractGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.ReplicaDistributionStatsSnapshot;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.OptimizationMetrics;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.common.Statistic;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelStats;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.ReplicaSortFunctionFactory;
import com.linkedin.kafka.cruisecontrol.model.util.ClusterModelStatsComparator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaDistributionGoal
extends ReplicaDistributionAbstractGoal {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicaDistributionGoal.class);

    public ReplicaDistributionGoal() {
    }

    public ReplicaDistributionGoal(BalancingConstraint balancingConstraint) {
        this();
        this.balancingConstraint = balancingConstraint;
    }

    @Override
    int numInterestedReplicas(ClusterModel clusterModel) {
        return clusterModel.numReplicasOnEligibleSourceBrokers();
    }

    @Override
    int numInterestedReplicas(Broker broker) {
        return broker.replicas().size();
    }

    @Override
    double balancePercentage() {
        return this.balancingConstraint.replicaBalancePercentage();
    }

    @Override
    public ActionAcceptance replicaActionAcceptance(ReplicaBalancingAction action, ClusterModel clusterModel) {
        switch (action.balancingAction()) {
            case INTER_BROKER_REPLICA_SWAP: 
            case LEADERSHIP_MOVEMENT: {
                return ActionAcceptance.ACCEPT;
            }
            case INTER_BROKER_REPLICA_MOVEMENT: {
                Broker sourceBroker = clusterModel.broker(action.sourceBrokerId());
                Broker destinationBroker = clusterModel.broker(action.destinationBrokerId());
                return this.isReplicaCountUnderBalanceUpperLimitAfterChange(destinationBroker, destinationBroker.replicas().size(), ReplicaDistributionAbstractGoal.ChangeType.ADD) && this.isReplicaCountAboveBalanceLowerLimitAfterChange(sourceBroker, sourceBroker.replicas().size(), ReplicaDistributionAbstractGoal.ChangeType.REMOVE) ? ActionAcceptance.ACCEPT : ActionAcceptance.REPLICA_REJECT;
            }
        }
        throw new IllegalArgumentException("Unsupported balancing action " + (Object)((Object)action.balancingAction()) + " is provided.");
    }

    @Override
    public ActionAcceptance partitionActionAcceptance(PartitionBalancingAction action, ClusterModel clusterModel) {
        return ActionAcceptance.REPLICA_REJECT;
    }

    @Override
    public ClusterModelStatsComparator clusterModelStatsComparator() {
        return new ReplicaDistributionGoalStatsComparator();
    }

    @Override
    public String name() {
        return ReplicaDistributionGoal.class.getSimpleName();
    }

    @Override
    protected void initGoalState(ClusterModel clusterModel, OptimizationOptions optimizationOptions, Optional<OptimizationMetrics> optimizationMetricsOpt) {
        super.initGoalState(clusterModel, optimizationOptions, optimizationMetricsOpt);
        clusterModel.trackSortedReplicas(clusterModel.eligibleSourceBrokers(), this.name(), null, ReplicaSortFunctionFactory.prioritizeOfflineReplicasThenImmigrants(), ReplicaSortFunctionFactory.sortByMetricResourceValue(Resource.DISK));
    }

    @Override
    ReplicaDistributionStatsSnapshot.ReplicaResource resource() {
        return ReplicaDistributionStatsSnapshot.ReplicaResource.REPLICA;
    }

    @Override
    protected void updateGoalState(ClusterModel clusterModel, Set<String> excludedTopics) throws OptimizationFailureException {
        try {
            super.updateGoalState(clusterModel, excludedTopics);
        }
        catch (OptimizationFailureException ofe) {
            clusterModel.untrackSortedReplicas(this.name());
            throw ofe;
        }
        if (this.finished) {
            clusterModel.untrackSortedReplicas(this.name());
        }
    }

    @Override
    protected void rebalanceForBroker(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        boolean requireMoreReplicas;
        LOG.debug("Rebalancing broker {} [limits] lower: {} upper: {}.", new Object[]{broker.id(), this.replicaThresholds.numReplicasLowerLimit, this.replicaThresholds.numReplicasUpperLimit});
        int numReplicas = broker.replicas().size();
        int numOfflineReplicas = broker.currentOfflineReplicas().size();
        boolean requireLessReplicas = numOfflineReplicas > 0 || numReplicas > this.replicaThresholds.numReplicasUpperLimit;
        boolean bl = requireMoreReplicas = broker.isAlive() && numReplicas - numOfflineReplicas < this.replicaThresholds.numReplicasLowerLimit;
        if (broker.isAlive() && !requireMoreReplicas && !requireLessReplicas) {
            return;
        }
        if (!(clusterModel.newBrokers().isEmpty() || broker.isNew() || requireLessReplicas)) {
            return;
        }
        if (!clusterModel.selfHealingEligibleReplicas().isEmpty() && broker.currentOfflineReplicas().isEmpty() && requireLessReplicas && broker.immigrantReplicas().isEmpty()) {
            return;
        }
        if (requireLessReplicas && this.rebalanceByMovingReplicasOut(broker, clusterModel, optimizedGoals, optimizationOptions)) {
            this.brokerIdsAboveBalanceUpperLimit.add(broker.id());
            LOG.debug("Failed to sufficiently decrease replica count in broker {} with replica movements. Replicas: {}.", (Object)broker.id(), (Object)broker.replicas().size());
        }
        if (requireMoreReplicas && this.rebalanceByMovingReplicasIn(broker, clusterModel, optimizedGoals, optimizationOptions)) {
            this.brokerIdsUnderBalanceLowerLimit.add(broker.id());
            LOG.debug("Failed to sufficiently increase replica count in broker {} with replica movements. Replicas: {}.", (Object)broker.id(), (Object)broker.replicas().size());
        }
        if (!this.brokerIdsAboveBalanceUpperLimit.contains(broker.id()) && !this.brokerIdsUnderBalanceLowerLimit.contains(broker.id())) {
            LOG.debug("Successfully balanced replica count for broker {} by moving replicas. Replicas: {}", (Object)broker.id(), (Object)broker.replicas().size());
        }
    }

    boolean rebalanceByMovingReplicasOut(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        if (broker.strategy() == Broker.Strategy.IGNORE) {
            throw new IllegalArgumentException("rebalanceByMovingReplicasOut doesn't accept ignored broker as input.");
        }
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        TreeSet<Broker> candidateBrokers = new TreeSet<Broker>(Comparator.comparingInt(b -> b.replicas().size()).thenComparingInt(Broker::id));
        candidateBrokers.addAll(this.fixOfflineReplicasOnly ? clusterModel.eligibleDestinationBrokers() : (Collection)clusterModel.eligibleDestinationBrokers().stream().filter(b -> b.replicas().size() < this.replicaThresholds.numReplicasUpperLimit).collect(Collectors.toSet()));
        List<Replica> replicasToMove = broker.trackedSortedReplicas(this.name()).sortedReplicas();
        if (!clusterModel.selfHealingEligibleReplicas().isEmpty() && broker.isAlive()) {
            replicasToMove = replicasToMove.stream().filter(r -> broker.currentOfflineReplicas().contains(r) || broker.immigrantReplicas().contains(r)).collect(Collectors.toList());
        }
        boolean wasUnableToMoveOfflineReplica = false;
        for (Replica replica : replicasToMove) {
            if (wasUnableToMoveOfflineReplica && !replica.isCurrentOffline() && broker.replicas().size() <= this.replicaThresholds.numReplicasUpperLimit) {
                return false;
            }
            if (ReplicaDistributionGoal.shouldExclude(replica, excludedTopics)) continue;
            Broker b2 = this.maybeApplyBalancingAction(clusterModel, replica, candidateBrokers, ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizedGoals, optimizationOptions, Optional.empty());
            if (b2 != null) {
                if (broker.replicas().size() <= (broker.currentOfflineReplicas().isEmpty() ? this.replicaThresholds.numReplicasUpperLimit : 0)) {
                    return false;
                }
                candidateBrokers.remove(b2);
                if (b2.replicas().size() >= this.replicaThresholds.numReplicasUpperLimit && !this.fixOfflineReplicasOnly) continue;
                candidateBrokers.add(b2);
                continue;
            }
            if (!replica.isCurrentOffline()) continue;
            wasUnableToMoveOfflineReplica = true;
        }
        return !broker.replicas().isEmpty();
    }

    boolean rebalanceByMovingReplicasIn(Broker aliveDestBroker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        if (aliveDestBroker.strategy() == Broker.Strategy.IGNORE) {
            throw new IllegalArgumentException("rebalanceByMovingReplicasIn doesn't accept ignored broker as input.");
        }
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        PriorityQueue<Broker> eligibleBrokers = new PriorityQueue<Broker>((b1, b2) -> {
            int resultByOfflineReplicas = Integer.compare(b2.currentOfflineReplicas().size(), b1.currentOfflineReplicas().size());
            if (resultByOfflineReplicas == 0) {
                int resultByAllReplicas = Integer.compare(b2.replicas().size(), b1.replicas().size());
                return resultByAllReplicas == 0 ? Integer.compare(b1.id(), b2.id()) : resultByAllReplicas;
            }
            return resultByOfflineReplicas;
        });
        if (this.fixOfflineReplicasOnly) {
            clusterModel.eligibleSourceBrokers().stream().filter(sourceBroker -> sourceBroker.id() != aliveDestBroker.id()).forEach(eligibleBrokers::add);
        } else {
            for (Broker sourceBroker2 : clusterModel.eligibleSourceBrokers()) {
                if (sourceBroker2.replicas().size() <= this.replicaThresholds.numReplicasLowerLimit && sourceBroker2.currentOfflineReplicas().isEmpty()) continue;
                eligibleBrokers.add(sourceBroker2);
            }
        }
        List<Broker> candidateBrokers = Collections.singletonList(aliveDestBroker);
        block1: while (!eligibleBrokers.isEmpty()) {
            Broker sourceBroker2;
            sourceBroker2 = (Broker)eligibleBrokers.poll();
            List<Replica> replicasToMove = sourceBroker2.trackedSortedReplicas(this.name()).sortedReplicas();
            if (!clusterModel.selfHealingEligibleReplicas().isEmpty() && sourceBroker2.isAlive()) {
                replicasToMove = replicasToMove.stream().filter(r -> sourceBroker2.currentOfflineReplicas().contains(r) || sourceBroker2.immigrantReplicas().contains(r)).collect(Collectors.toList());
            }
            for (Replica replica : replicasToMove) {
                int result;
                Broker b;
                if (ReplicaDistributionGoal.shouldExclude(replica, excludedTopics) || (b = this.maybeApplyBalancingAction(clusterModel, replica, candidateBrokers, ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizedGoals, optimizationOptions, Optional.empty())) == null) continue;
                if (aliveDestBroker.replicas().size() >= this.replicaThresholds.numReplicasLowerLimit) {
                    return false;
                }
                if (eligibleBrokers.isEmpty() || (result = Integer.compare(sourceBroker2.currentOfflineReplicas().size(), ((Broker)eligibleBrokers.peek()).currentOfflineReplicas().size())) != -1 && (result != 0 || sourceBroker2.replicas().size() >= ((Broker)eligibleBrokers.peek()).replicas().size())) continue;
                eligibleBrokers.add(sourceBroker2);
                continue block1;
            }
        }
        return true;
    }

    private class ReplicaDistributionGoalStatsComparator
    implements ClusterModelStatsComparator {
        private String reasonForLastNegativeResult;

        private ReplicaDistributionGoalStatsComparator() {
        }

        @Override
        public int compare(ClusterModelStats stats1, ClusterModelStats stats2) {
            double stDev1 = stats1.replicaStats().get((Object)Statistic.ST_DEV).doubleValue();
            double stDev2 = stats2.replicaStats().get((Object)Statistic.ST_DEV).doubleValue();
            int result = AnalyzerUtils.compare(stDev2, stDev1, 1.0E-5);
            if (result < 0) {
                this.reasonForLastNegativeResult = String.format("Violated %s. [Std Deviation of Replica Distribution] post-optimization:%.3f pre-optimization:%.3f", ReplicaDistributionGoal.this.name(), stDev1, stDev2);
            }
            return result;
        }

        @Override
        public String explainLastComparison() {
            return this.reasonForLastNegativeResult;
        }
    }
}

