/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals;

import com.linkedin.kafka.cruisecontrol.analyzer.ActionAcceptance;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.AnalyzerUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.PartitionBalancingAction;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.AbstractGoal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.ChainReplicaFilter;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.GoalUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.BrokerResourceStats;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.CandidateBroker;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.DetailedProposal;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.ResourceDistributionStatsSnapshot;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics.OptimizationMetrics;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.thresholds.ResourceUtilizationRatioThresholds;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.thresholds.ResourceUtilizationRatioThresholdsProvider;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.util.ResourceDistributionLogger;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.exception.OptimizationFailureException;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.ClusterModelHelper;
import com.linkedin.kafka.cruisecontrol.model.Load;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.ReplicaSortFunctionFactory;
import com.linkedin.kafka.cruisecontrol.model.Tenant;
import com.linkedin.kafka.cruisecontrol.model.util.BrokerByResourceUtilizationComparator;
import com.linkedin.kafka.cruisecontrol.model.util.ClusterModelStatsByResourceUtilizationDeviationComparator;
import com.linkedin.kafka.cruisecontrol.model.util.ClusterModelStatsComparator;
import com.linkedin.kafka.cruisecontrol.model.util.ReplicaByResourceUtilizationComparator;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import io.confluent.databalancer.DatabalancerUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceDistributionAbstractGoal
extends AbstractGoal {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceDistributionAbstractGoal.class);
    protected boolean fixOfflineReplicasOnly;
    protected Map<Integer, BrokerResourceStats> initialResourceDistribution;
    protected ResourceUtilizationRatioThresholdsProvider thresholds;
    protected boolean requireLessLoad;
    protected boolean requireMoreLoad;
    protected boolean moveImmigrantsOnly;

    public ResourceDistributionAbstractGoal() {
    }

    ResourceDistributionAbstractGoal(BalancingConstraint balancingConstraint) {
        this.balancingConstraint = balancingConstraint;
    }

    boolean fixOfflineReplicasOnly() {
        return this.fixOfflineReplicasOnly;
    }

    void setFixOfflineReplicasOnly() {
        this.fixOfflineReplicasOnly = true;
    }

    protected abstract Resource resource();

    protected boolean validatePercentages() {
        return true;
    }

    @Override
    public ActionAcceptance partitionActionAcceptance(PartitionBalancingAction action, ClusterModel clusterModel) {
        return ActionAcceptance.REPLICA_REJECT;
    }

    @Override
    public ClusterModelStatsComparator clusterModelStatsComparator() {
        return new ClusterModelStatsByResourceUtilizationDeviationComparator(this.name(), this.resource());
    }

    @Override
    public ModelCompletenessRequirements clusterModelCompletenessRequirements() {
        return new ModelCompletenessRequirements(Math.max(1, this.numWindows / 2), this.minMonitoredPartitionPercentage, false);
    }

    @Override
    public abstract String name();

    @Override
    public boolean isHardGoal() {
        return false;
    }

    @Override
    public boolean partitionActionSelfSatisfied(ClusterModel clusterModel, PartitionBalancingAction action) {
        return false;
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    protected void initGoalState(ClusterModel clusterModel, OptimizationOptions optimizationOptions, Optional<OptimizationMetrics> optimizationMetricsOpt) throws OptimizationFailureException {
        this.fixOfflineReplicasOnly = false;
        this.thresholds = this.computeThresholds(clusterModel, optimizationOptions);
        this.initialResourceDistribution = this.computeInitialResourceDistribution(clusterModel);
        clusterModel.trackSortedReplicas(clusterModel.eligibleSourceOrDestinationBrokers(), this.sortName(), null, ReplicaSortFunctionFactory.deprioritizeOfflineReplicasThenImmigrants(), ReplicaSortFunctionFactory.sortByMetricResourceValue(this.resource()));
        this.logInitialStats(clusterModel, optimizationOptions, optimizationMetricsOpt);
    }

    private void logInitialStats(ClusterModel clusterModel, OptimizationOptions optimizationOptions, Optional<OptimizationMetrics> optimizationMetricsOpt) {
        List<ResourceDistributionStatsSnapshot> statsSnapshot = this.tryToComputeResourceDistributionStatsSnapshot(this.initialResourceDistribution.values());
        ResourceDistributionLogger.builder().goalName(this.name()).thresholds(this.thresholds).cells(clusterModel.cells()).optimizationOptions(optimizationOptions).statsSnapshot(statsSnapshot).build().logResourceDistribution();
        if (statsSnapshot.isEmpty()) {
            LOG.warn("Will not be reporting metrics as part of evaluating whether to trigger the even-cluster load task for {} because a resource distribution stats snapshot could not be computed. Check the previous logs for more information and whether the cluster had the same capacities per broker.", this.getClass());
        } else {
            optimizationMetricsOpt.ifPresent(optimizationMetrics -> optimizationMetrics.recordDistributionBalanceStats(this, statsSnapshot));
        }
        GoalUtils.analyzeHotPartitions(clusterModel.eligibleSourceOrDestinationBrokers(), Resource.CompositeResource.ofResource(this.resource()), this.balancingConstraint, this.name(), this.sortName());
    }

    private ResourceUtilizationRatioThresholdsProvider computeThresholds(ClusterModel clusterModel, OptimizationOptions optimizationOptions) {
        ResourceUtilizationRatioThresholds clusterThresholds = this.balancingThresholds(clusterModel, optimizationOptions, this.validatePercentages());
        Map<Integer, ResourceUtilizationRatioThresholds> cellThresholds = clusterModel.cells().stream().collect(Collectors.toMap(Cell::id, cell -> this.balancingThresholdsForCell((Cell)cell, optimizationOptions, this.validatePercentages())));
        return new ResourceUtilizationRatioThresholdsProvider(clusterThresholds, cellThresholds);
    }

    private Map<Integer, BrokerResourceStats> computeInitialResourceDistribution(ClusterModel clusterModel) {
        return Collections.unmodifiableMap(clusterModel.eligibleDestinationBrokers().stream().map(broker -> new BrokerResourceStats(broker.capacity().totalCapacityFor(this.resource()), broker.load().expectedUtilizationFor(this.resource()), broker.id(), this.resource(), broker.cell().id())).collect(Collectors.toMap(BrokerResourceStats::brokerId, Function.identity())));
    }

    protected abstract ResourceUtilizationRatioThresholds balancingThresholds(ClusterModel var1, OptimizationOptions var2, boolean var3);

    protected abstract ResourceUtilizationRatioThresholds balancingThresholdsForCell(Cell var1, OptimizationOptions var2, boolean var3);

    List<ResourceDistributionStatsSnapshot> tryToComputeResourceDistributionStatsSnapshot(Collection<BrokerResourceStats> brokerResourceStats) {
        return ResourceDistributionStatsSnapshot.tryCompute(brokerResourceStats, this.thresholds);
    }

    @Override
    protected void rebalanceForBroker(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) throws OptimizationFailureException {
        int numOfflineReplicas = broker.currentOfflineReplicas().size();
        if (numOfflineReplicas == 0 && ClusterModelHelper.brokersWithUtilizationOverLowUtilizationRatioThreshold(this.brokersToBalance(clusterModel), this.thresholds).isEmpty()) {
            return;
        }
        this.requireLessLoad = broker.isEligibleSource() && (numOfflineReplicas > 0 || !this.isLoadUnderBalanceUpperLimit(broker));
        this.requireMoreLoad = broker.isEligibleDestination() && !this.isLoadAboveBalanceLowerLimit(broker);
        this.moveImmigrantsOnly = false;
        if (broker.currentOfflineReplicas().isEmpty()) {
            if (!this.requireMoreLoad && !this.requireLessLoad) {
                return;
            }
            boolean bl = this.moveImmigrantsOnly = !clusterModel.selfHealingEligibleReplicas().isEmpty();
            if (this.moveImmigrantsOnly && this.requireLessLoad && broker.immigrantReplicas().isEmpty()) {
                return;
            }
        }
        this.doRebalance(broker, clusterModel, optimizedGoals, optimizationOptions);
    }

    protected abstract void doRebalance(Broker var1, ClusterModel var2, Set<Goal> var3, OptimizationOptions var4);

    protected void performLeadershipMovement(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        if (this.shouldTryLeadershipMovement(this.resource()) && (!this.fixOfflineReplicasOnly || broker.currentOfflineReplicas().isEmpty())) {
            if (this.requireLessLoad) {
                this.requireLessLoad = this.rebalanceByMovingLoadOut(broker, clusterModel, optimizedGoals, ActionType.LEADERSHIP_MOVEMENT, optimizationOptions);
            }
            if (this.requireMoreLoad) {
                this.requireMoreLoad = this.rebalanceByMovingLoadIn(broker, clusterModel, optimizedGoals, ActionType.LEADERSHIP_MOVEMENT, optimizationOptions, false);
            }
        }
    }

    protected void performReplicaMovement(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, OptimizationOptions optimizationOptions) {
        if (this.requireLessLoad) {
            this.requireLessLoad = this.rebalanceByMovingLoadOut(broker, clusterModel, optimizedGoals, ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizationOptions);
        }
        if (this.requireMoreLoad) {
            this.requireMoreLoad = this.rebalanceByMovingLoadIn(broker, clusterModel, optimizedGoals, ActionType.INTER_BROKER_REPLICA_MOVEMENT, optimizationOptions, this.moveImmigrantsOnly);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean rebalanceByMovingLoadOut(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, ActionType actionType, OptimizationOptions optimizationOptions) {
        boolean balancingCompleted;
        void var9_12;
        if (broker.strategy() == Broker.Strategy.IGNORE) {
            throw new IllegalArgumentException("rebalanceByMovingLoadOut doesn't accept ignored broker as input.");
        }
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        SortedSet<Broker> clusterWideCandidateBrokers = this.eligibleClusterWideCandidateBrokers(clusterModel);
        SortedSet<Object> cellCandidateBrokers = Collections.emptySortedSet();
        if (!broker.cell().isImaginaryCell()) {
            cellCandidateBrokers = this.eligibleCellCandidateBrokers(broker);
        }
        List<Replica> list = broker.trackedSortedReplicas(this.sortName()).reverselySortedReplicas();
        if (actionType == ActionType.LEADERSHIP_MOVEMENT) {
            List list2 = list.stream().filter(Replica::isLeader).collect(Collectors.toList());
        } else if (!clusterModel.selfHealingEligibleReplicas().isEmpty() && broker.isAlive()) {
            List list3 = list.stream().filter(r -> broker.currentOfflineReplicas().contains(r) || broker.immigrantReplicas().contains(r)).collect(Collectors.toList());
        }
        for (Replica replica : var9_12) {
            Broker destination2;
            SortedSet eligibleBrokers;
            if (ResourceDistributionAbstractGoal.shouldExclude(replica, excludedTopics)) continue;
            double replicaLoad = replica.load().expectedUtilizationFor(this.resource());
            if (AnalyzerUtils.isEqual(replicaLoad, 0.0) && !replica.isCurrentOffline()) break;
            String tenantId = DatabalancerUtils.getTenantId(replica);
            if (Objects.nonNull(tenantId)) {
                if (broker.cell().isImaginaryCell()) {
                    Optional<Integer> cellId = clusterModel.tenant(tenantId).map(Tenant::cellId);
                    if (!cellId.isPresent()) throw new IllegalStateException(String.format("Found tenant id (%s) without associated cell.", tenantId));
                    Cell cell = clusterModel.cell(cellId.get());
                    if (cell == null) {
                        throw new IllegalStateException(String.format("The cluster model did not have knowledge for cell with id %s", cellId.get()));
                    }
                    eligibleBrokers = cell.brokers().stream().findAny().map(this::eligibleCellCandidateBrokers).orElseGet(Collections::emptySortedSet);
                } else {
                    eligibleBrokers = cellCandidateBrokers;
                }
            } else {
                eligibleBrokers = clusterWideCandidateBrokers;
            }
            if (actionType == ActionType.LEADERSHIP_MOVEMENT) {
                eligibleBrokers = new TreeSet<Broker>(BrokerByResourceUtilizationComparator.of(this.resource(), false));
                clusterModel.partition(replica.topicPartition()).onlineFollowerBrokers().stream().filter(clusterWideCandidateBrokers::contains).forEach(eligibleBrokers::add);
            }
            double currentBrokerResourceUtilization = broker.load(this.resource()).expectedUtilizationFor(this.resource());
            DetailedProposal.DetailedReasonBuilder detailedReasonBuilder = destination -> String.format("Moving %.2f of %s load out from broker %d to %s in order to decrease the usage on Broker %d by %.2f - Current utilization: %.2f - Target utilization: %.2f", new Object[]{replicaLoad, this.resource(), broker.id(), destination, broker.id(), replicaLoad, currentBrokerResourceUtilization, this.thresholds.balanceUpperThreshold(broker)});
            Optional<DetailedProposal.Builder> detailedProposalOptional = Optional.empty();
            if (this.proposalTrackingOptions().isEnabled) {
                detailedProposalOptional = Optional.of(DetailedProposal.builder(replica.topicPartition(), broker.id(), replicaLoad, actionType));
            }
            if ((destination2 = this.maybeApplyBalancingAction(clusterModel, replica, eligibleBrokers, actionType, optimizedGoals, optimizationOptions, detailedReasonBuilder, detailedProposalOptional)) == null) continue;
            if ((!this.fixOfflineReplicasOnly || broker.currentOfflineReplicas().isEmpty()) && this.isRebalanceByMovingLoadOutCompleted(broker)) {
                LOG.debug("Successfully balanced {} for broker {} by moving {} out.", new Object[]{this.resource(), broker.id(), actionType});
                return false;
            }
            clusterWideCandidateBrokers.remove(destination2);
            cellCandidateBrokers.remove(destination2);
            if (!this.fixOfflineReplicasOnly && !AnalyzerUtils.isSmaller(GoalUtils.utilizationPercentage(destination2, this.resource()), this.thresholds.balanceUpperThreshold(destination2))) continue;
            clusterWideCandidateBrokers.add(destination2);
            cellCandidateBrokers.add(destination2);
        }
        if (balancingCompleted = broker.replicas().isEmpty()) {
            LOG.debug("Successfully balanced {} for broker {} by moving {} out.", new Object[]{this.resource(), broker.id(), actionType});
        }
        if (balancingCompleted) return false;
        return true;
    }

    private SortedSet<Broker> eligibleCellCandidateBrokers(Broker broker) {
        return this.eligibleCandidateBrokers(broker.cell().eligibleDestinationBrokers());
    }

    private SortedSet<Broker> eligibleClusterWideCandidateBrokers(ClusterModel clusterModel) {
        return this.eligibleCandidateBrokers(clusterModel.eligibleDestinationBrokers());
    }

    private SortedSet<Broker> eligibleCandidateBrokers(Collection<Broker> allBrokers) {
        TreeSet<Broker> candidateBrokers = new TreeSet<Broker>(BrokerByResourceUtilizationComparator.of(this.resource(), false));
        if (this.fixOfflineReplicasOnly) {
            candidateBrokers.addAll(allBrokers);
        } else {
            candidateBrokers.addAll(ClusterModelHelper.brokersWithUtilizationUnderCapacityThreshold(allBrokers, this.resource(), b -> this.thresholds.balanceUpperThreshold(b)));
        }
        return candidateBrokers;
    }

    protected abstract boolean isRebalanceByMovingLoadOutCompleted(Broker var1);

    boolean rebalanceByMovingLoadIn(Broker broker, ClusterModel clusterModel, Set<Goal> optimizedGoals, ActionType actionType, OptimizationOptions optimizationOptions, boolean moveImmigrantsOnly) {
        CandidateBroker cb;
        if (broker.strategy() == Broker.Strategy.IGNORE) {
            throw new IllegalArgumentException("rebalanceByMovingLoadIn doesn't accept ignored broker as input.");
        }
        if (!clusterModel.newBrokers().isEmpty() && !broker.isNew()) {
            return true;
        }
        Set<String> excludedTopics = optimizationOptions.excludedTopics();
        Set<Integer> excludedBrokersForLeadership = optimizationOptions.excludedBrokersForLeadership();
        Set<Integer> excludedBrokersForReplicaMove = optimizationOptions.excludedBrokersForReplicaMove();
        boolean moveFollowersOnly = excludedBrokersForLeadership.contains(broker.id());
        PriorityQueue<CandidateBroker> candidateBrokerPQ = new PriorityQueue<CandidateBroker>();
        Collection<Broker> eligibleSourceBrokers = clusterModel.eligibleSourceBrokers();
        if (!broker.cell().isImaginaryCell()) {
            eligibleSourceBrokers = broker.cell().eligibleSourceBrokers();
        }
        for (Broker candidate : eligibleSourceBrokers) {
            if (!AnalyzerUtils.isLarger(GoalUtils.utilizationPercentage(candidate, this.resource()), this.thresholds.meanUtilizationRatio(candidate))) continue;
            TreeSet<Replica> replicasToMoveIn = new TreeSet<Replica>(ReplicaByResourceUtilizationComparator.of(this.resource()));
            ChainReplicaFilter replicaFilter = new ChainReplicaFilter(replica -> !ResourceDistributionAbstractGoal.shouldExclude(replica, excludedTopics), replica -> AnalyzerUtils.isLarger(replica.load().expectedUtilizationFor(this.resource()), 0.0));
            Set<Replica> filteredReplicas = GoalUtils.filterReplicas(candidate, moveFollowersOnly, false, moveImmigrantsOnly, replicaFilter);
            replicasToMoveIn.addAll(filteredReplicas);
            CandidateBroker candidateBroker = new CandidateBroker(candidate, this.resource(), replicasToMoveIn, false, excludedBrokersForLeadership, excludedBrokersForReplicaMove);
            candidateBrokerPQ.add(candidateBroker);
        }
        block1: while ((actionType == ActionType.INTER_BROKER_REPLICA_MOVEMENT || actionType == ActionType.LEADERSHIP_MOVEMENT && broker.leaderReplicas().size() != broker.replicas().size()) && (cb = (CandidateBroker)candidateBrokerPQ.poll()) != null) {
            Iterator iterator = cb.replicas().iterator();
            while (iterator.hasNext()) {
                double resourceUtilizationRatioFromNextSource;
                double resourceUtilizationRatioFromCurrentSource;
                CandidateBroker nextSource;
                boolean appliedBalancingAction;
                Replica replica2 = (Replica)iterator.next();
                double replicaResourceUtilization = replica2.load().expectedUtilizationFor(this.resource());
                double currentBrokerResourceUtilization = broker.load(this.resource()).expectedUtilizationFor(this.resource());
                DetailedProposal.DetailedReasonBuilder detailedReasonBuilder = destination -> String.format("Moving %.2f of %s load in from broker %d to %s in order to increase the usage on Broker %d by %.2f - Current utilization: %.2f - Target utilization: %.2f", new Object[]{replicaResourceUtilization, this.resource(), cb.broker().id(), destination, broker.id(), replicaResourceUtilization, currentBrokerResourceUtilization, this.thresholds.balanceLowerThreshold(broker)});
                Optional<DetailedProposal.Builder> detailedProposalOptional = Optional.empty();
                if (this.proposalTrackingOptions().isEnabled) {
                    detailedProposalOptional = Optional.of(DetailedProposal.builder(replica2.topicPartition(), broker.id(), replicaResourceUtilization, actionType));
                }
                if (!(appliedBalancingAction = this.maybeApplyBalancingAction(clusterModel, replica2, Collections.singletonList(broker), actionType, optimizedGoals, optimizationOptions, detailedReasonBuilder, detailedProposalOptional) != null)) continue;
                if (this.isRebalanceByMovingLoadInCompleted(broker)) {
                    LOG.debug("Successfully balanced {} for broker {} by moving {} in.", new Object[]{this.resource(), broker.id(), actionType});
                    return false;
                }
                if (actionType == ActionType.INTER_BROKER_REPLICA_MOVEMENT) {
                    iterator.remove();
                }
                if ((nextSource = (CandidateBroker)candidateBrokerPQ.peek()) == null || !AnalyzerUtils.isSmaller(resourceUtilizationRatioFromCurrentSource = GoalUtils.utilizationPercentage(cb.broker(), this.resource()), resourceUtilizationRatioFromNextSource = GoalUtils.utilizationPercentage(nextSource.broker(), this.resource()))) continue;
                candidateBrokerPQ.add(cb);
                continue block1;
            }
        }
        return true;
    }

    protected abstract boolean isRebalanceByMovingLoadInCompleted(Broker var1);

    protected boolean isLoadAboveBalanceLowerLimit(Broker broker) {
        return this.isLoadAboveBalanceLowerLimitAfterChange(null, broker, ChangeType.ADD);
    }

    protected boolean isLoadUnderBalanceUpperLimit(Broker broker) {
        return this.isLoadUnderBalanceUpperLimitAfterChange(null, broker, ChangeType.REMOVE);
    }

    protected boolean isLoadAboveBalanceLowerLimitAfterChange(Load load, Broker broker, ChangeType changeType) {
        boolean isBrokerAboveLowerLimit;
        double utilizationDelta = load == null ? 0.0 : load.expectedUtilizationFor(this.resource());
        double brokerBalanceLowerLimit = broker.capacity().totalCapacityFor(this.resource()) * this.thresholds.balanceLowerThreshold(broker);
        double brokerUtilization = broker.load().expectedUtilizationFor(this.resource());
        brokerUtilization = changeType == ChangeType.ADD ? brokerUtilization + utilizationDelta : brokerUtilization - utilizationDelta;
        boolean bl = isBrokerAboveLowerLimit = !AnalyzerUtils.isSmaller(brokerUtilization, brokerBalanceLowerLimit);
        if (this.resource().isHostResource()) {
            double hostBalanceLowerLimit = broker.host().capacity().totalCapacityFor(this.resource()) * this.thresholds.balanceLowerThreshold(broker);
            double hostUtilization = broker.host().load().expectedUtilizationFor(this.resource());
            hostUtilization = changeType == ChangeType.ADD ? hostUtilization + utilizationDelta : hostUtilization - utilizationDelta;
            boolean isHostAboveLowerLimit = !AnalyzerUtils.isSmaller(hostUtilization, hostBalanceLowerLimit);
            return isHostAboveLowerLimit || isBrokerAboveLowerLimit;
        }
        return isBrokerAboveLowerLimit;
    }

    protected boolean isLoadUnderBalanceUpperLimitAfterChange(Load load, Broker broker, ChangeType changeType) {
        boolean isBrokerUnderUpperLimit;
        double utilizationDelta = load == null ? 0.0 : load.expectedUtilizationFor(this.resource());
        double brokerBalanceUpperLimit = broker.capacity().totalCapacityFor(this.resource()) * this.thresholds.balanceUpperThreshold(broker);
        double brokerUtilization = broker.load().expectedUtilizationFor(this.resource());
        brokerUtilization = changeType == ChangeType.ADD ? brokerUtilization + utilizationDelta : brokerUtilization - utilizationDelta;
        boolean bl = isBrokerUnderUpperLimit = !AnalyzerUtils.isLarger(brokerUtilization, brokerBalanceUpperLimit);
        if (this.resource().isHostResource()) {
            double hostBalanceUpperLimit = broker.host().capacity().totalCapacityFor(this.resource()) * this.thresholds.balanceUpperThreshold(broker);
            double hostUtilization = broker.host().load().expectedUtilizationFor(this.resource());
            hostUtilization = changeType == ChangeType.ADD ? hostUtilization + utilizationDelta : hostUtilization - utilizationDelta;
            boolean isHostUnderUpperLimit = !AnalyzerUtils.isLarger(hostUtilization, hostBalanceUpperLimit);
            return isHostUnderUpperLimit || isBrokerUnderUpperLimit;
        }
        return isBrokerUnderUpperLimit;
    }

    protected String sortName() {
        return this.name() + "-" + this.resource().name() + "-ALL";
    }

    protected static enum ChangeType {
        ADD,
        REMOVE;

    }
}

