/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.analyzer.goals.metrics;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.internals.CapacityStatsSnapshot;
import io.confluent.databalancer.metrics.DataBalancerMetricsRegistry;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class CapacityGoalMetrics {
    static final String NUM_HOT_PARTITIONS_METRIC_NAME = "num-hot-partitions";
    static final String EFFECTIVE_MAX_CAPACITY_METRIC_NAME = "effective-max-capacity";
    static final String MAX_REPLICA_LOAD = "max-replica-load";
    private String goalName;
    private DataBalancerMetricsRegistry metricsRegistry;
    private Class<?> metricClass;
    private volatile int numHotPartitions;
    private volatile double effectiveMaxCapacity;
    private volatile double maxReplicaLoad;
    private final SortedMap<String, String> tags;

    public CapacityGoalMetrics(String goalName, DataBalancerMetricsRegistry metricsRegistry, Class<?> metricClass) {
        this.tags = Collections.unmodifiableSortedMap(new TreeMap<String, String>(Collections.singletonMap("goal", this.goalName)));
        this.goalName = goalName;
        this.metricsRegistry = metricsRegistry;
        this.metricClass = metricClass;
        this.registerMetrics(metricClass);
    }

    public void update(CapacityStatsSnapshot statsSnapshot) {
        this.numHotPartitions = statsSnapshot.numHotPartitions;
        this.effectiveMaxCapacity = statsSnapshot.effectiveCapacity;
        this.maxReplicaLoad = statsSnapshot.maxReplicaLoad;
    }

    protected final void registerMetrics(Class<?> metricClass) {
        this.metricsRegistry.newGauge(metricClass, NUM_HOT_PARTITIONS_METRIC_NAME, () -> this.numHotPartitions, this.tags);
        this.metricsRegistry.newGauge(metricClass, EFFECTIVE_MAX_CAPACITY_METRIC_NAME, () -> this.effectiveMaxCapacity, this.tags);
        this.metricsRegistry.newGauge(metricClass, MAX_REPLICA_LOAD, () -> this.maxReplicaLoad, this.tags);
    }
}

