/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.config;

import com.linkedin.kafka.cruisecontrol.common.Resource;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class BrokerCapacityInfo {
    public static final short DEFAULT_NUM_CPU_CORES = 1;
    private static final String DEFAULT_ESTIMATION_INFO = "";
    static final Map<String, Double> EMPTY_DISK_CAPACITY_BY_LOG_DIR = Collections.emptyMap();
    private final Map<Resource, Double> capacity;
    private final String estimationInfo;
    private final Map<String, Double> diskCapacityByLogDir;
    private final short numCpuCores;

    public static BrokerCapacityInfoBuilder builder() {
        return new BrokerCapacityInfoBuilder();
    }

    private BrokerCapacityInfo(Map<Resource, Double> capacity, String estimationInfo, Map<String, Double> diskCapacityByLogDir, short numCpuCores) {
        this.capacity = capacity;
        this.estimationInfo = estimationInfo;
        this.diskCapacityByLogDir = diskCapacityByLogDir;
        this.numCpuCores = numCpuCores;
    }

    public Map<Resource, Double> capacity() {
        return Collections.unmodifiableMap(this.capacity);
    }

    public boolean isEstimated() {
        return !this.estimationInfo.isEmpty();
    }

    public String estimationInfo() {
        return this.estimationInfo;
    }

    public Map<String, Double> diskCapacityByLogDir() {
        return Collections.unmodifiableMap(this.diskCapacityByLogDir);
    }

    public short numCpuCores() {
        return this.numCpuCores;
    }

    public static class BrokerCapacityInfoBuilder {
        private Map<Resource, Double> capacity = Collections.emptyMap();
        private String estimationInfo = "";
        private Map<String, Double> diskCapacityByLogDir = EMPTY_DISK_CAPACITY_BY_LOG_DIR;
        private short numCpuCores = 1;

        public BrokerCapacityInfoBuilder capacity(Map<Resource, Double> capacity) {
            Objects.requireNonNull(capacity, "Provided capacity cannot be null.");
            this.capacity = capacity;
            return this;
        }

        public BrokerCapacityInfoBuilder numCpuCores(short numCpuCores) {
            if (numCpuCores <= 0) {
                throw new IllegalArgumentException(String.format("Cannot have zero or negative numCpuCores (given: %d).", numCpuCores));
            }
            this.numCpuCores = numCpuCores;
            return this;
        }

        public BrokerCapacityInfoBuilder estimationInfo(String estimationInfo) {
            Objects.requireNonNull(estimationInfo, "Provided estimationInfo cannot be null.");
            this.estimationInfo = estimationInfo;
            return this;
        }

        public BrokerCapacityInfoBuilder diskCapacityByLogDir(Map<String, Double> diskCapacityByLogDir) {
            Objects.requireNonNull(diskCapacityByLogDir, "Provided diskCapacityByLogDir cannot be null.");
            this.diskCapacityByLogDir = diskCapacityByLogDir;
            return this;
        }

        public BrokerCapacityInfo build() {
            return new BrokerCapacityInfo(this.capacity, this.estimationInfo, this.diskCapacityByLogDir, this.numCpuCores);
        }
    }
}

