/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.common.KafkaCruiseControlThreadFactory;
import com.linkedin.kafka.cruisecontrol.common.MetadataClient;
import com.linkedin.kafka.cruisecontrol.common.SbcClusterSnapshot;
import com.linkedin.kafka.cruisecontrol.common.SbkAdminUtils;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyDetector;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyType;
import com.linkedin.kafka.cruisecontrol.executor.AbstractExecutorReplicaMovement;
import com.linkedin.kafka.cruisecontrol.executor.DeadExecutionTaskException;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionMetricsReporter;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionProposal;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTask;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTaskManager;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTaskTracker;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorInterBrokerReplicaMovement;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorIntraBrokerReplicaMovement;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorLeadershipReplicaMovement;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorMetricsHandle;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorNotification;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorNotifier;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorReservationHandle;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorState;
import com.linkedin.kafka.cruisecontrol.executor.ReplicationThrottleHelper;
import com.linkedin.kafka.cruisecontrol.model.ReplicaPlacementInfo;
import com.linkedin.kafka.cruisecontrol.monitor.LoadMonitor;
import io.confluent.databalancer.metrics.DataBalancerMetricsRegistry;
import io.confluent.databalancer.operation.BalanceOpExecutionCompletionCallback;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Executor {
    private static final Logger LOG = LoggerFactory.getLogger(Executor.class);
    private static final long EXECUTION_HISTORY_SCANNER_PERIOD_SECONDS = 5L;
    private static final long EXECUTION_HISTORY_SCANNER_INITIAL_DELAY_SECONDS = 0L;
    private ExecutionTaskManager executionTaskManager;
    private final MetadataClient metadataClient;
    private final long statusCheckingIntervalMs;
    private final long leaderActionTimeoutMs;
    private final long invalidReplicaAssignmentRetryMs;
    private final Duration executorRefreshTime;
    private ExecutorService proposalExecutor;
    private final ConfluentAdmin adminClient;
    private SbkAdminUtils adminUtils;
    private final AtomicBoolean stopRequested;
    private final Time time;
    private volatile boolean hasOngoingExecution;
    private final ExecutorReservation reservation = new ExecutorReservation();
    private volatile ExecutorState executorState;
    private volatile String uuid;
    private volatile MetadataClient.ClusterAndGeneration clusterMetadataAtProposalInitialization;
    private ExecutorNotifier executorNotifier;
    private final AtomicInteger numExecutionsStarted;
    private final AtomicInteger numExecutionStopped = new AtomicInteger(0);
    private final AtomicBoolean executionStoppedByUser;
    private final AtomicBoolean executionStopShouldInvalidateMetrics;
    private final AtomicInteger numCancelledReassignments;
    private final AtomicInteger numFailedReassignmentCancellations;
    private final ExecutionMetricsReporter executionMetricsReporter;
    private final long removalHistoryRetentionTimeMs;
    private final ConcurrentMap<Integer, Long> latestRemoveStartTimeMsByBrokerId;
    private ScheduledExecutorService executionHistoryScannerExecutor;
    private final AnomalyDetector anomalyDetector;
    private ReplicationThrottleHelper throttleHelper;
    private final KafkaCruiseControlConfig config;
    private final DataBalancerMetricsRegistry metricRegistry;

    public Executor(KafkaCruiseControlConfig config, Time time, DataBalancerMetricsRegistry metricRegistry, MetadataClient metadataClient, long removalHistoryRetentionTimeMs, ExecutorNotifier executorNotifier, AnomalyDetector anomalyDetector, ConfluentAdmin adminClient, ReplicationThrottleHelper throttleHelper) {
        this(config, time, metricRegistry, metadataClient, removalHistoryRetentionTimeMs, executorNotifier, anomalyDetector, adminClient, throttleHelper, null);
    }

    Executor(KafkaCruiseControlConfig config, Time time, DataBalancerMetricsRegistry metricRegistry, MetadataClient metadataClient, long removalHistoryRetentionTimeMs, ExecutorNotifier executorNotifier, AnomalyDetector anomalyDetector, ConfluentAdmin adminClient, ReplicationThrottleHelper throttleHelper, ExecutorService proposalExecutorService) {
        this.numExecutionsStarted = new AtomicInteger(0);
        this.executionStoppedByUser = new AtomicBoolean(false);
        this.executionStopShouldInvalidateMetrics = new AtomicBoolean(true);
        this.numCancelledReassignments = new AtomicInteger(0);
        this.numFailedReassignmentCancellations = new AtomicInteger(0);
        this.config = config;
        this.time = time;
        this.metricRegistry = metricRegistry;
        this.metadataClient = Objects.requireNonNull(metadataClient, "The provided MetadataClient was null");
        this.executorNotifier = executorNotifier;
        this.adminClient = adminClient;
        this.throttleHelper = throttleHelper;
        this.statusCheckingIntervalMs = config.getLong("execution.progress.check.interval.ms");
        this.leaderActionTimeoutMs = config.getLong("executor.leader.action.timeout.ms");
        this.invalidReplicaAssignmentRetryMs = config.getLong("invalid.replica.assignment.retry.timeout.ms");
        this.executorRefreshTime = Duration.ofMillis(config.getLong("executor.reservation.refresh.time.ms"));
        this.proposalExecutor = proposalExecutorService;
        this.latestRemoveStartTimeMsByBrokerId = new ConcurrentHashMap<Integer, Long>();
        this.stopRequested = new AtomicBoolean(false);
        this.hasOngoingExecution = false;
        this.uuid = null;
        this.anomalyDetector = anomalyDetector;
        this.removalHistoryRetentionTimeMs = removalHistoryRetentionTimeMs;
        this.executionMetricsReporter = new ExecutionMetricsReporter(metricRegistry);
    }

    public void init() {
        if (this.proposalExecutor == null) {
            this.proposalExecutor = Executors.newSingleThreadExecutor(new KafkaCruiseControlThreadFactory("ProposalExecutor", false, LOG));
        }
        this.adminUtils = new SbkAdminUtils(this.adminClient, this.config);
        this.executionTaskManager = new ExecutionTaskManager(this.config.getInt("num.concurrent.partition.movements.per.broker"), this.config.getInt("num.concurrent.intra.broker.partition.movements"), this.config.getInt("num.concurrent.leader.movements"), this.config.getList("default.replica.movement.strategies"), this.adminClient, this.metricRegistry, this.time, this.config);
        this.executorState = ExecutorState.noTaskInProgress(this.recentlyRemovedBrokers());
        this.executorNotifier = this.executorNotifier != null ? this.executorNotifier : this.config.getConfiguredInstance("executor.notifier.class", ExecutorNotifier.class);
        this.executionHistoryScannerExecutor = Executors.newSingleThreadScheduledExecutor(new KafkaCruiseControlThreadFactory("ExecutionHistoryScanner", true, null));
        this.executionHistoryScannerExecutor.scheduleAtFixedRate(new ExecutionHistoryScanner(), 0L, 5L, TimeUnit.SECONDS);
        this.throttleHelper = this.throttleHelper != null ? this.throttleHelper : new ReplicationThrottleHelper((Admin)this.adminClient, this.config, this.time);
        this.registerGaugeSensors();
    }

    List<ExecutionTask> deadExecutionTasks() {
        return this.executionTaskManager.deadExecutionTasks();
    }

    private void registerGaugeSensors() {
        this.executionMetricsReporter.registerExecutionStartedGauge(this::numExecutionsStarted);
        this.executionMetricsReporter.registerExecutionStoppedGauge(this::numExecutionStopped);
        this.executionMetricsReporter.registerCancelledReassignmentsGauge(this::numCancelledReassignments);
        this.executionMetricsReporter.registerFailedReassignmentCancellationsGauge(this::numFailedReassignmentCancellations);
    }

    public void startUp() throws ExecutionException, InterruptedException {
        if (!((Map)this.adminClient.listPartitionReassignments().reassignments().get()).isEmpty()) {
            this.hasOngoingExecution = true;
            LOG.info("Detected ongoing reassignment while starting up. Monitoring it to remove throttles once it completes.");
            Thread thread = new Thread(() -> {
                while (true) {
                    try {
                        while (!((Map)this.adminClient.listPartitionReassignments().reassignments().get()).isEmpty()) {
                            LOG.debug("Sleeping {} ms while waiting for ongoing reassignment to complete", (Object)this.statusCheckingIntervalMs);
                            Thread.sleep(this.statusCheckingIntervalMs);
                        }
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        continue;
                    }
                    break;
                }
                this.removeThrottles();
                LOG.info("Ongoing reassignment that was detected while starting up has finished.");
                this.hasOngoingExecution = false;
            });
            thread.start();
        } else {
            this.removeThrottles();
        }
    }

    public ExecutorReservationHandle reserveAndAbortOngoingExecutions(Duration executionAbortTimeout, String reason) throws TimeoutException {
        return this.reserveAndAbortOngoingExecutions(executionAbortTimeout, true, reason);
    }

    public ExecutorReservationHandle reserveAndAbortOngoingExecutions(Duration executionAbortTimeout, boolean shouldInvalidateMetrics, String reason) throws TimeoutException {
        return ExecutorReservationHandle.reserveAndAbortOngoingExecutions(this, this.time, executionAbortTimeout, this.executorRefreshTime, shouldInvalidateMetrics, reason);
    }

    ExecutorReservation reservation() {
        return this.reservation;
    }

    public synchronized void triggerStopExecution(String reason) {
        this.triggerStopExecution(true, reason);
    }

    public synchronized void triggerStopExecution(boolean shouldInvalidateMetrics, String reason) {
        if (this.stopExecution()) {
            LOG.info("The executor was requested to stop the ongoing proposal execution and cancel the existing reassignments. Reason: {}", (Object)reason);
            this.executionStoppedByUser.set(true);
            this.executionStopShouldInvalidateMetrics.set(shouldInvalidateMetrics);
        }
    }

    public void dropRecentlyRemovedBrokers(Set<Integer> brokersToDrop) {
        this.latestRemoveStartTimeMsByBrokerId.keySet().removeAll(brokersToDrop);
    }

    public synchronized void shutdown() {
        LOG.info("Shutting down executor.");
        if (this.hasOngoingExecution) {
            LOG.warn("Shutdown executor may take long because execution is still in progress.");
        }
        KafkaCruiseControlUtils.executeSilently(this.proposalExecutor, ExecutorService::shutdown);
        try {
            this.proposalExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for anomaly detector to shutdown.");
        }
        KafkaCruiseControlUtils.executeSilently(this.executionHistoryScannerExecutor, ExecutorService::shutdownNow);
        LOG.info("Executor shutdown completed.");
    }

    public boolean hasOngoingExecution() {
        return this.hasOngoingExecution;
    }

    public boolean isReservedByOther() {
        return this.reservation.isReserved() && !this.reservation.isReservedByMe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateThrottle(long newThrottle) {
        int updatedBrokers;
        if (newThrottle < 0L) {
            throw new IllegalArgumentException("Cannot set a negative throttle");
        }
        ReplicationThrottleHelper replicationThrottleHelper = this.throttleHelper;
        synchronized (replicationThrottleHelper) {
            this.throttleHelper.setThrottleRate(newThrottle);
            updatedBrokers = this.throttleHelper.updateOrRemoveBrokerThrottleRate(newThrottle);
        }
        if (updatedBrokers == 0) {
            LOG.info("No brokers had throttling rate updated");
        } else {
            LOG.info("Updated throttle rate config on {} brokers to {}", (Object)updatedBrokers, (Object)newThrottle);
        }
        return updatedBrokers != 0;
    }

    public boolean hasOngoingPartitionReassignments() {
        return !Executor.partitionsBeingReassigned(this.adminUtils).isEmpty();
    }

    public Set<Integer> recentlyRemovedBrokers() {
        return Collections.unmodifiableSet(this.latestRemoveStartTimeMsByBrokerId.keySet());
    }

    public ExecutorState state() {
        return this.executorState;
    }

    public synchronized Future<?> executeProposals(Collection<ExecutionProposal> proposals, Set<Integer> unthrottledBrokers, Set<Integer> removedBrokers, LoadMonitor loadMonitor, String uuid, BalanceOpExecutionCompletionCallback completionCallback) {
        try {
            LOG.info("executeProposals with UUID {} and completionCallback {}", (Object)uuid, (Object)completionCallback);
            return this.doExecuteProposals(proposals, unthrottledBrokers, loadMonitor, uuid, new ProposalExecutionRunnable(loadMonitor, removedBrokers, completionCallback, this.executionMetricsReporter));
        }
        catch (Exception e) {
            this.clearExecutionState();
            throw e;
        }
    }

    private synchronized Future<?> doExecuteProposals(Collection<ExecutionProposal> proposals, Set<Integer> unthrottledBrokers, LoadMonitor loadMonitor, String uuid, ProposalExecutionRunnable executionRunnable) {
        if (this.hasOngoingExecution) {
            throw new IllegalStateException("Cannot execute new proposals while there is an ongoing execution.");
        }
        if (this.isReservedByOther()) {
            throw new IllegalStateException("Cannot execute new proposals because the Executor is reserved by another thread.");
        }
        if (loadMonitor == null) {
            throw new IllegalArgumentException("Load monitor cannot be null.");
        }
        if (uuid == null) {
            throw new IllegalStateException("UUID of the execution cannot be null.");
        }
        this.clearExecutionState();
        this.executionMetricsReporter.reportProposals(proposals);
        this.initProposalExecution(proposals, unthrottledBrokers, uuid);
        return this.startExecution(executionRunnable);
    }

    void initProposalExecution(Collection<ExecutionProposal> proposals, Collection<Integer> brokersToSkipConcurrencyCheck, String uuid) {
        this.clusterMetadataAtProposalInitialization = this.metadataClient.forceRefreshMetadata();
        this.executionTaskManager.addExecutionProposals(proposals, brokersToSkipConcurrencyCheck, this.clusterMetadataAtProposalInitialization.cluster());
        this.uuid = uuid;
    }

    Future<?> startExecution(ProposalExecutionRunnable runnable) {
        this.numExecutionsStarted.incrementAndGet();
        this.sanityCheckOngoingReplicaMovement();
        this.hasOngoingExecution = true;
        this.anomalyDetector.maybeClearOngoingAnomalyDetectionTimeMs();
        return this.proposalExecutor.submit(runnable);
    }

    synchronized boolean stopExecution() {
        if (this.stopRequested.compareAndSet(false, true)) {
            this.numExecutionStopped.incrementAndGet();
            this.executionTaskManager.setStopRequested();
            return true;
        }
        return false;
    }

    int numCancelledReassignments() {
        return this.numCancelledReassignments.get();
    }

    boolean executionStopShouldInvalidateMetrics() {
        return this.executionStopShouldInvalidateMetrics.get();
    }

    private void sanityCheckOngoingReplicaMovement() {
        if (this.hasOngoingPartitionReassignments()) {
            this.executionTaskManager.clear();
            this.uuid = null;
            throw new IllegalStateException("There are ongoing inter-broker partition movements.");
        }
        if (this.adminUtils.isOngoingIntraBrokerReplicaMovement(this.metadataClient.cluster().nodes().stream().mapToInt(Node::id).boxed().collect(Collectors.toSet()))) {
            this.executionTaskManager.clear();
            this.uuid = null;
            throw new IllegalStateException("There are ongoing intra-broker partition movements.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeThrottles() {
        ReplicationThrottleHelper replicationThrottleHelper = this.throttleHelper;
        synchronized (replicationThrottleHelper) {
            this.throttleHelper.removeAllThrottles();
        }
    }

    private void removeExpiredRemovalHistory() {
        LOG.debug("Remove expired broker removal history");
        this.latestRemoveStartTimeMsByBrokerId.entrySet().removeIf(entry -> (Long)entry.getValue() + this.removalHistoryRetentionTimeMs < this.time.milliseconds());
    }

    int numExecutionsStarted() {
        return this.numExecutionsStarted.get();
    }

    int numExecutionStopped() {
        return this.numExecutionStopped.get();
    }

    private int numFailedReassignmentCancellations() {
        return this.numFailedReassignmentCancellations.get();
    }

    private void clearExecutionState() {
        this.executionTaskManager.clear();
        this.uuid = null;
        this.hasOngoingExecution = false;
        this.stopRequested.set(false);
        this.executionStoppedByUser.set(false);
        this.executionStopShouldInvalidateMetrics.set(true);
    }

    public static Set<TopicPartition> partitionsBeingReassigned(SbkAdminUtils adminUtils) {
        return adminUtils.listTargetReplicasBeingReassigned(Optional.empty()).keySet();
    }

    public static class PartitionReplicas {
        private final List<Integer> replicas;
        private final List<Integer> observers;

        public PartitionReplicas(List<Integer> replicas, List<Integer> observers) {
            this.replicas = replicas;
            this.observers = observers;
        }

        public List<Integer> replicas() {
            return Collections.unmodifiableList(this.replicas);
        }

        public List<Integer> observers() {
            return Collections.unmodifiableList(this.observers);
        }
    }

    static final class ExecutorReservation {
        private ReentrantLock lock = new ReentrantLock();

        boolean attemptReservation() {
            if (this.lock.isHeldByCurrentThread()) {
                throw new IllegalStateException("Cannot reserve the Executor again while already holding a reservation.");
            }
            return this.lock.tryLock();
        }

        void cancelReservation() {
            this.lock.unlock();
        }

        boolean isReservedByMe() {
            return this.lock.isHeldByCurrentThread();
        }

        boolean isReserved() {
            return this.lock.isLocked();
        }
    }

    public static interface ExecutionTaskWaiter {
        public List<ExecutionTask> waitForAnyTaskToFinish(AbstractExecutorReplicaMovement var1);
    }

    class ProposalExecutionRunnable
    implements Runnable {
        private final LoadMonitor loadMonitor;
        private final BalanceOpExecutionCompletionCallback completionCallback;
        private final ExecutionMetricsReporter executionMetricsReporter;
        private ExecutorState.State state;
        private final Set<Integer> recentlyRemovedBrokers;
        private final Set<Integer> removedBrokers;
        protected Throwable executionException;

        ProposalExecutionRunnable(LoadMonitor loadMonitor, Collection<Integer> removedBrokers, BalanceOpExecutionCompletionCallback completionCallback, ExecutionMetricsReporter executionMetricsReporter) {
            this.loadMonitor = loadMonitor;
            this.state = ExecutorState.State.NO_TASK_IN_PROGRESS;
            this.executionException = null;
            this.completionCallback = completionCallback;
            this.executionMetricsReporter = executionMetricsReporter;
            if (Executor.this.anomalyDetector == null) {
                throw new IllegalStateException("AnomalyDetector is not specified in Executor.");
            }
            if (removedBrokers != null) {
                removedBrokers.forEach(id -> Executor.this.latestRemoveStartTimeMsByBrokerId.put(id, Executor.this.time.milliseconds()));
                this.removedBrokers = new HashSet<Integer>(removedBrokers);
            } else {
                this.removedBrokers = Collections.emptySet();
            }
            this.recentlyRemovedBrokers = Executor.this.recentlyRemovedBrokers();
        }

        @Override
        public void run() {
            try (ProposalExecutionAutoCloseable ignored = new ProposalExecutionAutoCloseable(Executor.this.uuid, this.recentlyRemovedBrokers);){
                long executionStartMs = Executor.this.time.milliseconds();
                long highPrecisionStartMs = Executor.this.time.hiResClockMs();
                LOG.info("Starting execution of balancing proposals. Time: {} ms", (Object)executionStartMs);
                this.execute(executionStartMs);
                long executionTimeMs = Executor.this.time.hiResClockMs() - highPrecisionStartMs;
                this.executionMetricsReporter.reportExecutionTime(executionTimeMs);
                LOG.info("Execution finished. Elapsed time: {} ms", (Object)executionTimeMs);
            }
            catch (Exception e) {
                LOG.error("Exception during execution of ProposalExecutionRunnable", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void execute(long executionStartMs) {
            String operationSuffix;
            long startTime;
            ExecutorMetricsHandle metricsHandler;
            boolean isAnomaly;
            block16: {
                List<ExecutionTask> deadExecutionTasks;
                block14: {
                    block15: {
                        boolean shouldStopExecution;
                        block12: {
                            block13: {
                                isAnomaly = AnomalyType.cachedValues().stream().anyMatch(type -> Executor.this.uuid.startsWith(type.toString()));
                                metricsHandler = new ExecutorMetricsHandle(this.loadMonitor, Executor.this.uuid);
                                startTime = Executor.this.time.hiResClockMs();
                                metricsHandler.handle();
                                shouldStopExecution = this.interBrokerMove();
                                if (!shouldStopExecution) break block12;
                                LOG.info("Stopping execution {} after inter-broker movements - stopRequested: {}", (Object)Executor.this.uuid, (Object)Executor.this.stopRequested.get());
                                List<ExecutionTask> deadExecutionTasks2 = Executor.this.deadExecutionTasks();
                                if (this.executionException != null || deadExecutionTasks2.isEmpty()) break block13;
                                this.executionException = new DeadExecutionTaskException(String.format("Dead tasks encountered: %s", deadExecutionTasks2));
                            }
                            String operationSuffix2 = String.format("for operation %s", Executor.this.uuid);
                            LOG.info("Cleaning up execution {}", (Object)operationSuffix2);
                            metricsHandler.close(Executor.this.executionStopShouldInvalidateMetrics.get());
                            this.tryRun(this.loadMonitor::forceRefreshClusterAndGeneration, "Unable to refresh cluster metadata after execution of " + operationSuffix2);
                            if (isAnomaly) {
                                this.tryRun(() -> Executor.this.anomalyDetector.markSelfHealingFinished(Executor.this.uuid), "Caught exception while marking self healing finished " + operationSuffix2);
                            }
                            boolean executionSucceeded = Executor.this.executorState.state() != ExecutorState.State.STOPPING_EXECUTION && this.executionException == null;
                            long executionTimeMin = Duration.ofMillis(Executor.this.time.hiResClockMs() - startTime).toMinutes();
                            LOG.info("ProposalExecutionRunnable finished after {} minutes with success state {} {} and exception: ", new Object[]{executionTimeMin, executionSucceeded, operationSuffix2, this.executionException});
                            ExecutorNotification notification = new ExecutorNotification(executionStartMs, Executor.this.time.milliseconds(), Executor.this.uuid, Executor.this.stopRequested.get(), Executor.this.executionStoppedByUser.get(), this.executionException, executionSucceeded);
                            this.tryRun(() -> Executor.this.executorNotifier.sendNotification(notification), String.format("Caught exception while sending a notification (notification: %s) ", notification) + operationSuffix2);
                            LOG.info("Task [{}] execution finishes.", (Object)Executor.this.uuid);
                            if (this.completionCallback == null) return;
                            LOG.info("executionRunnable invoking completion callback");
                            this.tryRun(() -> this.completionCallback.accept(executionSucceeded, this.executionException), String.format("Caught exception while invoking completion callback (succeeded: %s, exception: %s) ", executionSucceeded, this.executionException) + operationSuffix2);
                            return;
                        }
                        ExecutorIntraBrokerReplicaMovement intraBroker = new ExecutorIntraBrokerReplicaMovement(Executor.this.uuid, Executor.this.executionTaskManager, this.recentlyRemovedBrokers, Executor.this.throttleHelper, Executor.this.adminClient, Executor.this.adminUtils, Executor.this.stopRequested);
                        this.state = intraBroker.state();
                        Executor.this.executorState = intraBroker.executorState();
                        intraBroker.move(this::waitForAnyExecutionTaskToFinish);
                        shouldStopExecution = this.checkStopRequested();
                        this.updateOngoingExecutionState();
                        if (!shouldStopExecution) break block14;
                        LOG.info("Stopping execution {} after intra-broker movements - stopRequested: {}", (Object)Executor.this.uuid, (Object)Executor.this.stopRequested.get());
                        List<ExecutionTask> deadExecutionTasks3 = Executor.this.deadExecutionTasks();
                        if (this.executionException != null || deadExecutionTasks3.isEmpty()) break block15;
                        this.executionException = new DeadExecutionTaskException(String.format("Dead tasks encountered: %s", deadExecutionTasks3));
                    }
                    String operationSuffix3 = String.format("for operation %s", Executor.this.uuid);
                    LOG.info("Cleaning up execution {}", (Object)operationSuffix3);
                    metricsHandler.close(Executor.this.executionStopShouldInvalidateMetrics.get());
                    this.tryRun(this.loadMonitor::forceRefreshClusterAndGeneration, "Unable to refresh cluster metadata after execution of " + operationSuffix3);
                    if (isAnomaly) {
                        this.tryRun(() -> Executor.this.anomalyDetector.markSelfHealingFinished(Executor.this.uuid), "Caught exception while marking self healing finished " + operationSuffix3);
                    }
                    boolean executionSucceeded = Executor.this.executorState.state() != ExecutorState.State.STOPPING_EXECUTION && this.executionException == null;
                    long executionTimeMin = Duration.ofMillis(Executor.this.time.hiResClockMs() - startTime).toMinutes();
                    LOG.info("ProposalExecutionRunnable finished after {} minutes with success state {} {} and exception: ", new Object[]{executionTimeMin, executionSucceeded, operationSuffix3, this.executionException});
                    ExecutorNotification notification = new ExecutorNotification(executionStartMs, Executor.this.time.milliseconds(), Executor.this.uuid, Executor.this.stopRequested.get(), Executor.this.executionStoppedByUser.get(), this.executionException, executionSucceeded);
                    this.tryRun(() -> Executor.this.executorNotifier.sendNotification(notification), String.format("Caught exception while sending a notification (notification: %s) ", notification) + operationSuffix3);
                    LOG.info("Task [{}] execution finishes.", (Object)Executor.this.uuid);
                    if (this.completionCallback == null) return;
                    LOG.info("executionRunnable invoking completion callback");
                    this.tryRun(() -> this.completionCallback.accept(executionSucceeded, this.executionException), String.format("Caught exception while invoking completion callback (succeeded: %s, exception: %s) ", executionSucceeded, this.executionException) + operationSuffix3);
                    return;
                }
                try {
                    ExecutorLeadershipReplicaMovement leadershipMove = new ExecutorLeadershipReplicaMovement(Executor.this.uuid, Executor.this.executionTaskManager, this.recentlyRemovedBrokers, Executor.this.throttleHelper, Executor.this.adminClient, Executor.this.adminUtils, Executor.this.stopRequested);
                    this.state = leadershipMove.state();
                    Executor.this.executorState = leadershipMove.executorState();
                    leadershipMove.move(this::waitForAnyExecutionTaskToFinish);
                    this.checkStopRequested();
                    this.updateOngoingExecutionState();
                    deadExecutionTasks = Executor.this.deadExecutionTasks();
                    if (this.executionException != null || deadExecutionTasks.isEmpty()) break block16;
                }
                catch (Throwable t) {
                    block17: {
                        List<ExecutionTask> deadExecutionTasks4;
                        try {
                            LOG.error("Executor got exception during execution", t);
                            this.executionException = t;
                            deadExecutionTasks4 = Executor.this.deadExecutionTasks();
                            if (this.executionException != null || deadExecutionTasks4.isEmpty()) break block17;
                        }
                        catch (Throwable throwable) {
                            List<ExecutionTask> deadExecutionTasks5 = Executor.this.deadExecutionTasks();
                            if (this.executionException == null && !deadExecutionTasks5.isEmpty()) {
                                this.executionException = new DeadExecutionTaskException(String.format("Dead tasks encountered: %s", deadExecutionTasks5));
                            }
                            String operationSuffix4 = String.format("for operation %s", Executor.this.uuid);
                            LOG.info("Cleaning up execution {}", (Object)operationSuffix4);
                            metricsHandler.close(Executor.this.executionStopShouldInvalidateMetrics.get());
                            this.tryRun(this.loadMonitor::forceRefreshClusterAndGeneration, "Unable to refresh cluster metadata after execution of " + operationSuffix4);
                            if (isAnomaly) {
                                this.tryRun(() -> Executor.this.anomalyDetector.markSelfHealingFinished(Executor.this.uuid), "Caught exception while marking self healing finished " + operationSuffix4);
                            }
                            boolean executionSucceeded = Executor.this.executorState.state() != ExecutorState.State.STOPPING_EXECUTION && this.executionException == null;
                            long executionTimeMin = Duration.ofMillis(Executor.this.time.hiResClockMs() - startTime).toMinutes();
                            LOG.info("ProposalExecutionRunnable finished after {} minutes with success state {} {} and exception: ", new Object[]{executionTimeMin, executionSucceeded, operationSuffix4, this.executionException});
                            ExecutorNotification notification = new ExecutorNotification(executionStartMs, Executor.this.time.milliseconds(), Executor.this.uuid, Executor.this.stopRequested.get(), Executor.this.executionStoppedByUser.get(), this.executionException, executionSucceeded);
                            this.tryRun(() -> Executor.this.executorNotifier.sendNotification(notification), String.format("Caught exception while sending a notification (notification: %s) ", notification) + operationSuffix4);
                            LOG.info("Task [{}] execution finishes.", (Object)Executor.this.uuid);
                            if (this.completionCallback == null) throw throwable;
                            LOG.info("executionRunnable invoking completion callback");
                            this.tryRun(() -> this.completionCallback.accept(executionSucceeded, this.executionException), String.format("Caught exception while invoking completion callback (succeeded: %s, exception: %s) ", executionSucceeded, this.executionException) + operationSuffix4);
                            throw throwable;
                        }
                        this.executionException = new DeadExecutionTaskException(String.format("Dead tasks encountered: %s", deadExecutionTasks4));
                    }
                    operationSuffix = String.format("for operation %s", Executor.this.uuid);
                    LOG.info("Cleaning up execution {}", (Object)operationSuffix);
                    metricsHandler.close(Executor.this.executionStopShouldInvalidateMetrics.get());
                    this.tryRun(this.loadMonitor::forceRefreshClusterAndGeneration, "Unable to refresh cluster metadata after execution of " + operationSuffix);
                    if (isAnomaly) {
                        this.tryRun(() -> Executor.this.anomalyDetector.markSelfHealingFinished(Executor.this.uuid), "Caught exception while marking self healing finished " + operationSuffix);
                    }
                    boolean executionSucceeded = Executor.this.executorState.state() != ExecutorState.State.STOPPING_EXECUTION && this.executionException == null;
                    long executionTimeMin = Duration.ofMillis(Executor.this.time.hiResClockMs() - startTime).toMinutes();
                    LOG.info("ProposalExecutionRunnable finished after {} minutes with success state {} {} and exception: ", new Object[]{executionTimeMin, executionSucceeded, operationSuffix, this.executionException});
                    ExecutorNotification notification = new ExecutorNotification(executionStartMs, Executor.this.time.milliseconds(), Executor.this.uuid, Executor.this.stopRequested.get(), Executor.this.executionStoppedByUser.get(), this.executionException, executionSucceeded);
                    this.tryRun(() -> Executor.this.executorNotifier.sendNotification(notification), String.format("Caught exception while sending a notification (notification: %s) ", notification) + operationSuffix);
                    LOG.info("Task [{}] execution finishes.", (Object)Executor.this.uuid);
                    if (this.completionCallback == null) return;
                    LOG.info("executionRunnable invoking completion callback");
                    this.tryRun(() -> this.completionCallback.accept(executionSucceeded, this.executionException), String.format("Caught exception while invoking completion callback (succeeded: %s, exception: %s) ", executionSucceeded, this.executionException) + operationSuffix);
                    return;
                }
                this.executionException = new DeadExecutionTaskException(String.format("Dead tasks encountered: %s", deadExecutionTasks));
            }
            operationSuffix = String.format("for operation %s", Executor.this.uuid);
            LOG.info("Cleaning up execution {}", (Object)operationSuffix);
            metricsHandler.close(Executor.this.executionStopShouldInvalidateMetrics.get());
            this.tryRun(this.loadMonitor::forceRefreshClusterAndGeneration, "Unable to refresh cluster metadata after execution of " + operationSuffix);
            if (isAnomaly) {
                this.tryRun(() -> Executor.this.anomalyDetector.markSelfHealingFinished(Executor.this.uuid), "Caught exception while marking self healing finished " + operationSuffix);
            }
            boolean executionSucceeded = Executor.this.executorState.state() != ExecutorState.State.STOPPING_EXECUTION && this.executionException == null;
            long executionTimeMin = Duration.ofMillis(Executor.this.time.hiResClockMs() - startTime).toMinutes();
            LOG.info("ProposalExecutionRunnable finished after {} minutes with success state {} {} and exception: ", new Object[]{executionTimeMin, executionSucceeded, operationSuffix, this.executionException});
            ExecutorNotification notification = new ExecutorNotification(executionStartMs, Executor.this.time.milliseconds(), Executor.this.uuid, Executor.this.stopRequested.get(), Executor.this.executionStoppedByUser.get(), this.executionException, executionSucceeded);
            this.tryRun(() -> Executor.this.executorNotifier.sendNotification(notification), String.format("Caught exception while sending a notification (notification: %s) ", notification) + operationSuffix);
            LOG.info("Task [{}] execution finishes.", (Object)Executor.this.uuid);
            if (this.completionCallback == null) return;
            LOG.info("executionRunnable invoking completion callback");
            this.tryRun(() -> this.completionCallback.accept(executionSucceeded, this.executionException), String.format("Caught exception while invoking completion callback (succeeded: %s, exception: %s) ", executionSucceeded, this.executionException) + operationSuffix);
            return;
        }

        private boolean interBrokerMove() throws InterruptedException {
            ExecutorInterBrokerReplicaMovement interBroker = new ExecutorInterBrokerReplicaMovement(Executor.this.uuid, Executor.this.executionTaskManager, this.recentlyRemovedBrokers, Executor.this.throttleHelper, Executor.this.adminClient, Executor.this.adminUtils, Executor.this.stopRequested, this.removedBrokers, this.loadMonitor, Executor.this.clusterMetadataAtProposalInitialization.cluster(), Executor.this.time, Executor.this.invalidReplicaAssignmentRetryMs);
            this.state = interBroker.state();
            Executor.this.executorState = interBroker.executorState();
            int numPendingMovementsPriorExecution = Executor.this.executionTaskManager.numPendingInterBrokerPartitionMovements();
            interBroker.move(this::waitForAnyExecutionTaskToFinish);
            boolean shouldStopExecution = this.checkStopRequested();
            this.updateOngoingExecutionState();
            int postRemainingMovements = Executor.this.executionTaskManager.numPendingInterBrokerPartitionMovements();
            int numTasksInExecution = Executor.this.executionTaskManager.inExecutionTasks().size();
            if (shouldStopExecution) {
                ExecutionTaskTracker.ExecutionTasksSummary executionTasksSummary = Executor.this.executionTaskManager.getExecutionTasksSummary(Collections.emptySet());
                LOG.info("Stopping execution {} after {} inter-broker movements - stopRequested: {}. {}, {} remaining data to move; for intra-broker partition movement {} tasks cancelled; for leadership movements {} task cancelled.", new Object[]{Executor.this.uuid, numPendingMovementsPriorExecution - postRemainingMovements, Executor.this.stopRequested.get(), executionTasksSummary.summarize(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION), executionTasksSummary.remainingInterBrokerDataToMoveInMB(), executionTasksSummary.taskStat().get((Object)ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION).get((Object)ExecutionTask.State.PENDING), executionTasksSummary.taskStat().get((Object)ExecutionTask.TaskType.LEADER_ACTION).get((Object)ExecutionTask.State.PENDING)});
                return true;
            }
            if (postRemainingMovements == 0 && numTasksInExecution == 0) {
                LOG.info("Inter-broker partition movements finished successfully.");
            } else {
                LOG.info("Inter-broker partition movements finished with leftover tasks to execute - {} remaining partitions to move, {} tasks remaining in execution", (Object)postRemainingMovements, (Object)numTasksInExecution);
            }
            return false;
        }

        private void tryRun(Runnable runnable, String errorMessage) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                LOG.error(errorMessage, (Throwable)exception);
            }
        }

        private void updateOngoingExecutionState() {
            switch (this.state) {
                case LEADER_MOVEMENT_TASK_IN_PROGRESS: {
                    Executor.this.executorState = ExecutorState.operationInProgress(ExecutorState.State.LEADER_MOVEMENT_TASK_IN_PROGRESS, Executor.this.executionTaskManager.getExecutionTasksSummary(Collections.singleton(ExecutionTask.TaskType.LEADER_ACTION)), Executor.this.executionTaskManager.interBrokerPartitionMovementConcurrency(), Executor.this.executionTaskManager.intraBrokerPartitionMovementConcurrency(), Executor.this.executionTaskManager.leadershipMovementConcurrency(), Executor.this.uuid, this.recentlyRemovedBrokers);
                    break;
                }
                case INTER_BROKER_REPLICA_MOVEMENT_TASK_IN_PROGRESS: {
                    Executor.this.executorState = ExecutorState.operationInProgress(ExecutorState.State.INTER_BROKER_REPLICA_MOVEMENT_TASK_IN_PROGRESS, Executor.this.executionTaskManager.getExecutionTasksSummary(Collections.singleton(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION)), Executor.this.executionTaskManager.interBrokerPartitionMovementConcurrency(), Executor.this.executionTaskManager.intraBrokerPartitionMovementConcurrency(), Executor.this.executionTaskManager.leadershipMovementConcurrency(), Executor.this.uuid, this.recentlyRemovedBrokers);
                    break;
                }
                case INTRA_BROKER_REPLICA_MOVEMENT_TASK_IN_PROGRESS: {
                    Executor.this.executorState = ExecutorState.operationInProgress(ExecutorState.State.INTRA_BROKER_REPLICA_MOVEMENT_TASK_IN_PROGRESS, Executor.this.executionTaskManager.getExecutionTasksSummary(Collections.singleton(ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION)), Executor.this.executionTaskManager.interBrokerPartitionMovementConcurrency(), Executor.this.executionTaskManager.intraBrokerPartitionMovementConcurrency(), Executor.this.executionTaskManager.leadershipMovementConcurrency(), Executor.this.uuid, this.recentlyRemovedBrokers);
                    break;
                }
                case STOPPING_EXECUTION: {
                    Executor.this.executorState = ExecutorState.operationInProgress(ExecutorState.State.STOPPING_EXECUTION, Executor.this.executionTaskManager.getExecutionTasksSummary(new HashSet<ExecutionTask.TaskType>(ExecutionTask.TaskType.cachedValues())), Executor.this.executionTaskManager.interBrokerPartitionMovementConcurrency(), Executor.this.executionTaskManager.intraBrokerPartitionMovementConcurrency(), Executor.this.executionTaskManager.leadershipMovementConcurrency(), Executor.this.uuid, this.recentlyRemovedBrokers);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected ongoing execution state " + (Object)((Object)this.state));
                }
            }
        }

        private boolean checkStopRequested() {
            boolean stopRequested = Executor.this.stopRequested.get();
            if (stopRequested) {
                this.state = ExecutorState.State.STOPPING_EXECUTION;
            }
            return stopRequested;
        }

        private List<ExecutionTask> waitForAnyExecutionTaskToFinish(AbstractExecutorReplicaMovement movement) {
            ArrayList<ExecutionTask> finishedTasks = new ArrayList<ExecutionTask>();
            boolean anyTaskFinished = false;
            boolean inExecutionTasksPresent = true;
            do {
                Map<ExecutionTask, DescribeReplicaLogDirsResult.ReplicaLogDirInfo> logDirInfoByTask;
                SbcClusterSnapshot sbcClusterSnapshot;
                movement.maybeReexecuteTasks();
                try {
                    Thread.sleep(Executor.this.statusCheckingIntervalMs);
                }
                catch (InterruptedException e) {
                    LOG.warn("The execution thread got interrupted during the execution.progress.check.interval.ms check", (Throwable)e);
                }
                Set<ExecutionTask> inExecutionTasks = Executor.this.executionTaskManager.inExecutionTasks();
                Set<String> topicNames = inExecutionTasks.stream().map(x -> x.proposal().topic()).collect(Collectors.toSet());
                try {
                    Optional<SbcClusterSnapshot> clusterSnapshotResult = Executor.this.metadataClient.fetchSbcClusterSnapshot(topicNames);
                    if (!clusterSnapshotResult.isPresent()) continue;
                    sbcClusterSnapshot = clusterSnapshotResult.get();
                }
                catch (InterruptedException e) {
                    LOG.warn("The execution thread has been interrupted while trying to retrieve the cluster state to log progress on these tasks: {}", inExecutionTasks);
                    continue;
                }
                Map<ExecutionTask, DescribeReplicaLogDirsResult.ReplicaLogDirInfo> map = logDirInfoByTask = movement.taskType() == ExecutionTask.TaskType.INTRA_BROKER_REPLICA_ACTION ? Executor.this.adminUtils.getLogdirInfoForExecutionTask(Executor.this.executionTaskManager.inExecutionTasks(Collections.singleton(movement.taskType()))) : Collections.emptyMap();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Tasks in execution: {}", inExecutionTasks);
                }
                ArrayList<ExecutionTask> deadOrAbortingTasks = new ArrayList<ExecutionTask>();
                ArrayList<TopicPartition> partitionReassignmentsToCancel = new ArrayList<TopicPartition>();
                boolean cancelRequested = Executor.this.stopRequested.get();
                if (cancelRequested) {
                    LOG.info("User initiated a cancellation of all ongoing tasks.");
                }
                Map<Integer, Node> nodesById = sbcClusterSnapshot.nodes().stream().collect(Collectors.toMap(Node::id, Function.identity()));
                for (ExecutionTask task : inExecutionTasks) {
                    TopicPartition tp = task.proposal().topicPartition();
                    PartitionInfo partitionInfo = sbcClusterSnapshot.partitionsByTopicPartition().get(tp);
                    if (partitionInfo == null) {
                        LOG.debug("Task {} is marked as finished because the topic has been deleted", (Object)task);
                        finishedTasks.add(task);
                        Executor.this.executionTaskManager.markTaskAborting(task);
                        Executor.this.executionTaskManager.markTaskDone(task);
                        continue;
                    }
                    if (this.isTaskDone(partitionInfo, logDirInfoByTask, task)) {
                        finishedTasks.add(task);
                        Executor.this.executionTaskManager.markTaskDone(task);
                        continue;
                    }
                    if (!this.maybeMarkTaskAsDead(nodesById, logDirInfoByTask, task, cancelRequested)) continue;
                    if (task.type() != ExecutionTask.TaskType.LEADER_ACTION) {
                        deadOrAbortingTasks.add(task);
                    }
                    if (task.type() == ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION) {
                        partitionReassignmentsToCancel.add(tp);
                    }
                    if (task.state() != ExecutionTask.State.DEAD && task.state() != ExecutionTask.State.ABORTED) continue;
                    finishedTasks.add(task);
                }
                int numReassignmentsToCancel = partitionReassignmentsToCancel.size();
                if (numReassignmentsToCancel > 0) {
                    LOG.info("Cancelling {} partition reassignments", (Object)numReassignmentsToCancel);
                    int numCancelled = Executor.this.adminUtils.cancelInterBrokerReplicaMovements(partitionReassignmentsToCancel);
                    int numFailedCancellations = numReassignmentsToCancel - numCancelled;
                    LOG.info("Successfully cancelled {}/{} partition reassignments", (Object)numCancelled, (Object)numReassignmentsToCancel);
                    Executor.this.numCancelledReassignments.addAndGet(numCancelled);
                    if (numFailedCancellations > 0) {
                        LOG.warn("Failed to cancel {}/{} partition reassignments", (Object)numFailedCancellations, (Object)numReassignmentsToCancel);
                        Executor.this.numFailedReassignmentCancellations.addAndGet(numFailedCancellations);
                    }
                }
                if (!deadOrAbortingTasks.isEmpty() && !Executor.this.stopRequested.get()) {
                    LOG.info("Cancelling execution because {} tasks have failed. Failed partitions: {}", (Object)deadOrAbortingTasks.size(), deadOrAbortingTasks.stream().map(d -> d.proposal().topicPartition()));
                    Executor.this.stopExecution();
                }
                this.checkStopRequested();
                this.updateOngoingExecutionState();
                anyTaskFinished = !finishedTasks.isEmpty();
                boolean bl = inExecutionTasksPresent = !Executor.this.executionTaskManager.inExecutionTasks().isEmpty();
            } while (inExecutionTasksPresent && !anyTaskFinished);
            LOG.info("Completed tasks: {}", finishedTasks);
            return finishedTasks;
        }

        private boolean isTaskDone(PartitionInfo partitionInfo, Map<ExecutionTask, DescribeReplicaLogDirsResult.ReplicaLogDirInfo> logdirInfoByTask, ExecutionTask task) {
            switch (task.type()) {
                case INTER_BROKER_REPLICA_ACTION: {
                    return this.isInterBrokerReplicaActionDone(partitionInfo, task);
                }
                case INTRA_BROKER_REPLICA_ACTION: {
                    return this.isIntraBrokerReplicaActionDone(logdirInfoByTask, task);
                }
                case LEADER_ACTION: {
                    return this.isLeadershipMovementDone(partitionInfo, task);
                }
            }
            return true;
        }

        private boolean isInterBrokerReplicaActionDone(PartitionInfo partitionInfo, ExecutionTask task) {
            Node[] currentOrderedReplicas = partitionInfo.replicas();
            Node[] currentOrderedObservers = partitionInfo.observers();
            switch (task.state()) {
                case IN_PROGRESS: {
                    return task.proposal().isInterBrokerMovementCompleted(currentOrderedReplicas, currentOrderedObservers);
                }
                case ABORTING: {
                    return task.proposal().isInterBrokerMovementAborted(currentOrderedReplicas, currentOrderedObservers);
                }
                case DEAD: {
                    return true;
                }
            }
            throw new IllegalStateException("Should never be here. State " + (Object)((Object)task.state()));
        }

        private boolean isIntraBrokerReplicaActionDone(Map<ExecutionTask, DescribeReplicaLogDirsResult.ReplicaLogDirInfo> logdirInfoByTask, ExecutionTask task) {
            if (logdirInfoByTask.containsKey(task)) {
                return logdirInfoByTask.get(task).getCurrentReplicaLogDir().equals(task.proposal().replicasToMoveBetweenDisksByBroker().get(task.brokerId()).logdir());
            }
            return false;
        }

        private boolean isInIsr(Integer leader, PartitionInfo partitionInfo) {
            return Arrays.stream(partitionInfo.inSyncReplicas()).anyMatch(node -> node.id() == leader.intValue());
        }

        private boolean isLeadershipMovementDone(PartitionInfo partitionInfo, ExecutionTask task) {
            Node leader = partitionInfo.leader();
            switch (task.state()) {
                case IN_PROGRESS: {
                    return leader != null && leader.id() == task.proposal().newLeader().brokerId().intValue() || leader == null || !this.isInIsr(task.proposal().newLeader().brokerId(), partitionInfo);
                }
                case ABORTING: 
                case DEAD: {
                    return true;
                }
            }
            throw new IllegalStateException("Should never be here.");
        }

        private boolean maybeMarkTaskAsDead(Map<Integer, Node> nodesById, Map<ExecutionTask, DescribeReplicaLogDirsResult.ReplicaLogDirInfo> logdirInfoByTask, ExecutionTask task, boolean cancelRequested) {
            if (cancelRequested && task.state() == ExecutionTask.State.IN_PROGRESS) {
                LOG.info("Cancelling task {}", (Object)task);
                Executor.this.executionTaskManager.markTaskDead(task);
                return true;
            }
            if (task.state() == ExecutionTask.State.IN_PROGRESS || task.state() == ExecutionTask.State.ABORTING) {
                switch (task.type()) {
                    case LEADER_ACTION: {
                        if (nodesById.get(task.proposal().newLeader().brokerId()) == null) {
                            Executor.this.executionTaskManager.markTaskDead(task);
                            LOG.warn("Killing execution for task {} because the target leader is down", (Object)task);
                            return true;
                        }
                        if (Executor.this.time.milliseconds() > task.startTime() + Executor.this.leaderActionTimeoutMs) {
                            Executor.this.executionTaskManager.markTaskDead(task);
                            LOG.warn("Failed task {} because it took longer than {} to finish.", (Object)task, (Object)Executor.this.leaderActionTimeoutMs);
                            return true;
                        }
                        LOG.info("Evaluating timeout of start: {} now: {} timeout: {}", new Object[]{task.startTime(), Executor.this.time.milliseconds(), Executor.this.leaderActionTimeoutMs});
                        break;
                    }
                    case INTER_BROKER_REPLICA_ACTION: {
                        for (ReplicaPlacementInfo broker : task.proposal().newReplicas()) {
                            if (nodesById.get(broker.brokerId()) != null) continue;
                            Executor.this.executionTaskManager.markTaskDead(task);
                            LOG.warn("Killing execution for task {} because the new replica to be added {} is down.", (Object)task, (Object)broker);
                            return true;
                        }
                        break;
                    }
                    case INTRA_BROKER_REPLICA_ACTION: {
                        if (logdirInfoByTask.containsKey(task)) break;
                        Executor.this.executionTaskManager.markTaskDead(task);
                        LOG.warn("Killing execution for task {} because the destination disk is down.", (Object)task);
                        return true;
                    }
                    default: {
                        throw new IllegalStateException("Unknown task type " + (Object)((Object)task.type()));
                    }
                }
            }
            return false;
        }

        private class ProposalExecutionAutoCloseable
        implements AutoCloseable {
            public ProposalExecutionAutoCloseable(String uuid, Set<Integer> recentlyRemovedBrokers) {
                ProposalExecutionRunnable.this.state = ExecutorState.State.STARTING_EXECUTION;
                Executor.this.executorState = ExecutorState.executionStarted(uuid, recentlyRemovedBrokers);
                LOG.info("Task [{}] execution starts.", (Object)uuid);
            }

            @Override
            public void close() {
                ProposalExecutionRunnable.this.state = ExecutorState.State.NO_TASK_IN_PROGRESS;
                Executor.this.executorState = ExecutorState.noTaskInProgress(ProposalExecutionRunnable.this.recentlyRemovedBrokers);
                Executor.this.clearExecutionState();
            }
        }
    }

    private class ExecutionHistoryScanner
    implements Runnable {
        private ExecutionHistoryScanner() {
        }

        @Override
        public void run() {
            try {
                Executor.this.removeExpiredRemovalHistory();
            }
            catch (Throwable t) {
                LOG.warn("Received exception when trying to expire execution history.", t);
            }
        }
    }
}

