/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.monitor.LoadMonitor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorMetricsHandle
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorMetricsHandle.class);
    static final long RETRY_INTERVAL_MS = TimeUnit.SECONDS.toMillis(7L);
    private final LoadMonitor loadMonitor;
    private final String executionId;
    private boolean handleWasExecuted;

    public ExecutorMetricsHandle(LoadMonitor loadMonitor, String executionId) {
        this.loadMonitor = loadMonitor;
        this.executionId = executionId;
        this.handleWasExecuted = false;
    }

    public void handle() throws InterruptedException {
        this.pauseMetricsSampling();
        this.handleWasExecuted = true;
    }

    private void pauseMetricsSampling() throws InterruptedException {
        String pauseMsg = String.format("Pausing sampling before the Executor begins execution with ID %s (Date: %s)", this.executionId, KafkaCruiseControlUtils.currentUtcDate());
        while (true) {
            try {
                this.loadMonitor.pauseMetricSampling(pauseMsg);
            }
            catch (IllegalStateException e) {
                LOG.warn("Could not pause the load monitor - sleeping for {} ms before retrying to pause it.", (Object)RETRY_INTERVAL_MS, (Object)e);
                Thread.sleep(RETRY_INTERVAL_MS);
                continue;
            }
            break;
        }
    }

    private void resumeMetricsSampling() {
        this.loadMonitor.resumeMetricSampling(String.format("Resumed-By-Cruise-Control-After-Completed-Execution (Date: %s)", KafkaCruiseControlUtils.currentUtcDate()));
        LOG.info("Successfully resumed metrics sampling.");
    }

    private void invalidateMetricsSamples() {
        this.loadMonitor.invalidateMetricsWindows();
        LOG.info("Successfully invalidated all metrics windows before the current timestamp.");
    }

    public void close(boolean shouldInvalidateMetrics) {
        try {
            if (!this.handleWasExecuted) {
                return;
            }
            if (shouldInvalidateMetrics) {
                this.invalidateMetricsSamples();
            }
            this.resumeMetricsSampling();
        }
        catch (Exception e) {
            LOG.error("Failed to close executor sampling handler for execution ID {}", (Object)this.executionId, (Object)e);
        }
    }

    @Override
    public void close() {
        this.close(true);
    }
}

