/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.metricsreporter.metric;

import com.linkedin.kafka.cruisecontrol.metricsreporter.exception.UnknownVersionException;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.CruiseControlMetric;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.RawMetricType;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class TopicMetric
extends CruiseControlMetric {
    private static final byte METRIC_VERSION = 0;
    protected String topic;

    public TopicMetric(RawMetricType rawMetricType, long time, int brokerId, String topic, double value) {
        super(rawMetricType, time, brokerId, value);
        if (rawMetricType.metricScope() != RawMetricType.MetricScope.TOPIC) {
            throw new IllegalArgumentException(String.format("Cannot construct a TopicMetric for %s whose scope is %s", new Object[]{rawMetricType, rawMetricType.metricScope()}));
        }
        this.topic = topic;
    }

    @Override
    public CruiseControlMetric.MetricClassId metricClassId() {
        return CruiseControlMetric.MetricClassId.TOPIC_METRIC;
    }

    public String topic() {
        return this.topic;
    }

    @Override
    public ByteBuffer toBuffer(int headerPos) {
        byte[] topic = this.topic.getBytes(StandardCharsets.UTF_8);
        ByteBuffer buffer = ByteBuffer.allocate(headerPos + 1 + 1 + 8 + 4 + 4 + topic.length + 8);
        buffer.position(headerPos);
        buffer.put((byte)0);
        buffer.put(this.rawMetricType().id());
        buffer.putLong(this.time());
        buffer.putInt(this.brokerId());
        buffer.putInt(topic.length);
        buffer.put(topic);
        buffer.putDouble(this.value());
        return buffer;
    }

    static TopicMetric fromBuffer(ByteBuffer buffer) throws UnknownVersionException {
        byte version = buffer.get();
        if (version > 0) {
            throw new UnknownVersionException("Cannot deserialize the topic metrics for version " + version + ". Current version is " + 0);
        }
        RawMetricType rawMetricType = RawMetricType.forId(buffer.get());
        long time = buffer.getLong();
        int brokerId = buffer.getInt();
        int topicLength = buffer.getInt();
        String topic = new String(buffer.array(), buffer.arrayOffset() + buffer.position(), topicLength, StandardCharsets.UTF_8);
        buffer.position(buffer.position() + topicLength);
        double value = buffer.getDouble();
        return new TopicMetric(rawMetricType, time, brokerId, topic, value);
    }

    @Override
    public String toString() {
        return String.format("[%s,%s,time=%d,brokerId=%d,topic=%s,value=%.3f]", new Object[]{CruiseControlMetric.MetricClassId.TOPIC_METRIC, this.rawMetricType(), this.time(), this.brokerId(), this.topic(), this.value()});
    }
}

