/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregatedMetricValues;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Capacity;
import com.linkedin.kafka.cruisecontrol.model.Load;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.Utilization;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.message.DescribeCellsResponseData;

public class Cell {
    public static final int DEFAULT_CELL_ID = -1;
    public static final int DEAD_BROKERS_CELL_ID = -2;
    public static final int GENESIS_BROKER_CELL_ID = -3;
    private static final Set<Integer> IMAGINARY_CELL_IDS = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(-3, -2)));
    private final int id;
    private final Map<Integer, Broker> brokers;
    private CellState state;
    private final Capacity capacity;
    private final Load load;
    private final Utilization utilization;

    public static Cell createGenesisCell() {
        return new Cell(-3);
    }

    public static Cell createDeadCell() {
        return new Cell(-2);
    }

    public static Set<Integer> imaginaryCellIds() {
        return IMAGINARY_CELL_IDS;
    }

    public static boolean isImaginaryCellId(int cellId) {
        return IMAGINARY_CELL_IDS.contains(cellId);
    }

    public static boolean isDefaultCellId(int cellId) {
        return -1 == cellId;
    }

    public static boolean isDeadCellId(int cellId) {
        return -2 == cellId;
    }

    public Cell(int id) {
        this.id = id;
        this.brokers = new HashMap<Integer, Broker>();
        this.capacity = Capacity.create();
        this.load = new Load();
        this.utilization = Utilization.from(this.load);
        this.state = CellState.UNKNOWN;
    }

    public Cell(DescribeCellsResponseData.Cell cellData) {
        this.id = cellData.cellId();
        this.state = CellState.toEnum((byte)cellData.state());
        this.brokers = new HashMap<Integer, Broker>();
        this.capacity = Capacity.create();
        this.load = new Load();
        this.utilization = Utilization.from(this.load);
    }

    public void addBroker(Broker broker) {
        this.brokers.put(broker.id(), broker);
        if (broker.isAlive()) {
            this.capacity.addCapacity(broker.capacity());
        }
    }

    public void addBrokerLoad(Broker broker) {
        this.load.addLoad(broker.load());
        this.utilization.addLoad(broker.strategy(), broker.load());
    }

    public Capacity capacity() {
        return this.capacity;
    }

    public Load load() {
        return this.load;
    }

    public Utilization utilization() {
        return this.utilization;
    }

    void replicaLoad(Broker broker, AggregatedMetricValues aggregatedMetricValues, List<Long> windows) {
        this.load.addMetricValues(aggregatedMetricValues, windows);
        this.utilization.addMetricValues(broker.strategy(), aggregatedMetricValues, windows);
    }

    void makeLeader(Broker.Strategy strategy, AggregatedMetricValues leadershipLoadDelta) {
        this.load.addLoad(leadershipLoadDelta);
        this.utilization.addLoad(strategy, leadershipLoadDelta);
    }

    void addReplica(Replica replica) {
        this.load.addLoad(replica.load());
        this.utilization.addLoad(replica.broker().strategy(), replica.load());
    }

    void removeReplica(Replica replica) {
        this.load.subtractLoad(replica.load());
        this.utilization.subtractLoad(replica.broker().strategy(), replica.load());
    }

    void makeFollower(Broker.Strategy strategy, AggregatedMetricValues leadershipLoadDelta) {
        this.load.subtractLoad(leadershipLoadDelta);
        this.utilization.subtractLoad(strategy, leadershipLoadDelta);
    }

    public void state(CellState state) {
        this.state = state;
    }

    public int id() {
        return this.id;
    }

    public Collection<Broker> brokers() {
        return this.brokers.values();
    }

    public Collection<Broker> aliveBrokers() {
        return this.brokers.values().stream().filter(Broker::isAlive).collect(Collectors.toList());
    }

    public Collection<Broker> eligibleBrokers() {
        return this.eligibleDestinationBrokers();
    }

    public Collection<Broker> eligibleDestinationBrokers() {
        return this.brokers.values().stream().filter(Broker::isEligibleDestination).collect(Collectors.toList());
    }

    public Collection<Broker> eligibleSourceBrokers() {
        return this.brokers.values().stream().filter(Broker::isEligibleSource).collect(Collectors.toList());
    }

    public Collection<Broker> eligibleSourceOrDestinationBrokers() {
        return this.brokers.values().stream().filter(Broker::isEligible).collect(Collectors.toList());
    }

    public Broker broker(int brokerId) {
        return this.brokers.get(brokerId);
    }

    public boolean containsBroker(int brokerId) {
        return this.brokers.containsKey(brokerId);
    }

    public List<Replica> replicas() {
        return this.brokers.values().stream().flatMap(broker -> broker.replicas().stream()).collect(Collectors.toList());
    }

    public long numTopicReplicas(String topic) {
        return this.brokers.values().stream().mapToInt(broker -> broker.numReplicasOfTopicInBroker(topic)).sum();
    }

    public int numReplicas() {
        return this.brokers.values().stream().mapToInt(broker -> broker.replicas().size()).sum();
    }

    public Set<String> topics() {
        return this.brokers.values().stream().flatMap(broker -> broker.topics().stream()).collect(Collectors.toSet());
    }

    public boolean isAlive() {
        return this.brokers.values().stream().anyMatch(Broker::isAlive);
    }

    public boolean isEligibleDestination() {
        return this.state != CellState.EXCLUDED && this.brokers.values().stream().anyMatch(Broker::isEligibleDestination);
    }

    public boolean isQuarantined() {
        return CellState.QUARANTINED.equals((Object)this.state);
    }

    public boolean isImaginaryCell() {
        return Cell.isImaginaryCellId(this.id);
    }

    public boolean isDefaultCell() {
        return Cell.isDefaultCellId(this.id);
    }

    public double utilizationRatioBetweenSourceAndDestinationBrokers(Resource resource) {
        return this.utilization.eligibleSourceUtilization().map(load -> load.expectedUtilizationFor(resource) / this.eligibleCellDestinationCapacityFor(resource)).orElse(0.0);
    }

    private double eligibleCellDestinationCapacityFor(Resource resource) {
        return this.capacity.eligibleDestinationCapacityFor(resource);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cell cell = (Cell)o;
        return this.id == cell.id;
    }

    public int hashCode() {
        return Integer.hashCode(this.id);
    }

    public String toString() {
        return String.format("Cell {id=%d, brokers=(%s), state=%s}", this.id, this.brokers.keySet(), this.state.toString());
    }
}

