/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.kafka.cruisecontrol.analyzer.AnalyzerUtils;

public class ModelUtils {
    public static final String BROKER_ID = "brokerid";
    public static final String BROKER_STATE = "brokerstate";
    public static final String REPLICAS = "replicas";
    public static final String IS_LEADER = "isLeader";
    public static final String TOPIC = "topic";
    public static final String PARTITION = "partition";
    public static final String LOAD = "load";
    public static final String METRIC_VALUES = "MetricValues";
    public static final String NAME = "name";
    public static final String BROKERS = "brokers";
    public static final String RACK_ID = "rackid";
    public static final String HOSTS = "hosts";
    private static final double ALLOWED_METRIC_ERROR_FACTOR = 1.05;
    private static final int UNSTABLE_METRIC_THROUGHPUT_THRESHOLD = 10;
    private static final int UNSTABLE_METRIC_REQUEST_THRESHOLD = 10;
    private static final int MIN_BYTES_RATE = 1;
    private static final int MIN_REQUEST_RATE = 1;

    private ModelUtils() {
    }

    public static double estimateCpuUtil(double brokerCpuUtil, double brokerTotalBytesInRate, double brokerTotalBytesOutRate, double brokerProduceRate, double brokerFetchRate, double totalReplicaBytesInRate, double totalReplicaBytesOutRate, double replicaProduceRate, double replicaFetchRate, double requestContributionWeight, double bytesContributionWeight) {
        if (AnalyzerUtils.compare(brokerTotalBytesInRate + brokerTotalBytesOutRate, 0.0, 1.0) == 0 || AnalyzerUtils.compare(brokerFetchRate + brokerProduceRate, 0.0, 1.0) == 0) {
            return 0.0;
        }
        if (brokerTotalBytesInRate * 1.05 < totalReplicaBytesInRate && brokerTotalBytesInRate > 10.0) {
            throw new IllegalArgumentException(String.format("The replica bytes in rate %f is greater than the broker bytes in rate %f", totalReplicaBytesInRate, brokerTotalBytesInRate));
        }
        if (brokerTotalBytesOutRate * 1.05 < totalReplicaBytesOutRate && brokerTotalBytesOutRate > 10.0) {
            throw new IllegalArgumentException(String.format("The replica bytes out rate %f is greater than the broker bytes out rate %f", totalReplicaBytesOutRate, brokerTotalBytesOutRate));
        }
        if (brokerProduceRate * 1.05 < replicaProduceRate && brokerProduceRate > 10.0) {
            throw new IllegalArgumentException(String.format("The replica produce rate %f is greater than the broker produce rate %f", replicaProduceRate, brokerProduceRate));
        }
        if (brokerFetchRate * 1.05 < replicaFetchRate && brokerFetchRate > 10.0) {
            throw new IllegalArgumentException(String.format("The replica fetch rate %f is greater than the broker fetch rate %f", replicaFetchRate, brokerFetchRate));
        }
        double replicaRequestContribution = (replicaFetchRate + replicaProduceRate) / (brokerFetchRate + brokerProduceRate);
        double replicaBytesContribution = (totalReplicaBytesInRate + totalReplicaBytesOutRate) / (brokerTotalBytesInRate + brokerTotalBytesOutRate);
        double replicaContribution = replicaRequestContribution * requestContributionWeight + replicaBytesContribution * bytesContributionWeight;
        return brokerCpuUtil * replicaContribution;
    }
}

