/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregatedMetricValues;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityInfo;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.Capacity;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import com.linkedin.kafka.cruisecontrol.model.Host;
import com.linkedin.kafka.cruisecontrol.model.Load;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.model.ResourceStats;
import com.linkedin.kafka.cruisecontrol.model.Utilization;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;

public class Rack
implements Serializable,
ResourceStats {
    private static final long serialVersionUID = 6866290448556002509L;
    private final String id;
    private final Map<String, Host> hosts;
    private final Map<Integer, Broker> brokers;
    private final Load load;
    private final Utilization utilization;
    private final Capacity capacity;

    public Rack(String id) {
        this.id = id;
        this.hosts = new HashMap<String, Host>();
        this.brokers = new HashMap<Integer, Broker>();
        this.load = new Load();
        this.utilization = Utilization.from(this.load);
        this.capacity = Capacity.create();
    }

    @Override
    public Load load() {
        return this.load;
    }

    @Override
    public Utilization utilization() {
        return this.utilization;
    }

    public String id() {
        return this.id;
    }

    public Collection<Broker> brokers() {
        return this.brokers.values();
    }

    public Collection<Host> hosts() {
        return this.hosts.values();
    }

    public Broker broker(int brokerId) {
        return this.brokers.get(brokerId);
    }

    public List<Replica> replicas() {
        ArrayList<Replica> replicas = new ArrayList<Replica>();
        for (Host host : this.hosts.values()) {
            replicas.addAll(host.replicas());
        }
        return replicas;
    }

    public int numTopicReplicas(String topic) {
        int numTopicReplicas = 0;
        for (Host host : this.hosts.values()) {
            numTopicReplicas += host.numTopicReplicas(topic);
        }
        return numTopicReplicas;
    }

    public Set<String> topics() {
        HashSet<String> topics = new HashSet<String>();
        for (Broker broker : this.brokers.values()) {
            topics.addAll(broker.topics());
        }
        return topics;
    }

    @Override
    public Capacity capacity() {
        return this.capacity;
    }

    public boolean isEligibleDestination() {
        return this.hosts.values().stream().anyMatch(Host::isEligibleDestination);
    }

    public boolean isRackAlive() {
        for (Host host : this.hosts.values()) {
            if (!host.isAlive()) continue;
            return true;
        }
        return false;
    }

    Replica removeReplica(int brokerId, TopicPartition tp) {
        Broker broker = this.brokers.get(brokerId);
        if (broker != null) {
            Replica removedReplica = broker.host().removeReplica(brokerId, tp);
            this.load.subtractLoad(removedReplica.load());
            this.utilization.subtractLoad(broker.strategy(), removedReplica.load());
            return removedReplica;
        }
        return null;
    }

    void addReplica(Replica replica) {
        Broker broker = replica.broker();
        broker.host().addReplica(replica);
        this.load.addLoad(replica.load());
        this.utilization.addLoad(broker.strategy(), replica.load());
    }

    void makeFollower(int brokerId, TopicPartition tp, AggregatedMetricValues leadershipLoadDelta) {
        Broker broker = this.brokers.get(brokerId);
        Host host = broker.host();
        host.makeFollower(brokerId, tp, leadershipLoadDelta);
        this.load.subtractLoad(leadershipLoadDelta);
        this.utilization.subtractLoad(broker.strategy(), leadershipLoadDelta);
    }

    void makeLeader(int brokerId, TopicPartition tp, AggregatedMetricValues leadershipLoadDelta) {
        Broker broker = this.brokers.get(brokerId);
        Host host = broker.host();
        host.makeLeader(brokerId, tp, leadershipLoadDelta);
        this.load.addLoad(leadershipLoadDelta);
        this.utilization.addLoad(broker.strategy(), leadershipLoadDelta);
    }

    void setReplicaLoad(int brokerId, TopicPartition tp, AggregatedMetricValues aggregatedMetricValues, List<Long> windows) {
        Broker broker = this.brokers.get(brokerId);
        Host host = broker.host();
        host.setReplicaLoad(brokerId, tp, aggregatedMetricValues, windows);
        this.load.addMetricValues(aggregatedMetricValues, windows);
        this.utilization.addMetricValues(broker.strategy(), aggregatedMetricValues, windows);
    }

    Broker createBroker(int brokerId, String hostName, Cell cell, BrokerCapacityInfo brokerCapacityInfo, boolean populateReplicaPlacementInfo, Broker.Strategy strategy) {
        Host host = this.hosts.computeIfAbsent(hostName, name -> new Host((String)name, this));
        Broker broker = host.createBroker(brokerId, cell, brokerCapacityInfo, populateReplicaPlacementInfo, strategy);
        this.brokers.put(brokerId, broker);
        if (broker.isAlive()) {
            this.capacity.addCapacity(Capacity.from(broker, brokerCapacityInfo));
        }
        return broker;
    }

    public Map<String, Object> getJsonStructure() {
        ArrayList<Map<String, Object>> hostList = new ArrayList<Map<String, Object>>();
        for (Host host : this.hosts.values()) {
            hostList.add(host.getJsonStructure());
        }
        HashMap<String, Object> rackMap = new HashMap<String, Object>();
        rackMap.put("rackid", this.id);
        rackMap.put("hosts", hostList);
        return rackMap;
    }

    public void writeTo(OutputStream out) throws IOException {
        String rack = String.format("<Rack id=\"%s\">%n", this.id);
        out.write(rack.getBytes(StandardCharsets.UTF_8));
        for (Host host : this.hosts.values()) {
            host.writeTo(out);
        }
        out.write("</Rack>%n".getBytes(StandardCharsets.UTF_8));
    }

    public String toString() {
        return "Rack{_id=\"" + this.id + "\", _hosts=" + this.hosts.size() + ", _brokers=" + this.brokers.size() + ", _load=" + this.load + '}';
    }
}

