/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.model.Replica;
import com.linkedin.kafka.cruisecontrol.monitor.metricdefinition.KafkaMetricDef;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class ReplicaSortFunctionFactory {
    private static final Function<Replica, Integer> PRIORITIZE_IMMIGRANTS = r -> r.originalBroker() != r.broker() ? 0 : 1;
    private static final Function<Replica, Integer> DEPRIORITIZE_IMMIGRANTS = r -> r.originalBroker() != r.broker() ? 1 : 0;
    private static final Function<Replica, Integer> PRIORITIZE_OFFLINE_REPLICAS = r -> r.isCurrentOffline() ? 0 : 1;
    private static final Function<Replica, Integer> DEPRIORITIZE_OFFLINE_REPLICAS = r -> r.isCurrentOffline() ? 1 : 0;
    private static final Function<Replica, Integer> PRIORITIZE_OFFLINE_REPLICAS_THEN_IMMIGRANTS = r -> r.isCurrentOffline() ? -1 : (r.originalBroker() != r.broker() ? 0 : 1);
    private static final Function<Replica, Integer> DEPRIORITIZE_OFFLINE_REPLICAS_THEN_IMMIGRANTS = r -> r.isCurrentOffline() ? 1 : (r.originalBroker() != r.broker() ? 0 : -1);
    private static final Function<Replica, Integer> PRIORITIZE_DISK_IMMIGRANTS = r -> r.originalDisk() != r.disk() ? 0 : 1;
    private static final Function<Replica, Integer> DEPRIORITIZE_DISK_IMMIGRANTS = r -> r.originalDisk() != r.disk() ? 1 : 0;
    private static final Function<Replica, Boolean> SELECT_LEADERS = Replica::isLeader;
    private static final Function<Replica, Boolean> SELECT_ONLINE_REPLICAS = r -> !r.isCurrentOffline();

    private ReplicaSortFunctionFactory() {
    }

    public static Function<Replica, Double> sortByMetricResourceValue(Resource resource) {
        return ReplicaSortFunctionFactory.sortByMetricResourcesValue(Collections.singletonList(resource));
    }

    public static Function<Replica, Double> sortByMetricResourcesValue(List<Resource> resources) {
        return replica -> resources.stream().mapToDouble(r -> replica.load().loadByWindows().valuesForResource((Resource)((Object)((Object)r)), KafkaMetricDef.commonMetricDef(), true).avg()).sum();
    }

    public static Function<Replica, Integer> prioritizeImmigrants() {
        return PRIORITIZE_IMMIGRANTS;
    }

    public static Function<Replica, Integer> prioritizeOfflineReplicas() {
        return PRIORITIZE_OFFLINE_REPLICAS;
    }

    public static Function<Replica, Integer> prioritizeOfflineReplicasThenImmigrants() {
        return PRIORITIZE_OFFLINE_REPLICAS_THEN_IMMIGRANTS;
    }

    public static Function<Replica, Integer> deprioritizeImmigrants() {
        return DEPRIORITIZE_IMMIGRANTS;
    }

    public static Function<Replica, Integer> deprioritizeOfflineReplicas() {
        return DEPRIORITIZE_OFFLINE_REPLICAS;
    }

    public static Function<Replica, Integer> deprioritizeOfflineReplicasThenImmigrants() {
        return DEPRIORITIZE_OFFLINE_REPLICAS_THEN_IMMIGRANTS;
    }

    public static Function<Replica, Integer> prioritizeDiskImmigrants() {
        return PRIORITIZE_DISK_IMMIGRANTS;
    }

    public static Function<Replica, Integer> deprioritizeDiskImmigrants() {
        return DEPRIORITIZE_DISK_IMMIGRANTS;
    }

    public static Function<Replica, Boolean> selectLeaders() {
        return SELECT_LEADERS;
    }

    public static Function<Replica, Boolean> selectOnlineReplicas() {
        return SELECT_ONLINE_REPLICAS;
    }
}

