/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling;

import com.linkedin.cruisecontrol.metricdef.MetricDef;
import com.linkedin.cruisecontrol.metricdef.MetricInfo;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.RawMetricType;
import com.linkedin.kafka.cruisecontrol.model.ModelUtils;
import com.linkedin.kafka.cruisecontrol.monitor.metricdefinition.KafkaMetricDef;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.BrokerLoad;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.PartitionMetricSample;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.ReplicaMetricSample;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamplingUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SamplingUtils.class);
    private static final String SKIP_BUILDING_SAMPLE_PREFIX = "Skip generating metric sample for ";
    static final Set<RawMetricType> FFF_RAW_METRIC_TYPES = new HashSet<RawMetricType>(Arrays.asList(RawMetricType.TOPIC_FETCH_FROM_FOLLOWER_BYTES_OUT, RawMetricType.TOPIC_FETCH_FROM_FOLLOWER_REQUEST_RATE));

    private SamplingUtils() {
    }

    static void populateReplicaDistribution(Cluster cluster, Map<Integer, Map<String, Integer>> leaderDistribution, Map<Integer, Map<String, Integer>> followerDistribution) {
        cluster.topics().forEach(topic -> cluster.partitionsForTopic(topic).forEach(partition -> Arrays.stream(partition.replicas()).filter(replica -> replica != null && !replica.isEmpty()).forEach(replica -> {
            boolean isLeader = partition.leader().id() == replica.id();
            Map stats = isLeader ? leaderDistribution : followerDistribution;
            Map replicaCountMap = stats.computeIfAbsent(replica.id(), ignored -> new HashMap());
            replicaCountMap.merge(topic, 1, Integer::sum);
        })));
    }

    static double estimateCpuUtil(String topic, BrokerLoad brokerLoad, boolean isLeader, int replicaCount, short numCpuCores, double requestContributionWeight, double bytesContributionWeight) {
        BrokerMetrics brokerMetrics = new BrokerMetrics(brokerLoad);
        ReplicaMetrics replicaMetrics = isLeader ? new LeaderReplicaMetrics(brokerLoad, topic, replicaCount) : new FollowerReplicaMetrics(brokerLoad, topic, replicaCount);
        return (double)numCpuCores * ModelUtils.estimateCpuUtil(brokerMetrics.brokerCpuUtilization, brokerMetrics.brokerTotalBytesInRate, brokerMetrics.brokerTotalBytesOutRate, brokerMetrics.brokerTotalProduceRate, brokerMetrics.brokerTotalFetchRate, replicaMetrics.totalReplicaBytesInRate(), replicaMetrics.totalReplicaBytesOutRate(), replicaMetrics.replicaProduceRequestRate(), replicaMetrics.replicaFetchRequestRate(), requestContributionWeight, bytesContributionWeight);
    }

    static ReplicaMetricSample buildReplicaMetricSample(PartitionInfo topicPartition, Node replicaNode, int replicaCount, Map<Integer, BrokerLoad> brokerLoadById, long minMetricTimestamp, long maxMetricTimestamp, Map<Integer, Short> cachedNumCoresByBroker, double requestContributionWeight, double bytesContributionWeight) {
        int replicaNodeId = replicaNode.id();
        boolean isLeader = replicaNodeId == topicPartition.leader().id();
        ReplicaMetricSample rms = new ReplicaMetricSample(replicaNodeId, topicPartition, isLeader);
        BrokerLoad brokerLoad = brokerLoadById.get(replicaNodeId);
        rms.open(minMetricTimestamp);
        FFF_RAW_METRIC_TYPES.forEach(rawMetricType -> {
            double sampleValue = 0.0;
            if (!isLeader) {
                sampleValue = brokerLoad.topicMetrics(topicPartition.topic(), (RawMetricType)((Object)rawMetricType)) / (double)replicaCount;
            }
            for (KafkaMetricDef metricDef : KafkaMetricDef.kafkaMetricDefsForRawMetricType(rawMetricType)) {
                rms.record(KafkaMetricDef.replicaMetricDef().metricInfo(metricDef), sampleValue);
            }
        });
        Short numCpuCores = cachedNumCoresByBroker.get(replicaNodeId);
        double estimatedCpuUtil = SamplingUtils.estimateCpuUtil(topicPartition.topic(), brokerLoad, isLeader, replicaCount, numCpuCores, requestContributionWeight, bytesContributionWeight);
        rms.record(KafkaMetricDef.replicaMetricDef().metricInfo(KafkaMetricDef.CPU_USAGE), estimatedCpuUtil);
        rms.close(maxMetricTimestamp);
        return rms;
    }

    static PartitionMetricSample buildPartitionMetricSample(Map<Integer, Map<String, Integer>> leaderDistribution, PartitionInfo topicPartition, Map<Integer, BrokerLoad> brokerLoadById, long minMetricTimestamp, long maxMetricTimestamp) {
        int leaderId = topicPartition.leader().id();
        int numLeaders = leaderDistribution.get(leaderId).get(topicPartition.topic());
        BrokerLoad brokerLoad = brokerLoadById.get(leaderId);
        PartitionMetricSample pms = new PartitionMetricSample(leaderId, new TopicPartition(topicPartition.topic(), topicPartition.partition()));
        pms.open(minMetricTimestamp);
        MetricDef partitionMetricDef = KafkaMetricDef.partitionMetricDef();
        for (RawMetricType rawMetricType : RawMetricType.topicMetricTypes()) {
            if (FFF_RAW_METRIC_TYPES.contains((Object)rawMetricType)) continue;
            double sampleValue = numLeaders == 0 ? 0.0 : brokerLoad.topicMetrics(topicPartition.topic(), rawMetricType) / (double)numLeaders;
            for (KafkaMetricDef kMetricDef : KafkaMetricDef.kafkaMetricDefsForRawMetricType(rawMetricType)) {
                MetricInfo metricInfo = partitionMetricDef.metricInfo(kMetricDef);
                pms.record(metricInfo, sampleValue);
            }
        }
        double partitionSize = brokerLoad.partitionMetric(topicPartition.topic(), topicPartition.partition(), RawMetricType.PARTITION_SIZE);
        pms.record(partitionMetricDef.metricInfo(KafkaMetricDef.DISK_USAGE), partitionSize);
        pms.close(maxMetricTimestamp);
        return pms;
    }

    static boolean skipBuildingMetricSample(PartitionInfo topicPartition, Node replicaNode, Map<Integer, BrokerLoad> brokerLoadMap, Map<Integer, Short> cachedNumCoresByBroker) {
        if (replicaNode == null) {
            LOG.trace("Partition {} replica has been assigned to null node.", (Object)topicPartition);
            return true;
        }
        int replicaNodeId = replicaNode.id();
        BrokerLoad brokerLoad = brokerLoadMap.get(replicaNodeId);
        if (brokerLoad == null || !brokerLoad.brokerMetricAvailable(RawMetricType.BROKER_CPU_UTIL)) {
            LOG.debug("{}partition {} because {} metric for broker {} is unavailable.", new Object[]{SKIP_BUILDING_SAMPLE_PREFIX, topicPartition, RawMetricType.BROKER_CPU_UTIL, replicaNodeId});
            return true;
        }
        if (cachedNumCoresByBroker.get(replicaNodeId) == null) {
            LOG.debug("{}partition {} because the number of CPU cores of its leader broker {} is unavailable. Please ensure that either the broker capacity config resolver provides the number of CPU cores without estimation or allow CPU capacity estimation during sampling (i.e. set {} to true).", new Object[]{SKIP_BUILDING_SAMPLE_PREFIX, topicPartition, replicaNodeId, "sampling.allow.cpu.capacity.estimation"});
            return true;
        }
        if (!brokerLoad.topicMetricsAvailable(topicPartition.topic())) {
            LOG.debug("{}partition {} because broker {} has no metric or topic metrics are not available", new Object[]{SKIP_BUILDING_SAMPLE_PREFIX, topicPartition, replicaNodeId});
            return true;
        }
        return false;
    }

    public static MetricsWindow currentWindow(long nowMs, long windowSizeMs) {
        return SamplingUtils.metricsWindow(SamplingUtils.windowIndex(nowMs, windowSizeMs), windowSizeMs);
    }

    public static long windowIndex(long timeMs, long windowMs) {
        return timeMs / windowMs + 1L;
    }

    private static MetricsWindow metricsWindow(long windowIndex, long windowSizeMs) {
        long startMs = windowSizeMs * (windowIndex - 1L);
        long endMs = windowSizeMs * windowIndex;
        return new MetricsWindow(startMs, endMs, windowIndex);
    }

    @Immutable
    public static class MetricsWindow {
        private final long sizeMs;
        private final long startMs;
        private final long endMs;
        private final long index;
        private static final Long EMPTY_WINDOW_END_MS = 0L;
        private static final Long EMPTY_WINDOW_INDEX = 0L;

        public MetricsWindow(long startMs, long endMs, long index) {
            this.startMs = startMs;
            this.endMs = endMs;
            this.sizeMs = endMs - startMs;
            this.index = index;
        }

        public static MetricsWindow empty(long windowSizeMs) {
            return new MetricsWindow(-windowSizeMs, EMPTY_WINDOW_END_MS, EMPTY_WINDOW_INDEX);
        }

        public long sizeMs() {
            return this.sizeMs;
        }

        public long index() {
            return this.index;
        }

        public MetricsWindow nextWindow() {
            return SamplingUtils.metricsWindow(this.index + 1L, this.sizeMs);
        }

        public MetricsWindow previousWindow() {
            return SamplingUtils.metricsWindow(this.index - 1L, this.sizeMs);
        }

        public long startMs() {
            return this.startMs;
        }

        public long endMsInclusive() {
            return this.endMs - 1L;
        }

        public String toConciseString() {
            return "(index: " + this.index + ", " + this.timeStringRange() + ")";
        }

        public String toString() {
            return "MetricsWindow{sizeMs=" + this.sizeMs + ", startMs=" + this.startMs + ", endMs=" + this.endMs + ", endMsInclusive=" + this.endMsInclusive() + ", index=" + this.index + "}(" + this.timeStringRange() + ")";
        }

        private String timeStringRange() {
            return KafkaCruiseControlUtils.toTimeStringOrNonePlaceholder(this.startMs) + " - " + KafkaCruiseControlUtils.toTimeStringOrNonePlaceholder(this.endMsInclusive());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetricsWindow that = (MetricsWindow)o;
            return this.sizeMs == that.sizeMs && this.startMs == that.startMs && this.endMs == that.endMs && this.index == that.index;
        }

        public int hashCode() {
            return Objects.hash(this.sizeMs, this.startMs, this.endMs, this.index);
        }
    }

    private static class FollowerReplicaMetrics
    implements ReplicaMetrics {
        private final double replicaProduceRequestRate;
        private final double replicaFetchRequestRate;
        private final double totalReplicaBytesInRate;
        private final double totalReplicaBytesOutRate;

        public FollowerReplicaMetrics(BrokerLoad brokerLoad, String topic, int followerCount) {
            double replicaProduceRequestRate = 0.0;
            double followerFetchRequestRate = brokerLoad.topicMetrics(topic, RawMetricType.TOPIC_FOLLOWER_FETCH_REQUEST_RATE) / (double)followerCount;
            double fetchFromFollowerRequestRate = brokerLoad.topicMetrics(topic, RawMetricType.TOPIC_FETCH_FROM_FOLLOWER_REQUEST_RATE) / (double)followerCount;
            double replicaProduceBytesInRate = 0.0;
            double replicaReplicationBytesInRate = brokerLoad.topicMetrics(topic, RawMetricType.TOPIC_REPLICATION_BYTES_IN) / (double)followerCount;
            double replicaFetchFromFollowerBytesOutRate = brokerLoad.topicMetrics(topic, RawMetricType.TOPIC_FETCH_FROM_FOLLOWER_BYTES_OUT) / (double)followerCount;
            double replicaReplicationBytesOutRate = 0.0;
            this.replicaProduceRequestRate = replicaProduceRequestRate;
            this.replicaFetchRequestRate = followerFetchRequestRate + fetchFromFollowerRequestRate;
            this.totalReplicaBytesInRate = replicaProduceBytesInRate + replicaReplicationBytesInRate;
            this.totalReplicaBytesOutRate = replicaFetchFromFollowerBytesOutRate + replicaReplicationBytesOutRate;
        }

        @Override
        public double totalReplicaBytesInRate() {
            return this.totalReplicaBytesInRate;
        }

        @Override
        public double totalReplicaBytesOutRate() {
            return this.totalReplicaBytesOutRate;
        }

        @Override
        public double replicaProduceRequestRate() {
            return this.replicaProduceRequestRate;
        }

        @Override
        public double replicaFetchRequestRate() {
            return this.replicaFetchRequestRate;
        }
    }

    private static class LeaderReplicaMetrics
    implements ReplicaMetrics {
        private final double replicaProduceRequestRate;
        private final double replicaFetchRequestRate;
        private final double totalReplicaBytesInRate;
        private final double totalReplicaBytesOutRate;

        public LeaderReplicaMetrics(BrokerLoad brokerLoad, String topic, int leaderCount) {
            double replicaProduceRequestRate = brokerLoad.topicMetrics(topic, RawMetricType.TOPIC_PRODUCE_REQUEST_RATE) / (double)leaderCount;
            double replicaFetchRequestRate = brokerLoad.topicMetrics(topic, RawMetricType.TOPIC_FETCH_REQUEST_RATE) / (double)leaderCount;
            double replicaFetchFromFollowerRequestRate = 0.0;
            double replicaProduceBytesInRate = brokerLoad.topicMetrics(topic, RawMetricType.TOPIC_BYTES_IN) / (double)leaderCount;
            double replicaReplicationBytesInRate = 0.0;
            double replicaConsumeBytesOutRate = brokerLoad.topicMetrics(topic, RawMetricType.TOPIC_BYTES_OUT) / (double)leaderCount;
            double replicaReplicationBytesOutRate = brokerLoad.topicMetrics(topic, RawMetricType.TOPIC_REPLICATION_BYTES_OUT) / (double)leaderCount;
            double replicaFetchFromFollowerBytesOutRate = 0.0;
            this.replicaProduceRequestRate = replicaProduceRequestRate;
            this.replicaFetchRequestRate = replicaFetchRequestRate - replicaFetchFromFollowerRequestRate;
            this.totalReplicaBytesInRate = replicaProduceBytesInRate + replicaReplicationBytesInRate;
            this.totalReplicaBytesOutRate = replicaConsumeBytesOutRate + replicaReplicationBytesOutRate - replicaFetchFromFollowerBytesOutRate;
        }

        @Override
        public double totalReplicaBytesInRate() {
            return this.totalReplicaBytesInRate;
        }

        @Override
        public double totalReplicaBytesOutRate() {
            return this.totalReplicaBytesOutRate;
        }

        @Override
        public double replicaProduceRequestRate() {
            return this.replicaProduceRequestRate;
        }

        @Override
        public double replicaFetchRequestRate() {
            return this.replicaFetchRequestRate;
        }
    }

    private static interface ReplicaMetrics {
        public double totalReplicaBytesInRate();

        public double totalReplicaBytesOutRate();

        public double replicaProduceRequestRate();

        public double replicaFetchRequestRate();
    }

    private static class BrokerMetrics {
        final double brokerCpuUtilization;
        final double brokerTotalBytesInRate;
        final double brokerTotalBytesOutRate;
        final double brokerTotalProduceRate;
        final double brokerTotalFetchRate;

        public BrokerMetrics(BrokerLoad brokerLoad) {
            this.brokerCpuUtilization = brokerLoad.brokerMetric(RawMetricType.BROKER_CPU_UTIL);
            this.brokerTotalBytesInRate = brokerLoad.brokerMetric(RawMetricType.ALL_TOPIC_BYTES_IN) + brokerLoad.brokerMetric(RawMetricType.ALL_TOPIC_REPLICATION_BYTES_IN);
            this.brokerTotalBytesOutRate = brokerLoad.brokerMetric(RawMetricType.ALL_TOPIC_BYTES_OUT) + brokerLoad.brokerMetric(RawMetricType.ALL_TOPIC_REPLICATION_BYTES_OUT) + brokerLoad.brokerMetric(RawMetricType.ALL_TOPIC_FETCH_FROM_FOLLOWER_BYTES_OUT);
            this.brokerTotalProduceRate = brokerLoad.brokerMetric(RawMetricType.ALL_TOPIC_PRODUCE_REQUEST_RATE);
            this.brokerTotalFetchRate = brokerLoad.brokerMetric(RawMetricType.ALL_TOPIC_FETCH_REQUEST_RATE) + brokerLoad.brokerMetric(RawMetricType.ALL_TOPIC_FOLLOWER_FETCH_REQUEST_RATE) + brokerLoad.brokerMetric(RawMetricType.ALL_TOPIC_FETCH_FROM_FOLLOWER_REQUEST_RATE);
        }
    }
}

