/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling.aggregator;

import com.linkedin.cruisecontrol.exception.NotEnoughValidWindowsException;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregationOptions;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleAggregationResult;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleAggregator;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleCompleteness;
import com.linkedin.kafka.cruisecontrol.async.progress.OperationProgress;
import com.linkedin.kafka.cruisecontrol.async.progress.RetrievingMetrics;
import com.linkedin.kafka.cruisecontrol.common.MetadataClient;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import com.linkedin.kafka.cruisecontrol.monitor.metricdefinition.KafkaMetricDef;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.PartitionEntity;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.PartitionMetricSample;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPartitionMetricSampleAggregator
extends MetricSampleAggregator<PartitionEntity> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaPartitionMetricSampleAggregator.class);
    static final long FIRST_METRIC_WINDOW_TIMESTAMP = -1L;
    private final int maxAllowedExtrapolationsPerPartition;
    private final MetadataClient metadataClient;

    public KafkaPartitionMetricSampleAggregator(KafkaCruiseControlConfig config, MetadataClient metadataClient) {
        super(config.getInt("num.partition.metrics.windows"), config.getLong("partition.metrics.window.ms"), config.getInt("min.samples.per.partition.metrics.window").byteValue(), config.getInt("partition.metric.sample.aggregator.completeness.cache.size"), KafkaMetricDef.partitionMetricDef());
        this.metadataClient = metadataClient;
        this.maxAllowedExtrapolationsPerPartition = config.getInt("max.allowed.extrapolations.per.partition");
        this.sampleType = MetricSampleAggregator.SampleType.PARTITION;
    }

    public boolean addSample(PartitionMetricSample sample) {
        return this.isValidSample(sample) && super.addSample(sample);
    }

    public MetricSampleAggregationResult<PartitionEntity> aggregate(MetadataClient.ClusterAndGeneration clusterAndGeneration, long now, OperationProgress operationProgress, String reason) throws NotEnoughValidWindowsException {
        ModelCompletenessRequirements requirements = new ModelCompletenessRequirements(1, 0.0, false);
        return this.aggregate(clusterAndGeneration, now, requirements, operationProgress, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricSampleAggregationResult<PartitionEntity> aggregate(MetadataClient.ClusterAndGeneration clusterAndGeneration, long now, ModelCompletenessRequirements requirements, OperationProgress operationProgress, String reason) throws NotEnoughValidWindowsException {
        RetrievingMetrics step = new RetrievingMetrics();
        try {
            operationProgress.addStep(step);
            MetricSampleAggregationResult<PartitionEntity> metricSampleAggregationResult = this.aggregate(-1L, now, this.toAggregationOptions(clusterAndGeneration.cluster(), requirements, reason));
            return metricSampleAggregationResult;
        }
        finally {
            step.done();
        }
    }

    public Set<Long> validWindows(MetadataClient.ClusterAndGeneration clusterAndGeneration, double minMonitoredPartitionsPercentage) {
        AggregationOptions<PartitionEntity> options = new AggregationOptions<PartitionEntity>(minMonitoredPartitionsPercentage, 0.0, 1, this.maxAllowedExtrapolationsPerPartition, this.allPartitions(clusterAndGeneration.cluster()), AggregationOptions.Granularity.ENTITY_GROUP, true);
        MetricSampleCompleteness<PartitionEntity> completeness = this.completeness(-1L, Long.MAX_VALUE, options);
        return this.windowIndicesToWindows(completeness.validWindowIndices(), this.windowMs);
    }

    public double monitoredPercentage(MetadataClient.ClusterAndGeneration clusterAndGeneration) {
        AggregationOptions<PartitionEntity> options = new AggregationOptions<PartitionEntity>(0.0, 0.0, 1, this.maxAllowedExtrapolationsPerPartition, this.allPartitions(clusterAndGeneration.cluster()), AggregationOptions.Granularity.ENTITY_GROUP, true, "computing the monitored partition percentage");
        MetricSampleCompleteness<PartitionEntity> completeness = this.completeness(-1L, Long.MAX_VALUE, options);
        return completeness.validEntityRatio();
    }

    public Map<Long, Float> validPartitionRatioByWindows(MetadataClient.ClusterAndGeneration clusterAndGeneration) {
        AggregationOptions<PartitionEntity> options = new AggregationOptions<PartitionEntity>(0.0, 0.0, 1, this.maxAllowedExtrapolationsPerPartition, this.allPartitions(clusterAndGeneration.cluster()), AggregationOptions.Granularity.ENTITY_GROUP, true);
        MetricSampleCompleteness<PartitionEntity> completeness = this.completeness(-1L, Long.MAX_VALUE, options);
        return this.windowIndicesToWindows(completeness.validEntityRatioWithGroupGranularityByWindowIndex(), this.windowMs);
    }

    private Set<PartitionEntity> allPartitions(Cluster cluster) {
        HashSet<PartitionEntity> allPartitions = new HashSet<PartitionEntity>();
        for (String topic : cluster.topics()) {
            for (PartitionInfo partitionInfo : cluster.partitionsForTopic(topic)) {
                TopicPartition tp = new TopicPartition(partitionInfo.topic(), partitionInfo.partition());
                PartitionEntity partitionEntity = new PartitionEntity(tp);
                allPartitions.add(this.identity(partitionEntity));
            }
        }
        return allPartitions;
    }

    private boolean isValidSample(PartitionMetricSample sample) {
        boolean completeMetrics;
        boolean validLeader = this.isValidLeader(sample);
        boolean bl = completeMetrics = sample.isValid(this.metricDef) || sample.allMetricValues().size() == this.metricDef.size() - 2 && sample.allMetricValues().containsKey(this.metricDef.metricInfo(KafkaMetricDef.REPLICATION_BYTES_IN_RATE).id()) && sample.allMetricValues().containsKey(this.metricDef.metricInfo(KafkaMetricDef.REPLICATION_BYTES_OUT_RATE).id());
        if (!completeMetrics) {
            LOG.warn("The metric sample is discarded due to missing metrics. Sample: {}", (Object)sample);
        }
        return validLeader && completeMetrics;
    }

    public boolean isValidLeader(PartitionMetricSample sample) {
        boolean validLeader;
        Node leader = this.metadataClient.cluster().leaderFor(((PartitionEntity)sample.entity()).tp());
        boolean bl = validLeader = leader != null && sample.brokerId() == leader.id();
        if (!validLeader) {
            LOG.warn("The metric sample will be discarded due to invalid leader. Current leader {}, Sample: {}", (Object)leader, (Object)sample);
        }
        return validLeader;
    }

    private AggregationOptions<PartitionEntity> toAggregationOptions(Cluster cluster, ModelCompletenessRequirements requirements, String reason) {
        Set<PartitionEntity> allPartitions = this.allPartitions(cluster);
        return new AggregationOptions<PartitionEntity>(requirements.minMonitoredPartitionsPercentage(), 0.0, requirements.minRequiredNumWindows(), this.maxAllowedExtrapolationsPerPartition, allPartitions, AggregationOptions.Granularity.ENTITY_GROUP, requirements.includeAllTopics(), reason);
    }
}

