/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.operation;

import io.confluent.databalancer.operation.BalancerOperationCallback;
import io.confluent.databalancer.operation.BrokerAdditionStateMachine;
import io.confluent.databalancer.operation.BrokerAdditionStateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiBrokerAdditionOperation
implements BalancerOperationCallback<BrokerAdditionStateMachine.BrokerAdditionState, BrokerAdditionStateMachine.BrokerAdditionEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(MultiBrokerAdditionOperation.class);
    private final Set<Integer> brokerIds;
    List<BrokerAdditionStateManager> stateManagers;

    public MultiBrokerAdditionOperation(Set<Integer> brokerIds, List<BrokerAdditionStateManager> stateManagers) {
        Objects.requireNonNull(stateManagers);
        if (stateManagers.isEmpty()) {
            throw new IllegalArgumentException("Cannot track the state of 0 broker additions.");
        }
        if (!stateManagers.stream().allMatch(BrokerAdditionStateManager::isInitialized)) {
            throw new IllegalArgumentException("All state managers must be initialized.");
        }
        this.brokerIds = brokerIds;
        this.stateManagers = stateManagers;
    }

    public Set<Integer> brokerIds() {
        return this.brokerIds;
    }

    @Override
    public BrokerAdditionStateMachine.BrokerAdditionState currentState() {
        Set states = this.stateManagers.stream().map(BrokerAdditionStateManager::currentState).collect(Collectors.toSet());
        if (states.size() != 1) {
            String statesMappingStr = this.stateManagers.stream().collect(Collectors.toMap(BrokerAdditionStateManager::brokerId, BrokerAdditionStateManager::currentState)).toString();
            throw new IllegalStateException("Found broker additions in different states - " + statesMappingStr);
        }
        return this.stateManagers.get(0).currentState();
    }

    @Override
    public void registerEvent(BrokerAdditionStateMachine.BrokerAdditionEvent event) {
        this.registerEvent(event, (Exception)null);
    }

    @Override
    public void registerEvent(BrokerAdditionStateMachine.BrokerAdditionEvent event, Exception e) {
        ArrayList<String> successfullyRegisteredAdditions = new ArrayList<String>();
        for (BrokerAdditionStateManager stateManager : this.stateManagers) {
            try {
                stateManager.registerEvent(event, e);
                successfullyRegisteredAdditions.add(Integer.toString(stateManager.brokerId()));
            }
            catch (Exception exception) {
                String registeredMsg = successfullyRegisteredAdditions.size() > 0 ? String.format("Already registered the event for brokers %s successfully", String.join((CharSequence)",", successfullyRegisteredAdditions)) : "Did not register the event for any other broker addition.";
                LOG.error("{}: Failed to register the event {} for the broker addition of broker {}. {}. The cause was:", new Object[]{this.toString(), event, stateManager.brokerId(), registeredMsg, exception});
                throw exception;
            }
        }
    }

    public String toString() {
        return "MultiBrokerAdditionOperation{brokers=" + this.brokerIds + "}";
    }
}

