/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cruisecontrol.metricsreporter.opentelemetry;

import com.google.protobuf.AbstractParser;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Parser;
import io.confluent.cruisecontrol.metricsreporter.opentelemetry.AttributeResult;
import io.confluent.cruisecontrol.metricsreporter.opentelemetry.SbcResourceMetrics;
import io.confluent.cruisecontrol.metricsreporter.opentelemetry.WireFormatHelpers;
import io.opentelemetry.proto.common.v1.AnyValue;
import io.opentelemetry.proto.metrics.v1.ScopeMetrics;
import java.io.IOException;
import java.util.ArrayList;

final class ProtoResourceMetricsParser
extends AbstractParser<SbcResourceMetrics> {
    private static final int RESOURCE_FIELD_NUMBER = 1;
    private static final int RESOURCE_FIELD_TAG = WireFormatHelpers.makeTag(1, 2);
    private static final int SCOPE_METRICS_NUMBER = 2;
    private static final int SCOPE_METRICS_NUMBER_TAG = WireFormatHelpers.makeTag(2, 2);

    ProtoResourceMetricsParser() {
    }

    public SbcResourceMetrics parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        try {
            ArrayList<ScopeMetrics> scopeMetricsList = new ArrayList<ScopeMetrics>();
            String brokerId = "";
            while (!WireFormatHelpers.isMessageEndReached(input)) {
                int tag = input.readTag();
                if (tag == RESOURCE_FIELD_TAG) {
                    AttributeResult result = (AttributeResult)input.readMessage((Parser)AttributeResult.RESOURCE_PARSER, extensionRegistry);
                    if (!result.found || result.value == AnyValue.getDefaultInstance()) continue;
                    brokerId = result.value.getStringValue();
                    continue;
                }
                if (tag == SCOPE_METRICS_NUMBER_TAG) {
                    ScopeMetrics scopeMetrics = (ScopeMetrics)input.readMessage(ScopeMetrics.parser(), extensionRegistry);
                    if (scopeMetrics == null) continue;
                    scopeMetricsList.add(scopeMetrics);
                    continue;
                }
                input.skipField(tag);
            }
            return new SbcResourceMetrics(scopeMetricsList, brokerId);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e);
        }
    }
}

