/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.persistence;

import io.confluent.databalancer.operation.BrokerAdditionV2StateMachine;
import io.confluent.databalancer.persistence.AddBrokerStateSerializer;
import io.confluent.databalancer.persistence.ApiStatePersistenceStore;
import io.confluent.databalancer.persistence.BrokerAdditionStateRecord;
import io.confluent.databalancer.record.AddBrokerV2;

public class BrokerAdditionStateRecordSerde {
    private static final int CURRENT_RECORD_VERSION = 1;
    private static final AddBrokerStateSerializer STATE_SERIALIZER = new AddBrokerStateSerializer();

    public static AddBrokerV2.AddBrokerStateRecordProto serialize(BrokerAdditionStateRecord stateRecord) {
        String error = "";
        if (stateRecord.exception() != null) {
            error = ApiStatePersistenceStore.serializeException(stateRecord.exception());
        }
        return AddBrokerV2.AddBrokerStateRecordProto.newBuilder().setVersion(1).setBase64SerializedException(error).setBrokerId(stateRecord.brokerId()).setStartTimeMs(stateRecord.startTimeMs()).setLastUpdateTimeMs(stateRecord.lastUpdateTimeMs()).setState((AddBrokerV2.AdditionState)STATE_SERIALIZER.serialize(stateRecord.state())).build();
    }

    public static BrokerAdditionStateRecord deserialize(AddBrokerV2.AddBrokerStateRecordProto persistedRecord) {
        Exception ex = null;
        String serializedException = persistedRecord.getBase64SerializedException();
        if (!serializedException.isEmpty()) {
            ex = ApiStatePersistenceStore.deserializeException(serializedException);
        }
        return new BrokerAdditionStateRecord(persistedRecord.getBrokerId(), (BrokerAdditionV2StateMachine.BrokerAdditionV2State)STATE_SERIALIZER.deserialize(persistedRecord.getState()), ex, persistedRecord.getStartTimeMs(), persistedRecord.getLastUpdateTimeMs());
    }
}

