/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.Tenant;
import org.apache.kafka.common.metadata.RemoveTenantRecord;
import org.apache.kafka.common.metadata.TenantRecord;
import org.apache.kafka.image.TenantImage;

public class TenantDelta {
    private final Map<String, Tenant> tenantIdToTenant;

    public TenantDelta(TenantImage image) {
        this.tenantIdToTenant = new HashMap<String, Tenant>(image.tenantIdToTenant());
    }

    public void replay(TenantRecord record) {
        this.tenantIdToTenant.put(record.tenantId(), new Tenant(record.tenantId(), record.cellId()));
    }

    public void replay(RemoveTenantRecord record) {
        this.tenantIdToTenant.remove(record.tenantId());
    }

    public TenantImage apply() {
        return new TenantImage(this.tenantIdToTenant);
    }

    public void finishSnapshot() {
    }

    public String toString() {
        return "TenantImage{latestTenantIdToTenant=" + this.tenantIdToTenant + "}";
    }
}

