/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.metrics;

import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Min;
import org.apache.kafka.coordinator.group.metrics.CoordinatorRuntimeMetrics;
import org.apache.kafka.coordinator.group.runtime.CoordinatorRuntime;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;

public class GroupCoordinatorRuntimeMetrics
implements CoordinatorRuntimeMetrics {
    public static final String METRICS_GROUP = "group-coordinator-metrics";
    public static final String NUM_PARTITIONS_METRIC_NAME = "num-partitions";
    private final MetricName numPartitionsLoading;
    private final AtomicLong numPartitionsLoadingCounter = new AtomicLong(0L);
    private final MetricName numPartitionsActive;
    private final AtomicLong numPartitionsActiveCounter = new AtomicLong(0L);
    private final MetricName numPartitionsFailed;
    private final AtomicLong numPartitionsFailedCounter = new AtomicLong(0L);
    private final MetricName eventQueueSize;
    private final com.yammer.metrics.core.MetricName eventQueueTimeMs = KafkaYammerMetrics.getMetricName((String)"kafka.coordinator.group", (String)"group-coordinator-metrics", (String)"EventQueueTimeMs");
    private final com.yammer.metrics.core.MetricName eventQueueProcessingTimeMs = KafkaYammerMetrics.getMetricName((String)"kafka.coordinator.group", (String)"group-coordinator-metrics", (String)"EventQueueProcessingTimeMs");
    private final MetricsRegistry registry;
    private final Metrics metrics;
    private Sensor partitionLoadSensor;
    private Sensor threadIdleRatioSensor;
    private final Consumer<Long> eventQueueTimeUpdater;
    private final Consumer<Long> eventQueueProcessingTimeUpdater;

    public GroupCoordinatorRuntimeMetrics(MetricsRegistry registry, Metrics metrics) {
        this.registry = Objects.requireNonNull(registry);
        this.metrics = Objects.requireNonNull(metrics);
        this.numPartitionsLoading = this.kafkaMetricName(NUM_PARTITIONS_METRIC_NAME, "The number of partitions in Loading state.", "state", "loading");
        this.numPartitionsActive = this.kafkaMetricName(NUM_PARTITIONS_METRIC_NAME, "The number of partitions in Active state.", "state", "active");
        this.numPartitionsFailed = this.kafkaMetricName(NUM_PARTITIONS_METRIC_NAME, "The number of partitions in Failed state.", "state", "failed");
        this.eventQueueSize = this.kafkaMetricName("event-queue-size", "The event accumulator queue size.", new String[0]);
        metrics.addMetric(this.numPartitionsLoading, (MetricValueProvider)((Gauge)(config, now) -> this.numPartitionsLoadingCounter.get()));
        metrics.addMetric(this.numPartitionsActive, (MetricValueProvider)((Gauge)(config, now) -> this.numPartitionsActiveCounter.get()));
        metrics.addMetric(this.numPartitionsFailed, (MetricValueProvider)((Gauge)(config, now) -> this.numPartitionsFailedCounter.get()));
        this.partitionLoadSensor = metrics.sensor("GroupPartitionLoadTime");
        this.partitionLoadSensor.add(metrics.metricName("partition-load-time-max", METRICS_GROUP, "The max time it took to load the partitions in the last 30 sec."), (MeasurableStat)new Max());
        this.partitionLoadSensor.add(metrics.metricName("partition-load-time-avg", METRICS_GROUP, "The average time it took to load the partitions in the last 30 sec."), (MeasurableStat)new Avg());
        this.threadIdleRatioSensor = metrics.sensor("ThreadIdleRatio");
        this.threadIdleRatioSensor.add(metrics.metricName("thread-idle-ratio-min", METRICS_GROUP, "The minimum thread idle ratio over the last 30 seconds."), (MeasurableStat)new Min());
        this.threadIdleRatioSensor.add(metrics.metricName("thread-idle-ratio-avg", METRICS_GROUP, "The average thread idle ratio over the last 30 seconds."), (MeasurableStat)new Avg());
        this.eventQueueTimeUpdater = this.newHistogram(this.eventQueueTimeMs);
        this.eventQueueProcessingTimeUpdater = this.newHistogram(this.eventQueueProcessingTimeMs);
    }

    private MetricName kafkaMetricName(String name, String description, String ... keyValue) {
        return this.metrics.metricName(name, METRICS_GROUP, description, keyValue);
    }

    private Consumer<Long> newHistogram(com.yammer.metrics.core.MetricName name) {
        Histogram histogram = this.registry.newHistogram(name, true);
        return arg_0 -> ((Histogram)histogram).update(arg_0);
    }

    @Override
    public void close() {
        Arrays.asList(this.numPartitionsLoading, this.numPartitionsActive, this.numPartitionsFailed, this.eventQueueSize).forEach(arg_0 -> ((Metrics)this.metrics).removeMetric(arg_0));
        Arrays.asList(this.eventQueueTimeMs, this.eventQueueProcessingTimeMs).forEach(arg_0 -> ((MetricsRegistry)this.registry).removeMetric(arg_0));
        this.metrics.removeSensor(this.partitionLoadSensor.name());
        this.metrics.removeSensor(this.threadIdleRatioSensor.name());
    }

    @Override
    public void recordPartitionStateChange(CoordinatorRuntime.CoordinatorState oldState, CoordinatorRuntime.CoordinatorState newState) {
        switch (oldState) {
            case INITIAL: 
            case CLOSED: {
                break;
            }
            case LOADING: {
                this.numPartitionsLoadingCounter.decrementAndGet();
                break;
            }
            case ACTIVE: {
                this.numPartitionsActiveCounter.decrementAndGet();
                break;
            }
            case FAILED: {
                this.numPartitionsFailedCounter.decrementAndGet();
            }
        }
        switch (newState) {
            case INITIAL: 
            case CLOSED: {
                break;
            }
            case LOADING: {
                this.numPartitionsLoadingCounter.incrementAndGet();
                break;
            }
            case ACTIVE: {
                this.numPartitionsActiveCounter.incrementAndGet();
                break;
            }
            case FAILED: {
                this.numPartitionsFailedCounter.incrementAndGet();
            }
        }
    }

    @Override
    public void recordPartitionLoadSensor(long startTimeMs, long endTimeMs) {
        this.partitionLoadSensor.record((double)(endTimeMs - startTimeMs), endTimeMs, false);
    }

    @Override
    public void recordEventQueueTime(long durationMs) {
        this.eventQueueTimeUpdater.accept(durationMs);
    }

    @Override
    public void recordEventQueueProcessingTime(long durationMs) {
        this.eventQueueProcessingTimeUpdater.accept(durationMs);
    }

    @Override
    public void recordThreadIdleRatio(double ratio) {
        this.threadIdleRatioSensor.record(ratio);
    }

    @Override
    public void registerEventQueueSizeGauge(Supplier<Integer> sizeSupplier) {
        this.metrics.addMetric(this.eventQueueSize, (MetricValueProvider)((Gauge)(config, now) -> (long)((Integer)sizeSupplier.get())));
    }
}

