/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.cloud.rbac;

import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.Scope;
import java.time.LocalDateTime;
import java.util.Comparator;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class CloudRoleBinding
implements Comparable<CloudRoleBinding> {
    private final String resourceId;
    private final KafkaPrincipal principal;
    private final String role;
    private final Scope scope;
    private final ResourcePattern resourcePattern;
    private final LocalDateTime created;
    private final LocalDateTime modified;
    private final boolean deleted;
    private final long lastChangeId;
    private static final Comparator<CloudRoleBinding> comparator = Comparator.comparing(CloudRoleBinding::getCreated).thenComparing(rb -> rb.resourceId).thenComparing(rb -> rb.principal.toString()).thenComparing(rb -> rb.role).thenComparing(rb -> rb.scope.toString()).thenComparing(rb -> rb.resourcePattern).thenComparing(rb -> rb.modified).thenComparing(rb -> rb.deleted).thenComparing(rb -> rb.lastChangeId);

    public CloudRoleBinding(String resourceId, KafkaPrincipal principal, String role, Scope scope, ResourcePattern resource, LocalDateTime created, LocalDateTime modified, boolean deleted, long lastChangeId) {
        this.resourceId = resourceId;
        this.principal = principal;
        this.role = role;
        this.scope = scope;
        this.resourcePattern = resource;
        this.created = created;
        this.modified = modified;
        this.deleted = deleted;
        this.lastChangeId = lastChangeId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public KafkaPrincipal getPrincipal() {
        return this.principal;
    }

    public String getRole() {
        return this.role;
    }

    public Scope getScope() {
        return this.scope;
    }

    public ResourcePattern getResourcePattern() {
        return this.resourcePattern;
    }

    public LocalDateTime getCreated() {
        return this.created;
    }

    public LocalDateTime getModified() {
        return this.modified;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public long getLastChangeId() {
        return this.lastChangeId;
    }

    @Override
    public int compareTo(CloudRoleBinding rb) {
        return comparator.compare(this, rb);
    }
}

