/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.app;

import io.confluent.rest.RestConfig;
import java.util.Map;
import java.util.TreeMap;
import org.apache.kafka.common.config.ConfigDef;

public class RbacApiAppConfig
extends RestConfig {
    private static ConfigDef config;
    public static final String CONFIG_PREFIX = "confluent.metadata.server.";
    public static final int MDS_PORT_DEFAULT = 8090;
    public static final String MDS_LISTENERS_DEFAULT = "http://0.0.0.0:8090";
    public static final String MDS_USER_STORE_CONFIG = "user.store";
    public static final String MDS_USER_STORE_LDAP = "LDAP";
    public static final String MDS_USER_STORE_FILE = "FILE";
    public static final String MDS_USER_STORE_OAUTH = "OAUTH";
    public static final String MDS_USER_STORE_LDAP_WITH_OAUTH = "LDAP_WITH_OAUTH";
    public static final String MDS_USER_STORE_NONE = "NONE";
    public static final ConfigDef.ValidString MDS_USER_STORE_VALIDATOR;
    public static final String MDS_USER_STORE_DOC = "What MDS should authenticate users against. Default is LDAP, which then expects Kafka Ldap settings to be configured.Other options include FILE, IDP and NONE. NONE implies that that only bearer auth is supported, without fallback to a user store to verify user credentials. IDP implies that a third-party auth server will be used for user authentication via OAuth. FILE validates user credentials against a local file using Jetty's HashLoginService. FILE should NOT be used in a production environment. Note that choice of user store only matters as long as 'authentication.method' is not NONE.";
    public static final String FILE_LOGIN_PATH_PROP = "user.store.file.path";
    public static final String FILE_LOGIN_PROP_PATH_DOC = "Property file containing user credentials in Jetty HashLoginService style. Only used if user.store is FILE. ";
    public static final String MDS_OPENAPI_ENABLE_CONFIG = "openapi.enable";
    public static final String MDS_OPENAPI_ENABLE_DOC = "Enables the OpenApi UI to be run on this MDS node.  Allows clients to be able to see and interact with the Api for learning and development purposes.Should not be run in production.";
    public static final String MDS_API_FLAVOR_PROP = "api.flavor";
    public static final String MDS_API_FLAVOR_DOC = "Which flavor of the MDS API should be run.";
    public static final String CLUSTER_REGISTRY_MDS_PROP = "cluster.registry.clusters";
    public static final String SSO_MODE = "sso.mode";
    public static final String SSO_MODE_DOC = "The support for user login using an identity provider is not enabled by default, and this optional setting tells the mode for SSO like OIDC or SAML.";
    public static final String OAUTHBEARER_JWKS_ENDPOINT_URL = "oauthbearer.jwks.endpoint.url";
    public static final String OAUTHBEARER_JWKS_ENDPOINT_URL_DOC = "The OAuth/OIDC provider URL from which the provider's <a href=\"https://datatracker.ietf.org/doc/html/rfc7517#section-5\">JWKS (JSON Web Key Set)</a> can be retrieved. The URL can be HTTP(S)-based. The fetched keys, will be cached on for incoming requests. If an authentication request is received for a JWT that includes a \"kid\" header claim value that isn't yet in the cache, the JWKS endpoint will be queried again on demand.";
    public static final String OAUTHBEARER_EXPECTED_ISSUER = "oauthbearer.expected.issuer";
    public static final String OAUTHBEARER_EXPECTED_ISSUER_DOC = "This is required by MDS to verify that the JWT was created by the expected issuer. The JWT will be inspected for the standard OAuth \"iss\" claim and if this value is set, MDS will match it exactly against what is in the JWT's \"iss\" claim. If there's no match, the broker will reject the JWT and authentication will fail.";
    public static final String OAUTHBEARER_EXPECTED_AUDIENCE = "oauthbearer.expected.audience";
    public static final String OAUTHBEARER_EXPECTED_AUDIENCE_DOC = "The (optional) comma-delimited setting for MDS to use to verify that the JWT was issued for one of the expected audiences. The JWT will be inspected for the standard OAuth \"aud\" claim and if this value is set, the broker will match the value from JWT's \"aud\" claim to see if there is an exact match. If there is no match, the broker will reject the JWT and authentication will fail.";
    public static final String OAUTHBEARER_SUB_CLAIM_NAME = "oauthbearer.sub.claim.name";
    public static final String OAUTHBEARER_SUB_CLAIM_NAME_DOC = "The OAuth claim for the subject is often named `sub` but this is optional. This optional setting can provide a different name to use for the subject included in the JWT payload's claims if the OAuth/OIDC provider uses a different name for sub claim.";
    public static final String OAUTHBEARER_GROUPS_CLAIM_NAME = "oauthbearer.groups.claim.name";
    public static final String OAUTHBEARER_GROUPS_CLAIM_NAME_DOC = "This optional setting provides the name of claim to use for the groups in the JWT payload. If setting is not provided, groups of principal will be empty.";

    public static ConfigDef baseConfigDef() {
        return RbacApiAppConfig.baseConfigDef((int)8090, (String)"").define(MDS_USER_STORE_CONFIG, ConfigDef.Type.STRING, (Object)MDS_USER_STORE_LDAP, (ConfigDef.Validator)MDS_USER_STORE_VALIDATOR, ConfigDef.Importance.LOW, MDS_USER_STORE_DOC).define(FILE_LOGIN_PATH_PROP, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, FILE_LOGIN_PROP_PATH_DOC).define(MDS_OPENAPI_ENABLE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, MDS_OPENAPI_ENABLE_DOC).define(CLUSTER_REGISTRY_MDS_PROP, ConfigDef.Type.STRING, (Object)"[]", ConfigDef.Importance.LOW, "JSON defining initial state of Cluster Registry. This should not be set manually, instead Cluster Registry http apis should be used.").define(SSO_MODE, ConfigDef.Type.STRING, (Object)"none", ConfigDef.Importance.LOW, SSO_MODE_DOC).define(OAUTHBEARER_JWKS_ENDPOINT_URL, ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, OAUTHBEARER_JWKS_ENDPOINT_URL_DOC).define(OAUTHBEARER_EXPECTED_ISSUER, ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, OAUTHBEARER_EXPECTED_ISSUER_DOC).define(OAUTHBEARER_EXPECTED_AUDIENCE, ConfigDef.Type.LIST, null, ConfigDef.Importance.HIGH, OAUTHBEARER_EXPECTED_AUDIENCE_DOC).define(OAUTHBEARER_SUB_CLAIM_NAME, ConfigDef.Type.STRING, (Object)"sub", ConfigDef.Importance.LOW, OAUTHBEARER_SUB_CLAIM_NAME_DOC).define(OAUTHBEARER_GROUPS_CLAIM_NAME, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, OAUTHBEARER_GROUPS_CLAIM_NAME_DOC);
    }

    public RbacApiAppConfig() {
        super(config);
    }

    public RbacApiAppConfig(Map<?, ?> props) {
        super(config, props);
    }

    public RbacApiAppConfig(ConfigDef definition) {
        super(definition, new TreeMap());
    }

    public RbacApiAppConfig(ConfigDef definition, Map<?, ?> props) {
        super(definition, props);
    }

    public static ConfigDef getConfigDef() {
        return config;
    }

    static {
        MDS_USER_STORE_VALIDATOR = ConfigDef.ValidString.in((String[])new String[]{MDS_USER_STORE_LDAP, MDS_USER_STORE_FILE, MDS_USER_STORE_OAUTH, MDS_USER_STORE_LDAP_WITH_OAUTH, MDS_USER_STORE_NONE});
        config = RbacApiAppConfig.baseConfigDef();
    }
}

