/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.comparators;

import io.confluent.security.authorizer.ResourcePattern;
import java.util.Comparator;
import org.apache.kafka.common.resource.PatternType;

public class MdsResourcePatternComparator
implements Comparator<ResourcePattern> {
    private static final MdsResourcePatternComparator instance = new MdsResourcePatternComparator();

    public static MdsResourcePatternComparator getInstance() {
        return instance;
    }

    @Override
    public int compare(ResourcePattern o1, ResourcePattern o2) {
        int result = o1.resourceType().name().compareTo(o2.resourceType().name());
        if (result != 0) {
            return result;
        }
        if (o1.patternType() == PatternType.PREFIXED && o2.patternType() == PatternType.LITERAL) {
            return -1;
        }
        if (o1.patternType() == PatternType.LITERAL && o2.patternType() == PatternType.PREFIXED) {
            return 1;
        }
        int patternResult = o1.patternType().compareTo((Enum)o2.patternType());
        if (patternResult != 0) {
            return patternResult;
        }
        return o1.name().compareTo(o2.name());
    }
}

