/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.resources.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.rbacapi.authorizer.SecurityMetadataAuthorizer;
import io.confluent.rbacapi.comparators.MdsResourcePatternComparator;
import io.confluent.rbacapi.converters.MdsScopeConverter;
import io.confluent.rbacapi.entities.MdsScope;
import io.confluent.rbacapi.entities.ResourcesRequest;
import io.confluent.rbacapi.utils.RoleUtilsBase;
import io.confluent.rbacapi.validation.base.ValidationUtil;
import io.confluent.security.auth.metadata.AuthCache;
import io.confluent.security.auth.metadata.AuthStore;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.rbac.InvalidRoleBindingException;
import io.confluent.security.rbac.Role;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrincipalsResource {
    private static final Logger log = LoggerFactory.getLogger(PrincipalsResource.class);
    private final AuthStore authStore;
    private final AuthCache authCache;
    private final SecurityMetadataAuthorizer metadataAuthorizer;
    private final Set<String> resourceRoles;
    private final MdsScopeConverter mdsScopeConverter;
    private final long backendTimeoutNanos;
    private final ValidationUtil validationUtil;
    private final ObjectMapper objectMapper;
    private final RoleUtilsBase roleUtils;

    public PrincipalsResource(AuthStore authStore, SecurityMetadataAuthorizer metadataAuthorizer, long backendTimeoutNanos, ValidationUtil validationUtil, ObjectMapper objectMapper, RoleUtilsBase roleUtils, MdsScopeConverter mdsScopeConverter) {
        this.authStore = authStore;
        this.authCache = authStore.authCache();
        this.metadataAuthorizer = metadataAuthorizer;
        this.backendTimeoutNanos = backendTimeoutNanos;
        this.validationUtil = validationUtil;
        this.mdsScopeConverter = mdsScopeConverter;
        this.objectMapper = objectMapper;
        this.roleUtils = roleUtils;
        this.resourceRoles = this.authCache.rbacRoles().roles().stream().filter(Role::bindWithResource).map(Role::name).collect(Collectors.toSet());
    }

    public void addClusterRoleForPrincipal(SecurityContext context, String principalStr, String roleName, MdsScope mdsScope) throws InterruptedException, ExecutionException, TimeoutException {
        KafkaPrincipal callingPrincipal = this.metadataAuthorizer.userPrincipal(context);
        Scope scope = this.mdsScopeConverter.getScope(mdsScope, callingPrincipal);
        this.metadataAuthorizer.authorizeSecurityMetadataAccess(context, scope, SecurityMetadataAuthorizer.ALTER);
        String resolvedRoleName = this.getNamedRoleAtScope(roleName, scope).name();
        KafkaPrincipal targetPrincipal = SecurityUtils.parseKafkaPrincipal((String)principalStr);
        CompletionStage cs = this.authStore.writer().addClusterRoleBinding(Optional.of(callingPrincipal), targetPrincipal, resolvedRoleName, scope, null);
        cs.toCompletableFuture().get(this.backendTimeoutNanos, TimeUnit.NANOSECONDS);
    }

    public void deleteRoleForPrincipal(SecurityContext context, String principalStr, String roleName, MdsScope mdsScope) throws InterruptedException, ExecutionException, TimeoutException {
        KafkaPrincipal callingPrincipal = this.metadataAuthorizer.userPrincipal(context);
        Scope scope = this.mdsScopeConverter.getScope(mdsScope, callingPrincipal);
        this.metadataAuthorizer.authorizeSecurityMetadataAccess(context, scope, SecurityMetadataAuthorizer.ALTER);
        String resolvedRoleName = this.getNamedRoleAtScope(roleName, scope).name();
        KafkaPrincipal targetPrincipal = SecurityUtils.parseKafkaPrincipal((String)principalStr);
        CompletionStage cs = this.authStore.writer().removeRoleBinding(Optional.of(callingPrincipal), targetPrincipal, resolvedRoleName, scope, null);
        cs.toCompletableFuture().get(this.backendTimeoutNanos, TimeUnit.NANOSECONDS);
    }

    public List<ResourcePattern> getRoleResourcesForPrincipal(SecurityContext context, String principalStr, String roleName, MdsScope mdsScope) {
        KafkaPrincipal callingPrincipal = this.metadataAuthorizer.userPrincipal(context);
        Scope scope = this.mdsScopeConverter.getScope(mdsScope, callingPrincipal);
        this.metadataAuthorizer.authorizeSecurityMetadataAccess(context, scope, SecurityMetadataAuthorizer.DESCRIBE);
        String resolvedRoleName = this.getNamedRoleAtScope(roleName, scope).name();
        KafkaPrincipal targetPrincipal = SecurityUtils.parseKafkaPrincipal((String)principalStr);
        List<ResourcePattern> resources = this.authCache.rbacRoleBindings(scope).stream().filter(rb -> StringUtils.equals((CharSequence)resolvedRoleName, (CharSequence)rb.role())).filter(rb -> targetPrincipal.equals((Object)rb.principal())).flatMap(rb -> rb.resources().stream()).sorted(MdsResourcePatternComparator.getInstance()).collect(Collectors.toList());
        return resources;
    }

    public void addRoleResourcesForPrincipal(SecurityContext context, String principalStr, String roleName, ResourcesRequest resourcesRequest) throws InterruptedException, ExecutionException, TimeoutException {
        KafkaPrincipal callingPrincipal = this.metadataAuthorizer.userPrincipal(context);
        if (resourcesRequest == null) {
            throw new ClientErrorException("Adding a rolebinding for a resource role requires a Request body", 400);
        }
        if (resourcesRequest.resourcePatterns == null) {
            throw new ClientErrorException("Adding a rolebinding for a resource role requires a Resource Request body", 400);
        }
        Scope scope = this.mdsScopeConverter.getScope(resourcesRequest.mdsScope, callingPrincipal);
        this.metadataAuthorizer.authorizeResourceAccess(context, scope, resourcesRequest.resourcePatterns, SecurityMetadataAuthorizer.ALTER_ACCESS);
        ResourcesRequest scopedResourcesRequest = new ResourcesRequest(new MdsScope(scope), resourcesRequest.resourcePatterns);
        this.validationUtil.verifyResourceType(scopedResourcesRequest);
        String resolvedRoleName = this.roleUtils.getNamedRoleByResourceType(this.authCache.rbacRoles().roles(), roleName, scope, resourcesRequest.resourcePatterns).name();
        this.validateRoleBindingScope(resolvedRoleName, scope);
        this.validationUtil.verifyScope(scopedResourcesRequest);
        this.verifyResourceScopedRole(resolvedRoleName);
        this.validationUtil.verifyPatternType(scopedResourcesRequest);
        this.validationUtil.verifyRoleResourceType(resolvedRoleName, scopedResourcesRequest);
        this.validationUtil.verifyScopeResourceType(scopedResourcesRequest);
        this.validationUtil.verifyResourcePattern(scopedResourcesRequest);
        KafkaPrincipal targetPrincipal = SecurityUtils.parseKafkaPrincipal((String)principalStr);
        CompletionStage cs = this.authStore.writer().addResourceRoleBinding(Optional.of(callingPrincipal), targetPrincipal, resolvedRoleName, scope, scopedResourcesRequest.resourcePatterns, null);
        cs.toCompletableFuture().get(this.backendTimeoutNanos, TimeUnit.NANOSECONDS);
    }

    public void deleteRoleResourcesForPrincipal(SecurityContext context, String principalStr, String roleName, ResourcesRequest resourcesRequest) throws InterruptedException, ExecutionException, TimeoutException {
        KafkaPrincipal callingPrincipal = this.metadataAuthorizer.userPrincipal(context);
        if (resourcesRequest == null) {
            throw new ClientErrorException("Removing a rolebinding for a resource role requires a Request body", 400);
        }
        if (resourcesRequest.resourcePatterns == null) {
            throw new ClientErrorException("Removing a rolebinding for a resource role requires a Resource Request body", 400);
        }
        Scope scope = this.mdsScopeConverter.getScope(resourcesRequest.mdsScope, callingPrincipal);
        this.metadataAuthorizer.authorizeResourceAccess(context, scope, resourcesRequest.resourcePatterns, SecurityMetadataAuthorizer.ALTER_ACCESS);
        ResourcesRequest scopedResourcesRequest = new ResourcesRequest(new MdsScope(scope), resourcesRequest.resourcePatterns);
        this.validationUtil.verifyResourceType(scopedResourcesRequest);
        String resolvedRoleName = this.roleUtils.getNamedRoleByResourceType(this.authCache.rbacRoles().roles(), roleName, scope, resourcesRequest.resourcePatterns).name();
        this.validateRoleBindingScope(resolvedRoleName, scope);
        this.validationUtil.verifyScope(scopedResourcesRequest);
        this.verifyResourceScopedRole(resolvedRoleName);
        this.validationUtil.verifyPatternType(scopedResourcesRequest);
        this.validationUtil.verifyRoleResourceType(resolvedRoleName, scopedResourcesRequest);
        this.validationUtil.verifyScopeResourceType(scopedResourcesRequest);
        this.validationUtil.verifyResourcePattern(scopedResourcesRequest);
        KafkaPrincipal targetPrincipal = SecurityUtils.parseKafkaPrincipal((String)principalStr);
        List resourcePatternFilters = scopedResourcesRequest.resourcePatterns.stream().map(ResourcePattern::toFilter).collect(Collectors.toList());
        CompletionStage cs = this.authStore.writer().removeResourceRoleBinding(Optional.of(callingPrincipal), targetPrincipal, resolvedRoleName, scope, resourcePatternFilters, null);
        cs.toCompletableFuture().get(this.backendTimeoutNanos, TimeUnit.NANOSECONDS);
    }

    public void setRoleResourcesForPrincipal(SecurityContext context, String principalStr, String roleName, ResourcesRequest resourcesRequest) throws InterruptedException, ExecutionException, TimeoutException {
        KafkaPrincipal callingPrincipal = this.metadataAuthorizer.userPrincipal(context);
        if (resourcesRequest == null) {
            throw new ClientErrorException("Overwriting rolebindings for a resource role requires a Request body", 400);
        }
        if (resourcesRequest.resourcePatterns == null) {
            throw new ClientErrorException("Overwriting rolebindings for a resource role requires a Resource Request body", 400);
        }
        Scope scope = this.mdsScopeConverter.getScope(resourcesRequest.mdsScope, callingPrincipal);
        this.metadataAuthorizer.authorizeResourceAccess(context, scope, resourcesRequest.resourcePatterns, SecurityMetadataAuthorizer.ALTER_ACCESS);
        ResourcesRequest scopedResourcesRequest = new ResourcesRequest(new MdsScope(scope), resourcesRequest.resourcePatterns);
        this.validationUtil.verifyResourceType(scopedResourcesRequest);
        String resolvedRoleName = this.roleUtils.getNamedRoleByResourceType(this.authCache.rbacRoles().roles(), roleName, scope, resourcesRequest.resourcePatterns).name();
        this.validateRoleBindingScope(resolvedRoleName, scope);
        this.validationUtil.verifyScope(scopedResourcesRequest);
        this.verifyResourceScopedRole(resolvedRoleName);
        this.validationUtil.verifyPatternType(scopedResourcesRequest);
        this.validationUtil.verifyRoleResourceType(resolvedRoleName, scopedResourcesRequest);
        this.validationUtil.verifyScopeResourceType(scopedResourcesRequest);
        this.validationUtil.verifyResourcePattern(scopedResourcesRequest);
        KafkaPrincipal targetPrincipal = SecurityUtils.parseKafkaPrincipal((String)principalStr);
        CompletionStage cs = this.authStore.writer().replaceResourceRoleBinding(Optional.of(callingPrincipal), targetPrincipal, resolvedRoleName, scope, resourcesRequest.resourcePatterns, null);
        cs.toCompletableFuture().get(this.backendTimeoutNanos, TimeUnit.NANOSECONDS);
    }

    private void verifyResourceScopedRole(String roleName) {
        if (!this.resourceRoles.contains(roleName)) {
            throw new ClientErrorException("Cannot grant resource role bindings to a cluster scoped role.", 400);
        }
    }

    private Role getNamedRoleAtScope(String roleName, Scope scope) {
        Role role = this.roleUtils.resolveRoleByDisplayName(this.authCache.rbacRoles().roles(), roleName, scope);
        if (role == null) {
            throw new ClientErrorException(String.format("No role %s at scope %s", roleName, scope), 400);
        }
        return role;
    }

    private void validateRoleBindingScope(String roleName, Scope bindingScope) {
        Role roleDefinition = this.authStore.authCache().rbacRoles().role(roleName);
        if (roleDefinition == null) {
            throw new InvalidRoleBindingException("Role not found " + roleName);
        }
        this.validationUtil.validateRoleBindingScope(roleDefinition, bindingScope);
    }
}

