/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rbacapi.validation.v1;

import com.google.common.collect.ImmutableSet;
import io.confluent.security.authorizer.Scope;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.apache.commons.lang3.StringUtils;

@Target(value={ElementType.PARAMETER, ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
@Constraint(validatedBy={ScopeValidator.class})
public @interface V1ValidScope {
    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public String message() default "Invalid Scope";

    public static class ScopeValidator
    implements ConstraintValidator<V1ValidScope, Scope> {
        private static final String KAFKA_CLUSTER = "kafka-cluster";
        private static final Set<String> validClusterKeys = ImmutableSet.of((Object)"kafka-cluster", (Object)"connect-cluster", (Object)"ksql-cluster", (Object)"schema-registry-cluster");

        public void initialize(V1ValidScope constraintAnnotation) {
        }

        public boolean isValid(Scope scope, ConstraintValidatorContext context) {
            context.disableDefaultConstraintViolation();
            if (scope == null) {
                context.buildConstraintViolationWithTemplate("Invalid Scope : scope should be included in the request body").addConstraintViolation();
                return false;
            }
            if (scope.path() != null && !scope.path().isEmpty()) {
                context.buildConstraintViolationWithTemplate("Invalid Scope : path should be empty").addConstraintViolation();
                return false;
            }
            if (scope.clusters() == null || scope.clusters().size() == 0 || scope.clusters().size() > 2) {
                context.buildConstraintViolationWithTemplate("Invalid Scope : clusters should only contain one or two cluster id keys").addConstraintViolation();
                return false;
            }
            if (!scope.clusters().keySet().contains(KAFKA_CLUSTER)) {
                context.buildConstraintViolationWithTemplate("Invalid Scope : kafka-cluster should always be defined").addConstraintViolation();
                return false;
            }
            if (scope.clusters().keySet().stream().anyMatch(key -> !validClusterKeys.contains(key))) {
                context.buildConstraintViolationWithTemplate("Invalid Scope : invalid cluster key found").addConstraintViolation();
                return false;
            }
            if (scope.clusters().values().stream().anyMatch(StringUtils::isBlank)) {
                context.buildConstraintViolationWithTemplate("Invalid Scope : cluster value cannot be blank").addConstraintViolation();
                return false;
            }
            return true;
        }
    }
}

