/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.tokenapi.jwt;

import io.confluent.tokenapi.jwt.JwtConfig;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;

public class JwsConfig
extends JwtConfig {
    private static ConfigDef config;
    public static final String TOKEN_KEY_PATH_PROP = "token.key.path";
    public static final String TOKEN_KEY_PATH_DOC = "Location of a PEM encoded key pair or a public key. The keypair can be used for signing and verifying tokens. When userstores are disabled, the public key can be used to verify tokens generated using other mechanisms. Since the token service only supports RS256 signatures  key pairs must be generated using the RSA algorithm.";
    public static final String TOKEN_KEY_PASSPHRASE_PROP = "token.key.passphrase";
    public static final String TOKEN_KEY_PASSPHRASE_PROP_DEFAULT = "";
    public static final String TOKEN_KEY_PASSPHRASE_DOC = "Passphrase for the key pair. If not specified or is an empty string, the key is assumed to be unencrypted. This means that specifying an empty string as a password is not supported.";
    public static final String SIGNATURE_ALGORITHM_PROP = "token.signature.algorithm";
    private static final String SIGNATURE_ALGORITHM_DEFAULT = "RS256";
    private static final ConfigDef.ValidString SIGNATURE_ALGORITHM_VALIDATOR;
    private static final String SIGNATURE_ALGORITHM_DOC = "Signature scheme to be used when signing/verifying tokens as defined in https://tools.ietf.org/html/rfc7518#section-3.1. Currently only RS256 is supported.";

    public static ConfigDef baseConfigDef() {
        return JwtConfig.baseConfigDef().define(TOKEN_KEY_PATH_PROP, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, TOKEN_KEY_PATH_DOC).define(TOKEN_KEY_PASSPHRASE_PROP, ConfigDef.Type.PASSWORD, (Object)TOKEN_KEY_PASSPHRASE_PROP_DEFAULT, ConfigDef.Importance.HIGH, TOKEN_KEY_PASSPHRASE_DOC).define(SIGNATURE_ALGORITHM_PROP, ConfigDef.Type.STRING, (Object)SIGNATURE_ALGORITHM_DEFAULT, (ConfigDef.Validator)SIGNATURE_ALGORITHM_VALIDATOR, ConfigDef.Importance.LOW, SIGNATURE_ALGORITHM_DOC);
    }

    public JwsConfig() {
        super(config);
    }

    public JwsConfig(Map<?, ?> props) {
        super(config, props);
    }

    static {
        SIGNATURE_ALGORITHM_VALIDATOR = ConfigDef.ValidString.in((String[])new String[]{SIGNATURE_ALGORITHM_DEFAULT});
        config = JwsConfig.baseConfigDef();
    }
}

