/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.security.context;

import io.confluent.kafkarest.DefaultKafkaRestContext;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.KafkaRestContext;
import io.confluent.kafkarest.security.config.ConfluentSecureKafkaRestConfig;
import io.confluent.kafkarest.security.config.SecureConfigProviderFactory;
import io.confluent.kafkarest.security.context.CachingKafkaRestContext;
import io.confluent.rest.exceptions.RestNotAuthorizedException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;

public class KafkaRestContextProviderFactory {
    private static final KafkaRestContextProviderFactory instance = new KafkaRestContextProviderFactory();
    private final Map<String, KafkaRestContext> userToContextMap = new HashMap<String, KafkaRestContext>();

    private KafkaRestContextProviderFactory() {
    }

    public static KafkaRestContextProviderFactory getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KafkaRestContext getContext(Principal principal, ConfluentSecureKafkaRestConfig kafkaRestConfig, String resourceType, boolean tokenAuth) {
        KafkaRestContext cachedContext = this.userToContextMap.get(principal.getName());
        if (cachedContext != null) {
            return this.updateContextConfigs(principal, cachedContext, kafkaRestConfig);
        }
        String string = principal.getName().intern();
        synchronized (string) {
            if (!this.userToContextMap.containsKey(principal.getName())) {
                if (!tokenAuth && !SecureConfigProviderFactory.getInstance().getSecureConfigProvider(kafkaRestConfig).isPrincipalAvailable(principal, kafkaRestConfig, resourceType)) {
                    throw new RestNotAuthorizedException("Principal not found", 401);
                }
                CachingKafkaRestContext context = new CachingKafkaRestContext((KafkaRestContext)new DefaultKafkaRestContext((KafkaRestConfig)kafkaRestConfig));
                this.userToContextMap.put(principal.getName(), context);
                return context;
            }
            cachedContext = this.userToContextMap.get(principal.getName());
            return this.updateContextConfigs(principal, cachedContext, kafkaRestConfig);
        }
    }

    private KafkaRestContext updateContextConfigs(Principal principal, KafkaRestContext cachedContext, ConfluentSecureKafkaRestConfig newRestConfig) {
        ConfluentSecureKafkaRestConfig existingRestConfig = (ConfluentSecureKafkaRestConfig)cachedContext.getConfig();
        existingRestConfig.jwtToken(newRestConfig.jwtToken());
        return cachedContext;
    }

    public void clean() {
        for (KafkaRestContext context : this.userToContextMap.values()) {
            context.shutdown();
        }
        this.userToContextMap.clear();
    }
}

