/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.link.integration;

import io.confluent.kafka.link.integration.ClusterLinkTestUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import kafka.link.ClusterLinkAutoMirroringIntegrationTest;
import kafka.server.KafkaBroker;
import kafka.server.link.ClusterLinkConfig;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Option;
import scala.collection.Map;
import scala.collection.Seq;

@Tag(value="integration")
public class ClusterLinkPrefixAutoMirroringIntegrationTest
extends ClusterLinkAutoMirroringIntegrationTest {
    Long syncPeriod = 100L;

    public ClusterLinkPrefixAutoMirroringIntegrationTest() {
        this.clusterLinkPrefix_$eq("src_");
    }

    @Disabled
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testAutoMirroringTaskStateManagementVariousScenarios(String quorum, boolean coordinator) {
    }

    @Disabled
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testAutoMirroringNoOverlappingTopicFilters(String quorum, boolean coordinator) {
    }

    @Disabled
    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testAutoMirroringAllowsLinkConfigUpdate(String quorum, boolean coordinator) {
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testAutoMirroringFiltersOutMirrorTopicsAndMetrics(String quorum, boolean coordinator) throws InterruptedException {
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), (int)this.replicationFactor(), new Properties(), this.sourceCluster().listenerName(), this.sourceCluster().adminClientConfig());
        this.produceToSourceCluster(20);
        Properties linkProps = this.destLinkPropsForAutoMirroring(this.includeAllTopicsFilter(), true);
        linkProps.setProperty(ClusterLinkConfig.RetryTimeoutMsProp(), String.valueOf(this.syncPeriod * 10L));
        Uuid linkId = this.createClusterLink(this.linkName(), linkProps, this.sourceLinkProps((Map)ClusterLinkTestUtils.convertMapToScalaMap(Collections.emptyMap())), false, true);
        this.waitForAutoMirrorCreation(this.clusterLinkPrefix() + this.topic());
        this.waitForMirror((Seq)this.destCluster().brokers().toSeq(), 15000L);
        this.verifyBasicLinkMetrics(linkId, new Properties(), false);
        this.verifyAutoMirroringSuccessMetric();
        Thread.sleep(this.syncPeriod * 5L);
        Assertions.assertEquals((double)0.0, (double)this.totalKafkaMetricValue(this.destCluster().aliveServers(), "auto-mirror-create-failed-total", (Map)ClusterLinkTestUtils.convertMapToScalaMap(Collections.emptyMap()), false, this.linkName()));
        Assertions.assertEquals((double)1.0, (double)this.totalKafkaMetricValue(this.destCluster().aliveServers(), "auto-mirror-created-total", (Map)ClusterLinkTestUtils.convertMapToScalaMap(Collections.emptyMap()), false, this.linkName()));
        String destMirrorTopic = this.clusterLinkPrefix() + this.topic();
        Assertions.assertTrue((boolean)this.destCluster().listMirrorTopics(false).contains((Object)destMirrorTopic));
        String destClusterId = ((KafkaBroker)this.destCluster().brokers().head()).clusterId();
        String destRegularTopic = "destRegularTopic";
        this.destCluster().createTopic(destRegularTopic, this.numPartitions(), (int)this.replicationFactor(), new Properties(), this.destCluster().listenerName(), this.destCluster().adminClientConfig());
        String sourceLinkName = "sourceLink";
        Properties sourceProps = new Properties();
        sourceProps.put(ClusterLinkConfig.AutoMirroringEnableProp(), "true");
        sourceProps.setProperty(ClusterLinkConfig.RetryTimeoutMsProp(), String.valueOf(this.syncPeriod * 10L));
        sourceProps.put(ClusterLinkConfig.TopicFiltersProp(), this.includeAllTopicsFilter());
        String sourcePrefix = "prefixTwo";
        sourceProps.put(ClusterLinkConfig.ClusterLinkPrefixProp(), sourcePrefix);
        sourceProps.put("bootstrap.servers", this.destCluster().bootstrapServers(this.destCluster().listenerName()));
        sourceProps.put("metadata.max.age.ms", String.valueOf(this.syncPeriod));
        String linkJaasConfig = this.createLinkCredentials(sourceLinkName, this.destCluster(), Option.empty());
        sourceProps.putAll((java.util.Map<?, ?>)this.destCluster().clientSecurityProps(sourceLinkName));
        sourceProps.put("sasl.jaas.config", linkJaasConfig);
        this.sourceCluster().createClusterLinkWithAllOptions(sourceLinkName, sourceProps, Option.apply((Object)destClusterId), true, Option.empty(), true);
        TestUtils.waitForCondition(() -> this.sourceCluster().listMirrorTopics(false).contains((Object)(sourcePrefix + destRegularTopic)), (String)"Not mirrored");
        String sourceMirrorTopic = sourcePrefix + destRegularTopic;
        Assertions.assertTrue((boolean)this.sourceCluster().listMirrorTopics(false).contains((Object)sourceMirrorTopic));
        Thread.sleep(this.syncPeriod * 5L);
        Assertions.assertEquals((double)1.0, (double)this.totalKafkaMetricValue(this.sourceCluster().aliveServers(), "auto-mirror-created-total", (Map)ClusterLinkTestUtils.convertMapToScalaMap(Collections.emptyMap()), false, sourceLinkName));
        Assertions.assertEquals((double)1.0, (double)this.totalKafkaMetricValue(this.sourceCluster().aliveServers(), "prefixed-auto-mirror-topic-filtered-count", (Map)ClusterLinkTestUtils.convertMapToScalaMap(Collections.emptyMap()), false, sourceLinkName));
        Assertions.assertFalse((boolean)this.destCluster().listMirrorTopics(false).contains((Object)(this.clusterLinkPrefix() + sourceMirrorTopic)));
        Assertions.assertFalse((boolean)this.sourceCluster().listMirrorTopics(false).contains((Object)(sourcePrefix + destMirrorTopic)));
        HashMap<String, String> updatedProps = new HashMap<String, String>();
        updatedProps.put(ClusterLinkConfig.AutoMirroringEnableProp(), "false");
        this.destCluster().alterClusterLink(this.linkName(), ClusterLinkTestUtils.convertMapToScalaMap(updatedProps), (Seq)this.destCluster().brokers().toSeq(), ClusterLinkTestUtils.convertSetToScalaSet(Collections.EMPTY_SET), true);
        this.destCluster().unlinkTopic(destMirrorTopic, this.linkName(), true, true, true, this.numPartitions());
        this.destCluster().deleteTopic(destMirrorTopic, true);
        Thread.sleep(this.syncPeriod * 5L);
        Assertions.assertEquals((double)0.0, (double)this.totalKafkaMetricValue(this.sourceCluster().aliveServers(), "prefixed-auto-mirror-topic-filtered-count", (Map)ClusterLinkTestUtils.convertMapToScalaMap(Collections.emptyMap()), false, sourceLinkName));
        this.sourceCluster().unlinkTopic(sourceMirrorTopic, sourceLinkName, true, true, true, this.numPartitions());
        this.destCluster().deleteClusterLink(this.linkName(), true, (Seq)this.destCluster().brokers().toSeq());
        this.sourceCluster().deleteClusterLink(sourceLinkName, true, (Seq)this.sourceCluster().brokers().toSeq());
    }
}

