/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.oauth.mockserver.server;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.RSAKey;
import io.confluent.security.auth.oauth.mockserver.common.RSAKeyProvider;
import io.confluent.security.auth.oauth.mockserver.common.SupportedAlgorithms;
import io.confluent.security.auth.oauth.mockserver.server.AdminServerRequestHandler;
import io.confluent.security.auth.oauth.mockserver.server.AuthServerRequestHandler;
import io.confluent.security.auth.oauth.mockserver.server.CommonHttp;
import io.confluent.security.auth.oauth.mockserver.server.URLEndpoints;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.SelfSignedCertificate;
import io.vertx.core.net.TrustOptions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jose4j.json.internal.json_simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockOAuthServer
extends AbstractVerticle {
    private static final Logger log = LoggerFactory.getLogger(MockOAuthServer.class);
    public SelfSignedCertificate certificate = SelfSignedCertificate.create();
    public static Map<String, RSAKey> keys = new HashMap<String, RSAKey>();
    private final Map<String, String> clients = new HashMap<String, String>();
    HttpServer adminServer;
    HttpServer authServer;
    private static final int DEFAULT_ADMIN_SERVER_PORT = 63890;
    private static final int DEFAULT_AUTH_SERVER_PORT = 63891;
    public static int adminServerPort;
    public static int authServerPort;

    public void startServers() throws Exception {
        this.startServers(63891, 63890);
    }

    public void startServers(int authPort, int adminPort) throws Exception {
        adminServerPort = adminPort < 65000 ? adminPort : 63890;
        authServerPort = authPort < 65000 ? authPort : 63891;
        this.vertx = Vertx.vertx();
        this.vertx.deployVerticle((Verticle)new MockOAuthServer());
        this.adminServer = this.vertx.createHttpServer(new HttpServerOptions().setSsl(true).setKeyCertOptions((KeyCertOptions)this.certificate.keyCertOptions()).setTrustOptions((TrustOptions)this.certificate.trustOptions())).requestHandler((Handler)new AdminServerRequestHandler(this));
        this.adminServer.listen(adminServerPort);
        this.startAuthServer();
        this.getSigKey(SupportedAlgorithms.RS256, "Confluent");
    }

    protected void startAuthServer() {
        HttpServerOptions serverOptions = new HttpServerOptions().setSsl(true).setKeyCertOptions((KeyCertOptions)this.certificate.keyCertOptions()).setTrustOptions((TrustOptions)this.certificate.trustOptions());
        this.authServer = this.vertx.createHttpServer(serverOptions).requestHandler((Handler)new AuthServerRequestHandler(this));
        this.authServer.listen(authServerPort, "localhost");
    }

    public void stopServers() {
        this.authServer.close();
        this.adminServer.close();
    }

    synchronized RSAKey getSigKey(SupportedAlgorithms algorithms, String kid) throws Exception {
        if (keys.containsKey(kid) && keys.get(kid).getAlgorithm().equals((Object)algorithms.getAlgorithm())) {
            return keys.get(kid);
        }
        RSAKey key = (RSAKey)RSAKeyProvider.getRSAKey(algorithms, kid);
        keys.put(kid, key);
        return key;
    }

    public Map<String, JWK> getKeys() {
        HashMap<String, JWK> publicKeys = new HashMap<String, JWK>();
        keys.forEach((keyID, key) -> {
            JWK cfr_ignored_0 = (JWK)publicKeys.put((String)keyID, (JWK)new RSAKey.Builder(key.toPublicJWK()).build());
        });
        return publicKeys;
    }

    void createOrUpdateClient(String clientId, String secret) {
        this.clients.put(clientId, secret);
    }

    Map<String, String> getClients() {
        return Collections.unmodifiableMap(this.clients);
    }

    public static JSONObject getConfig() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"admin-server-port", (Object)adminServerPort);
        jsonObject.put((Object)"auth-server-port", (Object)authServerPort);
        jsonObject.put((Object)"token-url", (Object)URLEndpoints.getTokenURL(authServerPort));
        jsonObject.put((Object)"jwks-url", (Object)URLEndpoints.getJwksURL(authServerPort));
        return jsonObject;
    }

    public static void establishConnectionToServer() {
        try {
            CommonHttp.sendGET(URLEndpoints.getJwksURL(authServerPort));
        }
        catch (Exception e) {
            MockOAuthServer.establishConnectionToServer();
        }
    }
}

