/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.replication.push;

import io.confluent.kafka.replication.push.ReplicationState;
import java.util.Objects;

public class ReplicationStateMetadata
implements ReplicationState {
    public static final long UNKNOWN_REPLICATION_SESSION_ID = -1L;
    public static final long INITIAL_REPLICATION_SESSION_ID = 0L;
    public static final long FINAL_REPLICATION_SESSION_ID = Long.MAX_VALUE;
    public static final ReplicationStateMetadata INITIAL = new ReplicationStateMetadata(ReplicationState.Mode.PULL, -1L);
    private final ReplicationState.Mode replicationMode;
    private final long replicationSessionId;

    public ReplicationStateMetadata(ReplicationState.Mode replicationMode, long replicationSessionId) {
        this.replicationMode = replicationMode;
        this.replicationSessionId = replicationSessionId;
    }

    public static boolean isValidReplicationSessionId(long replicationSessionId) {
        return replicationSessionId >= 0L;
    }

    @Override
    public ReplicationState.Mode mode() {
        return this.replicationMode;
    }

    @Override
    public long replicationSessionId() {
        return this.replicationSessionId;
    }

    public ReplicationStateMetadata nextReplicationState(ReplicationState.Mode next, long proposedSessionId) {
        if (!this.canTransitionTo(next, proposedSessionId)) {
            throw new IllegalArgumentException(String.format("Invalid mode transition attempted from %s to %s with replication session ID %d", new Object[]{this.replicationMode, next, proposedSessionId}));
        }
        return new ReplicationStateMetadata(next, proposedSessionId);
    }

    public boolean canTransitionTo(ReplicationState.Mode next, long proposedSessionId) {
        if (this.replicationSessionId == Long.MAX_VALUE) {
            return false;
        }
        if (proposedSessionId == Long.MAX_VALUE && next != ReplicationState.Mode.PULL) {
            return false;
        }
        boolean isValidTransition = next.validPreviousModes().contains((Object)this.replicationMode);
        boolean isValidProposedSessionId = proposedSessionId >= this.nextId(next);
        return isValidTransition && isValidProposedSessionId;
    }

    public long nextId(ReplicationState.Mode nextMode) {
        if (nextMode == ReplicationState.Mode.PUSH) {
            return this.replicationSessionId;
        }
        return this.replicationSessionId + 1L;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.replicationMode, this.replicationSessionId});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationStateMetadata that = (ReplicationStateMetadata)o;
        return this.replicationMode == that.replicationMode && this.replicationSessionId == that.replicationSessionId;
    }

    public String toString() {
        return String.format("[ReplicationMode=%s, replicationSessionId=%d]", new Object[]{this.replicationMode, this.replicationSessionId});
    }
}

