/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.replication.push.buffer;

import io.confluent.kafka.replication.push.PushSession;
import io.confluent.kafka.replication.push.buffer.PushReplicationEvent;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.message.AppendRecordsRequestData;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MultiBufferRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BufferingPartitionDataBuilder {
    private static final Logger log = LoggerFactory.getLogger(BufferingPartitionDataBuilder.class);
    public static final long UNSET_OFFSET_VALUE = -1L;
    private final TopicIdPartition topicIdPartition;
    private final PushSession initialSession;
    private final long maxSizeInBytes;
    private final List<AbstractRecords> records;
    CompletableFuture<Void> startFuture;
    CompletableFuture<Void> stopFuture;
    private long appendOffset = -1L;
    private long highWatermark = -1L;
    private long logStartOffset = -1L;
    private long sizeInBytes = 0L;

    public BufferingPartitionDataBuilder(TopicIdPartition topicIdPartition, PushSession initialSession, long maxSizeInBytes) {
        this.topicIdPartition = topicIdPartition;
        this.initialSession = initialSession;
        this.maxSizeInBytes = maxSizeInBytes;
        this.records = new ArrayList<AbstractRecords>();
    }

    public TopicIdPartition topicIdPartition() {
        return this.topicIdPartition;
    }

    public boolean addTransitionRecords(PushReplicationEvent<PushReplicationEvent.TransitionRecordsPayload> transitionEvent, PushSession mostRecentSession) {
        if (!this.isInitialPushSession(mostRecentSession)) {
            return false;
        }
        if (this.startFuture != null || this.stopFuture != null || this.appendOffset != -1L || this.highWatermark != -1L || this.logStartOffset != -1L || this.sizeInBytes != 0L) {
            log.warn("BufferingPartitionDataBuilder expects at most one startPush replication event, and it expects it to be its first consumed event");
            return false;
        }
        PushReplicationEvent.TransitionRecordsPayload payload = transitionEvent.payload();
        this.startFuture = payload.startFuture();
        this.records.add(payload.records());
        this.sizeInBytes = payload.records().sizeInBytes();
        if (this.appendOffset == -1L) {
            this.appendOffset = payload.appendOffset();
        }
        this.highWatermark = Math.max(this.highWatermark, payload.highWatermark());
        return true;
    }

    public List<AbstractRecords> stopPushAndDiscardState(PushReplicationEvent<CompletableFuture<Void>> stopEvent) {
        if (this.stopFuture != null) {
            throw new IllegalStateException("BufferingPartitionDataBuilder expects at most one stopPush replication event");
        }
        this.stopFuture = stopEvent.payload();
        return this.discardState();
    }

    List<AbstractRecords> discardState() {
        ArrayList<AbstractRecords> evictedRecords = new ArrayList<AbstractRecords>(this.records);
        this.records.clear();
        this.appendOffset = -1L;
        this.highWatermark = -1L;
        this.logStartOffset = -1L;
        return evictedRecords;
    }

    public boolean addPartitionUpdate(PushReplicationEvent<?> pushReplicationEvent, PushSession mostRecentSession) {
        if (!this.isInitialPushSession(mostRecentSession)) {
            return false;
        }
        if (this.stopFuture != null) {
            return false;
        }
        switch (pushReplicationEvent.type()) {
            case HWM_UPDATE: {
                this.highWatermark = Math.max(this.highWatermark, ((PushReplicationEvent.OffsetPayload)pushReplicationEvent.payload()).offset());
                return true;
            }
            case LSO_UPDATE: {
                this.logStartOffset = Math.max(this.logStartOffset, ((PushReplicationEvent.OffsetPayload)pushReplicationEvent.payload()).offset());
                return true;
            }
            case MEMORY_RECORDS: {
                if (this.startFuture != null) {
                    return false;
                }
                PushReplicationEvent.RecordsPayload payload = (PushReplicationEvent.RecordsPayload)pushReplicationEvent.payload();
                MemoryRecords memoryRecords = (MemoryRecords)payload.records();
                long newSizeInBytes = this.sizeInBytes + (long)memoryRecords.sizeInBytes();
                if (newSizeInBytes > this.maxSizeInBytes) {
                    return false;
                }
                this.records.add((AbstractRecords)memoryRecords);
                if (this.appendOffset == -1L) {
                    this.appendOffset = payload.appendOffset();
                }
                this.highWatermark = Math.max(this.highWatermark, payload.highWatermark());
                this.sizeInBytes = newSizeInBytes;
                return true;
            }
        }
        log.warn((Object)((Object)pushReplicationEvent.type()) + " events not expected to be handled here");
        return false;
    }

    public AppendRecordsRequestData.PartitionData build() {
        AppendRecordsRequestData.PartitionData partitionData = new AppendRecordsRequestData.PartitionData().setPartitionIndex(this.topicIdPartition.partition()).setCurrentLeaderEpoch(this.initialSession.leaderEpoch()).setReplicationSessionId(this.initialSession.replicationSessionId());
        if (this.stopFuture != null) {
            partitionData.setEndReplicationSession(true);
            this.stopFuture.complete(null);
            return partitionData;
        }
        partitionData.setAppendOffset(this.appendOffset).setHighWatermark(this.highWatermark).setLogStartOffset(this.logStartOffset);
        if (this.startFuture != null) {
            if (this.records.size() == 1) {
                partitionData.setRecords((BaseRecords)this.records.get(0));
            }
            this.startFuture.complete(null);
            return partitionData;
        }
        if (!this.records.isEmpty()) {
            List<MemoryRecords> memoryRecords = this.records.stream().filter(r -> r instanceof MemoryRecords).map(r -> (MemoryRecords)r).collect(Collectors.toList());
            partitionData.setRecords((BaseRecords)new PartitionRecords(memoryRecords));
        }
        return partitionData;
    }

    List<AbstractRecords> records() {
        return Collections.unmodifiableList(this.records);
    }

    long appendOffset() {
        return this.appendOffset;
    }

    long highWatermark() {
        return this.highWatermark;
    }

    long logStartOffset() {
        return this.logStartOffset;
    }

    private boolean isInitialPushSession(PushSession currentSession) {
        if (!this.initialSession.equals(currentSession)) {
            log.warn("Received event for invalid push session - expected {}, but got {}", (Object)this.initialSession, (Object)currentSession);
            return false;
        }
        return true;
    }

    public static final class PartitionRecords
    extends MultiBufferRecords {
        private final List<MemoryRecords> memoryRecords;
        private final ByteBuffer[] buffers;
        private final int size;

        public PartitionRecords(List<MemoryRecords> memoryRecords) {
            this.memoryRecords = memoryRecords;
            this.buffers = new ByteBuffer[memoryRecords.size()];
            int totalSize = 0;
            for (int i = 0; i < memoryRecords.size(); ++i) {
                MemoryRecords curr = memoryRecords.get(i);
                this.buffers[i] = curr.buffer();
                totalSize += curr.sizeInBytes();
            }
            this.size = totalSize;
        }

        public List<MemoryRecords> memoryRecords() {
            return Collections.unmodifiableList(this.memoryRecords);
        }

        public ByteBuffer[] buffers() {
            return this.buffers;
        }

        public int sizeInBytes() {
            return this.size;
        }

        public void release() {
        }
    }
}

