/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest.resources;

import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.rest.RestRequestTimeout;
import org.apache.kafka.connect.runtime.rest.RestServerConfig;
import org.apache.kafka.connect.runtime.rest.entities.ConfluentConnectClusterId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/metadata")
@Produces(value={"application/json"})
public class ConfluentV1MetadataResource {
    public static final String UNKNOWN_KAFKA_CLUSTER_ID = "UNKNOWN";
    private static final Logger log = LoggerFactory.getLogger(ConfluentV1MetadataResource.class);
    private final ConfluentConnectClusterId clusterId;
    private final RestRequestTimeout requestTimeout;

    @Inject
    public ConfluentV1MetadataResource(Herder herder, RestServerConfig restServerConfig, RestRequestTimeout requestTimeout) {
        String kafkaClusterId = herder.kafkaClusterId();
        if (kafkaClusterId == null) {
            log.warn("Unable to fetch cluster ID from pre-0.10.1 Kafka broker, defaulting to '{}'", (Object)UNKNOWN_KAFKA_CLUSTER_ID);
            kafkaClusterId = UNKNOWN_KAFKA_CLUSTER_ID;
        }
        String connectClusterId = restServerConfig.originals().getOrDefault("group.id", "STANDALONE").toString();
        this.clusterId = new ConfluentConnectClusterId(kafkaClusterId, connectClusterId);
        this.requestTimeout = requestTimeout;
    }

    @GET
    @Path(value="id")
    public ConfluentConnectClusterId clusterId() {
        return this.clusterId;
    }
}

