/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image.node;

import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.image.node.MetadataNode;
import org.apache.kafka.image.node.printer.MetadataNodePrinter;
import org.apache.kafka.metadata.DelegationTokenData;

public class DelegationTokenDataNode
implements MetadataNode {
    private final DelegationTokenData data;

    public DelegationTokenDataNode(DelegationTokenData data) {
        this.data = data;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public void print(MetadataNodePrinter printer) {
        TokenInformation tokenInformation = this.data.tokenInformation();
        StringBuilder bld = new StringBuilder();
        bld.append("DelegationTokenData");
        bld.append("tokenId=");
        if (printer.redactionCriteria().shouldRedactDelegationToken()) {
            bld.append("[redacted]");
        } else {
            bld.append(tokenInformation.tokenId());
        }
        bld.append("(owner=");
        if (printer.redactionCriteria().shouldRedactDelegationToken()) {
            bld.append("[redacted]");
        } else {
            bld.append(tokenInformation.ownerAsString());
        }
        bld.append("(tokenRequester=");
        if (printer.redactionCriteria().shouldRedactDelegationToken()) {
            bld.append("[redacted]");
        } else {
            bld.append(tokenInformation.tokenRequesterAsString());
        }
        bld.append("(renewers=");
        if (printer.redactionCriteria().shouldRedactDelegationToken()) {
            bld.append("[redacted]");
        } else {
            bld.append(String.join((CharSequence)" ", tokenInformation.renewersAsString()));
        }
        bld.append(", issueTimestamp=");
        if (printer.redactionCriteria().shouldRedactDelegationToken()) {
            bld.append("[redacted]");
        } else {
            bld.append(tokenInformation.issueTimestamp());
        }
        bld.append(", maxTimestamp=");
        if (printer.redactionCriteria().shouldRedactDelegationToken()) {
            bld.append("[redacted]");
        } else {
            bld.append(tokenInformation.maxTimestamp());
        }
        bld.append(")");
        bld.append(", expiryTimestamp=");
        if (printer.redactionCriteria().shouldRedactDelegationToken()) {
            bld.append("[redacted]");
        } else {
            bld.append(tokenInformation.expiryTimestamp());
        }
        printer.output(bld.toString());
    }
}

