/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.codegen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.codegen.CodeGenSpec;
import io.confluent.ksql.execution.codegen.CompiledExpression;
import io.confluent.ksql.execution.codegen.SqlToJavaVisitor;
import io.confluent.ksql.execution.expression.tree.CreateArrayExpression;
import io.confluent.ksql.execution.expression.tree.CreateMapExpression;
import io.confluent.ksql.execution.expression.tree.CreateStructExpression;
import io.confluent.ksql.execution.expression.tree.DereferenceExpression;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.expression.tree.LambdaFunctionCall;
import io.confluent.ksql.execution.expression.tree.LikePredicate;
import io.confluent.ksql.execution.expression.tree.SubscriptExpression;
import io.confluent.ksql.execution.expression.tree.TraversalExpressionVisitor;
import io.confluent.ksql.execution.expression.tree.UnqualifiedColumnReferenceExp;
import io.confluent.ksql.execution.util.ExpressionTypeManager;
import io.confluent.ksql.execution.util.FunctionArgumentsUtil;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.function.KsqlScalarFunction;
import io.confluent.ksql.function.UdfFactory;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.SystemColumns;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlStatementException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.connect.data.Schema;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.CompilerFactoryFactory;
import org.codehaus.commons.compiler.IExpressionEvaluator;

public class CodeGenRunner {
    private static final SchemaConverters.SqlToJavaTypeConverter SQL_TO_JAVA_TYPE_CONVERTER = SchemaConverters.sqlToJavaConverter();
    private final LogicalSchema schema;
    private final FunctionRegistry functionRegistry;
    private final ExpressionTypeManager expressionTypeManager;
    private final KsqlConfig ksqlConfig;

    public static List<CompiledExpression> compileExpressions(Stream<Expression> expressions, String type, LogicalSchema schema, KsqlConfig ksqlConfig, FunctionRegistry functionRegistry) {
        CodeGenRunner codeGen = new CodeGenRunner(schema, ksqlConfig, functionRegistry);
        return expressions.map(exp -> CodeGenRunner.compileExpression(exp, type, codeGen)).collect(Collectors.toList());
    }

    public static CompiledExpression compileExpression(Expression expression, String type, LogicalSchema schema, KsqlConfig ksqlConfig, FunctionRegistry functionRegistry) {
        CodeGenRunner codeGen = new CodeGenRunner(schema, ksqlConfig, functionRegistry);
        return CodeGenRunner.compileExpression(expression, type, codeGen);
    }

    private static CompiledExpression compileExpression(Expression expression, String type, CodeGenRunner codeGen) {
        return codeGen.buildCodeGenFromParseTree(expression, type);
    }

    public CodeGenRunner(LogicalSchema schema, KsqlConfig ksqlConfig, FunctionRegistry functionRegistry) {
        this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry");
        this.schema = Objects.requireNonNull(schema, "schema");
        this.ksqlConfig = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
        this.expressionTypeManager = new ExpressionTypeManager(schema, functionRegistry);
    }

    public CodeGenSpec getCodeGenSpec(Expression expression) {
        Visitor visitor = new Visitor();
        Context context = new Context();
        visitor.process(expression, context);
        return visitor.spec.build();
    }

    public CompiledExpression buildCodeGenFromParseTree(Expression expression, String type) {
        try {
            CodeGenSpec spec = this.getCodeGenSpec(expression);
            String javaCode = SqlToJavaVisitor.of(this.schema, this.functionRegistry, spec, this.ksqlConfig).process(expression);
            SqlType returnType = this.expressionTypeManager.getExpressionSqlType(expression, new HashMap<String, SqlType>());
            if (returnType == null) {
                throw new KsqlException("NULL expression not supported");
            }
            Class expressionType = SQL_TO_JAVA_TYPE_CONVERTER.toJavaType(returnType);
            IExpressionEvaluator ee = CodeGenRunner.cook(javaCode, expressionType);
            return new CompiledExpression(ee, spec, returnType, expression);
        }
        catch (KsqlException | CompileException e) {
            throw new KsqlStatementException("Invalid " + type + ": " + e.getMessage() + ".", "Invalid " + type + ": " + e.getMessage() + ". expression: " + (Object)((Object)expression) + ", schema:" + this.schema, Objects.toString((Object)expression), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error generating code for " + type, e);
        }
    }

    @VisibleForTesting
    public static IExpressionEvaluator cook(String javaCode, Class<?> expressionType) throws Exception {
        IExpressionEvaluator ee = CompilerFactoryFactory.getDefaultCompilerFactory().newExpressionEvaluator();
        ee.setDefaultImports(SqlToJavaVisitor.JAVA_IMPORTS.toArray(new String[0]));
        ee.setParameters(new String[]{"arguments", "defaultValue", "logger", "row"}, new Class[]{Map.class, Object.class, ProcessingLogger.class, GenericRow.class});
        ee.setExpressionType(expressionType);
        ee.cook(javaCode);
        return ee;
    }

    private final class Visitor
    extends TraversalExpressionVisitor<Context> {
        private final CodeGenSpec.Builder spec = new CodeGenSpec.Builder();

        private Visitor() {
        }

        @Override
        public Void visitLikePredicate(LikePredicate node, Context context) {
            this.process(node.getValue(), context);
            this.process(node.getPattern(), context);
            return null;
        }

        @Override
        public Void visitFunctionCall(FunctionCall node, Context context) {
            UdfFactory udfFactory = CodeGenRunner.this.functionRegistry.getUdfFactory(node.getName());
            FunctionArgumentsUtil.FunctionTypeInfo argumentsAndContext = FunctionArgumentsUtil.getFunctionTypeInfo(CodeGenRunner.this.expressionTypeManager, node, udfFactory, context.getLambdaSqlTypeMapping());
            List<Expression> arguments = node.getArguments();
            List<FunctionArgumentsUtil.ArgumentInfo> argumentInfos = argumentsAndContext.getArgumentInfos();
            KsqlScalarFunction function = argumentsAndContext.getFunction();
            this.spec.addFunction(function.name(), function.newInstance(CodeGenRunner.this.ksqlConfig));
            for (int i = 0; i < arguments.size(); ++i) {
                this.process(arguments.get(i), new Context(argumentInfos.get(i).getLambdaSqlTypeMapping()));
            }
            return null;
        }

        @Override
        public Void visitSubscriptExpression(SubscriptExpression node, Context context) {
            if (node.getBase() instanceof UnqualifiedColumnReferenceExp) {
                UnqualifiedColumnReferenceExp arrayBaseName = (UnqualifiedColumnReferenceExp)node.getBase();
                this.addRequiredColumn(arrayBaseName.getColumnName());
            } else {
                this.process(node.getBase(), context);
            }
            this.process(node.getIndex(), context);
            return null;
        }

        @Override
        public Void visitCreateArrayExpression(CreateArrayExpression exp, Context context) {
            exp.getValues().forEach(val -> {
                Void cfr_ignored_0 = (Void)this.process((Expression)((Object)val), context);
            });
            return null;
        }

        @Override
        public Void visitCreateMapExpression(CreateMapExpression exp, Context context) {
            for (Map.Entry entry : exp.getMap().entrySet()) {
                this.process((Expression)((Object)entry.getKey()), context);
                this.process((Expression)((Object)entry.getValue()), context);
            }
            return null;
        }

        @Override
        public Void visitStructExpression(CreateStructExpression exp, Context context) {
            exp.getFields().forEach(val -> {
                Void cfr_ignored_0 = (Void)this.process(val.getValue(), context);
            });
            Schema schema = SchemaConverters.sqlToConnectConverter().toConnectSchema(CodeGenRunner.this.expressionTypeManager.getExpressionSqlType(exp, context.getLambdaSqlTypeMapping()));
            this.spec.addStructSchema(exp, schema);
            return null;
        }

        @Override
        public Void visitUnqualifiedColumnReference(UnqualifiedColumnReferenceExp node, Context context) {
            this.addRequiredColumn(node.getColumnName());
            return null;
        }

        @Override
        public Void visitDereferenceExpression(DereferenceExpression node, Context context) {
            this.process(node.getBase(), context);
            return null;
        }

        @Override
        public Void visitLambdaExpression(LambdaFunctionCall node, Context context) {
            this.process(node.getBody(), context);
            return null;
        }

        private void addRequiredColumn(ColumnName columnName) {
            Column column = (Column)CodeGenRunner.this.schema.findValueColumn(columnName).orElseThrow(() -> new KsqlException(this.fieldNotFoundErrorMessage(columnName)));
            this.spec.addParameter(column.name(), SQL_TO_JAVA_TYPE_CONVERTER.toJavaType(column.type()), column.index());
        }

        private String fieldNotFoundErrorMessage(ColumnName columnName) {
            String cannotFindFieldMessage = "Cannot find the select field in the available fields. field: " + columnName + ", schema: " + CodeGenRunner.this.schema.value();
            if (SystemColumns.isPseudoColumn((ColumnName)columnName)) {
                return cannotFindFieldMessage + "\nIf this is a CREATE OR REPLACE query, pseudocolumns added in newer versions of ksqlDB after the original query was issued are not available for use in CREATE OR REPLACE";
            }
            return cannotFindFieldMessage;
        }
    }

    @Immutable
    private static final class Context {
        private final ImmutableMap<String, SqlType> lambdaSqlTypeMapping;

        private Context() {
            this(new HashMap<String, SqlType>());
        }

        private Context(Map<String, SqlType> mapping) {
            this.lambdaSqlTypeMapping = ImmutableMap.copyOf(mapping);
        }

        Map<String, SqlType> getLambdaSqlTypeMapping() {
            return this.lambdaSqlTypeMapping;
        }
    }
}

