/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.codegen.helpers;

import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.execution.codegen.helpers.LambdaUtil;
import io.confluent.ksql.execution.codegen.helpers.NullSafe;
import io.confluent.ksql.execution.codegen.helpers.SqlTypeCodeGen;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.types.SqlArray;
import io.confluent.ksql.schema.ksql.types.SqlBaseType;
import io.confluent.ksql.schema.ksql.types.SqlDecimal;
import io.confluent.ksql.schema.ksql.types.SqlMap;
import io.confluent.ksql.schema.ksql.types.SqlStruct;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public final class CastEvaluator {
    private static final ImmutableMap<SupportedCast, CastFunction> SUPPORTED = ImmutableMap.builder().put((Object)CastEvaluator.key(SqlBaseType.BOOLEAN, SqlBaseType.STRING), CastEvaluator::castToString).put((Object)CastEvaluator.key(SqlBaseType.INTEGER, SqlBaseType.BIGINT), (Object)CastEvaluator.nonNullSafeCode("%s.longValue()")).put((Object)CastEvaluator.key(SqlBaseType.INTEGER, SqlBaseType.DECIMAL), CastEvaluator::castToDecimal).put((Object)CastEvaluator.key(SqlBaseType.INTEGER, SqlBaseType.DOUBLE), (Object)CastEvaluator.nonNullSafeCode("%s.doubleValue()")).put((Object)CastEvaluator.key(SqlBaseType.INTEGER, SqlBaseType.STRING), CastEvaluator::castToString).put((Object)CastEvaluator.key(SqlBaseType.BIGINT, SqlBaseType.INTEGER), (Object)CastEvaluator.nonNullSafeCode("%s.intValue()")).put((Object)CastEvaluator.key(SqlBaseType.BIGINT, SqlBaseType.DECIMAL), CastEvaluator::castToDecimal).put((Object)CastEvaluator.key(SqlBaseType.BIGINT, SqlBaseType.DOUBLE), (Object)CastEvaluator.nonNullSafeCode("%s.doubleValue()")).put((Object)CastEvaluator.key(SqlBaseType.BIGINT, SqlBaseType.STRING), CastEvaluator::castToString).put((Object)CastEvaluator.key(SqlBaseType.DECIMAL, SqlBaseType.INTEGER), (Object)CastEvaluator.nonNullSafeCode("%s.intValue()")).put((Object)CastEvaluator.key(SqlBaseType.DECIMAL, SqlBaseType.BIGINT), (Object)CastEvaluator.nonNullSafeCode("%s.longValue()")).put((Object)CastEvaluator.key(SqlBaseType.DECIMAL, SqlBaseType.DECIMAL), CastEvaluator::castToDecimal).put((Object)CastEvaluator.key(SqlBaseType.DECIMAL, SqlBaseType.DOUBLE), (Object)CastEvaluator.nonNullSafeCode("%s.doubleValue()")).put((Object)CastEvaluator.key(SqlBaseType.DECIMAL, SqlBaseType.STRING), (Object)CastEvaluator.nonNullSafeCode("%s.toPlainString()")).put((Object)CastEvaluator.key(SqlBaseType.DOUBLE, SqlBaseType.INTEGER), (Object)CastEvaluator.nonNullSafeCode("%s.intValue()")).put((Object)CastEvaluator.key(SqlBaseType.DOUBLE, SqlBaseType.BIGINT), (Object)CastEvaluator.nonNullSafeCode("%s.longValue()")).put((Object)CastEvaluator.key(SqlBaseType.DOUBLE, SqlBaseType.DECIMAL), CastEvaluator::castToDecimal).put((Object)CastEvaluator.key(SqlBaseType.DOUBLE, SqlBaseType.STRING), CastEvaluator::castToString).put((Object)CastEvaluator.key(SqlBaseType.STRING, SqlBaseType.BOOLEAN), (Object)CastEvaluator.nonNullSafeCode("SqlBooleans.parseBoolean(%s.trim())")).put((Object)CastEvaluator.key(SqlBaseType.STRING, SqlBaseType.INTEGER), (Object)CastEvaluator.nonNullSafeCode("Integer.parseInt(%s.trim())")).put((Object)CastEvaluator.key(SqlBaseType.STRING, SqlBaseType.BIGINT), (Object)CastEvaluator.nonNullSafeCode("Long.parseLong(%s.trim())")).put((Object)CastEvaluator.key(SqlBaseType.STRING, SqlBaseType.DECIMAL), CastEvaluator::castToDecimal).put((Object)CastEvaluator.key(SqlBaseType.STRING, SqlBaseType.DOUBLE), (Object)CastEvaluator.nonNullSafeCode("SqlDoubles.parseDouble(%s.trim())")).put((Object)CastEvaluator.key(SqlBaseType.STRING, SqlBaseType.TIMESTAMP), (Object)CastEvaluator.nonNullSafeCode("SqlTimeTypes.parseTimestamp(%s.trim())")).put((Object)CastEvaluator.key(SqlBaseType.STRING, SqlBaseType.TIME), (Object)CastEvaluator.nonNullSafeCode("SqlTimeTypes.parseTime(%s.trim())")).put((Object)CastEvaluator.key(SqlBaseType.STRING, SqlBaseType.DATE), (Object)CastEvaluator.nonNullSafeCode("SqlTimeTypes.parseDate(%s.trim())")).put((Object)CastEvaluator.key(SqlBaseType.STRING, SqlBaseType.BYTES), (Object)CastEvaluator.nonNullSafeCode("ByteBuffer.wrap(BytesUtils.decode(%s.trim(), BytesUtils.Encoding.BASE64))")).put((Object)CastEvaluator.key(SqlBaseType.ARRAY, SqlBaseType.ARRAY), CastEvaluator::castArrayToArray).put((Object)CastEvaluator.key(SqlBaseType.ARRAY, SqlBaseType.STRING), CastEvaluator::castToString).put((Object)CastEvaluator.key(SqlBaseType.MAP, SqlBaseType.MAP), CastEvaluator::castMapToMap).put((Object)CastEvaluator.key(SqlBaseType.MAP, SqlBaseType.STRING), CastEvaluator::castToString).put((Object)CastEvaluator.key(SqlBaseType.STRUCT, SqlBaseType.STRUCT), CastEvaluator::castStructToStruct).put((Object)CastEvaluator.key(SqlBaseType.STRUCT, SqlBaseType.STRING), CastEvaluator::castToString).put((Object)CastEvaluator.key(SqlBaseType.TIMESTAMP, SqlBaseType.STRING), (Object)CastEvaluator.nonNullSafeCode("SqlTimeTypes.formatTimestamp(%s)")).put((Object)CastEvaluator.key(SqlBaseType.TIMESTAMP, SqlBaseType.TIME), (Object)CastEvaluator.nonNullSafeCode("SqlTimeTypes.timestampToTime(%s)")).put((Object)CastEvaluator.key(SqlBaseType.TIMESTAMP, SqlBaseType.DATE), (Object)CastEvaluator.nonNullSafeCode("SqlTimeTypes.timestampToDate(%s)")).put((Object)CastEvaluator.key(SqlBaseType.DATE, SqlBaseType.TIMESTAMP), (Object)CastEvaluator.nonNullSafeCode("new Timestamp(%s.getTime())")).put((Object)CastEvaluator.key(SqlBaseType.TIME, SqlBaseType.STRING), (Object)CastEvaluator.nonNullSafeCode("SqlTimeTypes.formatTime(%s)")).put((Object)CastEvaluator.key(SqlBaseType.DATE, SqlBaseType.STRING), (Object)CastEvaluator.nonNullSafeCode("SqlTimeTypes.formatDate(%s)")).build();

    private CastEvaluator() {
    }

    public static String generateCode(String innerCode, SqlType from, SqlType to, KsqlConfig config) {
        if (from == null || to.equals(from)) {
            return innerCode;
        }
        return ((CastFunction)Optional.ofNullable(SUPPORTED.get((Object)CastEvaluator.key(from.baseType(), to.baseType()))).orElseThrow(() -> new UnsupportedCastException(from, to))).generateCode(innerCode, from, to, config);
    }

    public static <I, O> List<O> castArray(List<I> array, Function<I, O> mapper) {
        if (array == null) {
            return null;
        }
        ArrayList result = new ArrayList(array.size());
        array.forEach(e -> result.add(mapper.apply(e)));
        return result;
    }

    public static <K1, V1, K2, V2> Map<K2, V2> castMap(Map<K1, V1> map, Function<K1, K2> keyMapper, Function<V1, V2> valueMapper) {
        if (map == null) {
            return null;
        }
        HashMap result = new HashMap(map.size());
        map.forEach((k, v) -> result.put(keyMapper.apply(k), valueMapper.apply(v)));
        return result;
    }

    public static Struct castStruct(Struct struct, Map<String, Function<Object, Object>> fieldMappers, Schema structSchema) {
        if (struct == null) {
            return null;
        }
        Struct result = new Struct(structSchema);
        fieldMappers.forEach((name, mapper) -> result.put(name, mapper.apply(struct.get(name))));
        return result;
    }

    private static CastFunction nonNullSafeCode(String code) {
        return (innerCode, from, to, config) -> {
            Class fromJavaType = SchemaConverters.sqlToJavaConverter().toJavaType(from);
            Class toJavaType = SchemaConverters.sqlToJavaConverter().toJavaType(to);
            String lambdaBody = String.format(code, "val");
            String function = LambdaUtil.toJavaCode("val", fromJavaType, lambdaBody);
            return NullSafe.generateApply(innerCode, function, toJavaType);
        };
    }

    private static String castToDecimal(String innerCode, SqlType from, SqlType to, KsqlConfig config) {
        SqlDecimal decimal = (SqlDecimal)to;
        return "(DecimalUtil.cast(" + innerCode + ", " + decimal.getPrecision() + ", " + decimal.getScale() + "))";
    }

    private static String castToString(String innerCode, SqlType from, SqlType to, KsqlConfig config) {
        return config.getBoolean("ksql.cast.strings.preserve.nulls") != false ? "Objects.toString(" + innerCode + ", null)" : "String.valueOf(" + innerCode + ")";
    }

    private static String castArrayToArray(String innerCode, SqlType from, SqlType to, KsqlConfig config) {
        SqlArray fromArray = (SqlArray)from;
        SqlArray toArray = (SqlArray)to;
        try {
            return "CastEvaluator.castArray(" + innerCode + ", " + CastEvaluator.mapperFunction(fromArray.getItemType(), toArray.getItemType(), config) + ")";
        }
        catch (UnsupportedCastException e) {
            throw new UnsupportedCastException(from, to, e);
        }
    }

    private static String castMapToMap(String innerCode, SqlType from, SqlType to, KsqlConfig config) {
        SqlMap fromMap = (SqlMap)from;
        SqlMap toMap = (SqlMap)to;
        try {
            return "CastEvaluator.castMap(" + innerCode + ", " + CastEvaluator.mapperFunction(fromMap.getKeyType(), toMap.getKeyType(), config) + ", " + CastEvaluator.mapperFunction(fromMap.getValueType(), toMap.getValueType(), config) + ")";
        }
        catch (UnsupportedCastException e) {
            throw new UnsupportedCastException(from, to, e);
        }
    }

    private static String castStructToStruct(String innerCode, SqlType from, SqlType to, KsqlConfig config) {
        SqlStruct fromStruct = (SqlStruct)from;
        SqlStruct toStruct = (SqlStruct)to;
        try {
            String mappers = fromStruct.fields().stream().filter(fromField -> toStruct.field(fromField.name()).isPresent()).map(fromField -> CastEvaluator.castFieldToField(fromField, (SqlStruct.Field)toStruct.field(fromField.name()).get(), config)).collect(Collectors.joining(System.lineSeparator(), "ImmutableMap.builder()\n\t\t", "\n\t\t.build()"));
            String schemaCode = "SchemaConverters.sqlToConnectConverter().toConnectSchema(" + SqlTypeCodeGen.generateCode((SqlType)toStruct) + ")";
            return "CastEvaluator.castStruct(" + innerCode + ", " + mappers + "," + schemaCode + ")";
        }
        catch (UnsupportedCastException e) {
            throw new UnsupportedCastException(from, to, e);
        }
    }

    private static String castFieldToField(SqlStruct.Field fromField, SqlStruct.Field toField, KsqlConfig config) {
        String mapper = CastEvaluator.mapperFunction(fromField.type(), toField.type(), config);
        return ".put(\"" + fromField.name() + "\"," + mapper + ")";
    }

    private static String mapperFunction(SqlType fromItemType, SqlType toItemType, KsqlConfig config) {
        Class javaType = SchemaConverters.sqlToJavaConverter().toJavaType(fromItemType);
        String lambdaBody = CastEvaluator.generateCode("val", fromItemType, toItemType, config);
        return LambdaUtil.toJavaCode("val", javaType, lambdaBody);
    }

    private static SupportedCast key(SqlBaseType from, SqlBaseType to) {
        return new SupportedCast(from, to);
    }

    private static final class SupportedCast {
        private final SqlBaseType from;
        private final SqlBaseType to;

        SupportedCast(SqlBaseType from, SqlBaseType to) {
            this.from = Objects.requireNonNull(from, "from");
            this.to = Objects.requireNonNull(to, "to");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SupportedCast that = (SupportedCast)o;
            return this.from == that.from && this.to == that.to;
        }

        public int hashCode() {
            return Objects.hash(this.from, this.to);
        }
    }

    private static final class UnsupportedCastException
    extends KsqlException {
        UnsupportedCastException(SqlType from, SqlType to) {
            super(UnsupportedCastException.buildMessage(from, to));
        }

        UnsupportedCastException(SqlType from, SqlType to, UnsupportedCastException e) {
            super(UnsupportedCastException.buildMessage(from, to), (Throwable)((Object)e));
        }

        private static String buildMessage(SqlType from, SqlType to) {
            return "Cast of " + from + " to " + to + " is not supported";
        }
    }

    @FunctionalInterface
    private static interface CastFunction {
        public String generateCode(String var1, SqlType var2, SqlType var3, KsqlConfig var4);
    }
}

