/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.execution.expression.tree.Literal;
import io.confluent.ksql.parser.NodeLocation;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class BooleanLiteral
extends Literal {
    private final boolean value;

    public BooleanLiteral(boolean value) {
        this(Optional.empty(), value);
    }

    public BooleanLiteral(String value) {
        this(Optional.empty(), value);
    }

    public BooleanLiteral(Optional<NodeLocation> location, String value) {
        this(location, Objects.requireNonNull(value, "value").toLowerCase(Locale.ENGLISH).equals("true"));
        Preconditions.checkArgument((value.toLowerCase(Locale.ENGLISH).equals("true") || value.toLowerCase(Locale.ENGLISH).equals("false") ? 1 : 0) != 0);
    }

    public BooleanLiteral(Optional<NodeLocation> location, boolean value) {
        super(location);
        this.value = value;
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitBooleanLiteral(this, context);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        BooleanLiteral other = (BooleanLiteral)((Object)obj);
        return Objects.equals(this.value, other.value);
    }
}

