/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.parser.NodeLocation;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class ComparisonExpression
extends Expression {
    private final Type type;
    private final Expression left;
    private final Expression right;

    public ComparisonExpression(Type type, Expression left, Expression right) {
        this(Optional.empty(), type, left, right);
    }

    public ComparisonExpression(Optional<NodeLocation> location, Type type, Expression left, Expression right) {
        super(location);
        this.type = Objects.requireNonNull(type, "type");
        this.left = Objects.requireNonNull(left, "left");
        this.right = Objects.requireNonNull(right, "right");
    }

    public Type getType() {
        return this.type;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitComparisonExpression(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ComparisonExpression that = (ComparisonExpression)((Object)o);
        return this.type == that.type && Objects.equals((Object)this.left, (Object)that.left) && Objects.equals((Object)this.right, (Object)that.right);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.left, this.right});
    }

    public static enum Type {
        EQUAL("="),
        NOT_EQUAL("<>"),
        LESS_THAN("<"),
        LESS_THAN_OR_EQUAL("<="),
        GREATER_THAN(">"),
        GREATER_THAN_OR_EQUAL(">="),
        IS_DISTINCT_FROM("IS DISTINCT FROM"),
        IS_NOT_DISTINCT_FROM("IS NOT DISTINCT FROM");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

