/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.execution.expression.tree.Literal;
import io.confluent.ksql.parser.NodeLocation;
import java.sql.Date;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class DateLiteral
extends Literal {
    private final long value;

    public DateLiteral(Date value) {
        this(Optional.empty(), value);
    }

    public DateLiteral(Optional<NodeLocation> location, Date value) {
        super(location);
        this.value = Objects.requireNonNull(value, "value").getTime();
    }

    @Override
    public Date getValue() {
        return new Date(this.value);
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitDateLiteral(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DateLiteral that = (DateLiteral)((Object)o);
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }
}

