/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import io.confluent.ksql.execution.expression.tree.ColumnReferenceExp;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.NodeLocation;
import java.util.Objects;
import java.util.Optional;

public class QualifiedColumnReferenceExp
extends ColumnReferenceExp {
    private final SourceName qualifier;

    public QualifiedColumnReferenceExp(SourceName qualifier, ColumnName name) {
        this(Optional.empty(), qualifier, name);
    }

    public QualifiedColumnReferenceExp(Optional<NodeLocation> location, SourceName qualifier, ColumnName name) {
        super(location, name);
        this.qualifier = Objects.requireNonNull(qualifier);
    }

    public SourceName getQualifier() {
        return this.qualifier;
    }

    @Override
    public Optional<SourceName> maybeQualifier() {
        return Optional.of(this.qualifier);
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitQualifiedColumnReference(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        QualifiedColumnReferenceExp that = (QualifiedColumnReferenceExp)((Object)o);
        return Objects.equals(this.qualifier, that.qualifier) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.qualifier, this.name);
    }
}

