/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.function;

import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.execution.codegen.helpers.TriFunction;
import io.confluent.ksql.function.KsqlFunctionException;
import io.confluent.ksql.function.types.ArrayType;
import io.confluent.ksql.function.types.GenericType;
import io.confluent.ksql.function.types.LambdaType;
import io.confluent.ksql.function.types.MapType;
import io.confluent.ksql.function.types.ParamType;
import io.confluent.ksql.function.types.ParamTypes;
import io.confluent.ksql.function.types.StructType;
import io.confluent.ksql.name.FunctionName;
import io.confluent.ksql.util.KsqlException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.kafka.connect.data.Struct;

public final class UdfUtil {
    private static final Map<Type, ParamType> JAVA_TO_ARG_TYPE = ImmutableMap.builder().put(String.class, (Object)ParamTypes.STRING).put(Boolean.TYPE, (Object)ParamTypes.BOOLEAN).put(Boolean.class, (Object)ParamTypes.BOOLEAN).put(Integer.class, (Object)ParamTypes.INTEGER).put(Integer.TYPE, (Object)ParamTypes.INTEGER).put(Long.class, (Object)ParamTypes.LONG).put(Long.TYPE, (Object)ParamTypes.LONG).put(Double.class, (Object)ParamTypes.DOUBLE).put(Double.TYPE, (Object)ParamTypes.DOUBLE).put(BigDecimal.class, (Object)ParamTypes.DECIMAL).put(Date.class, (Object)ParamTypes.DATE).put(Timestamp.class, (Object)ParamTypes.TIMESTAMP).put(Time.class, (Object)ParamTypes.TIME).put(TimeUnit.class, (Object)ParamTypes.INTERVALUNIT).put(ByteBuffer.class, (Object)ParamTypes.BYTES).build();
    private static final Map<Type, ParamType> VARARGS_JAVA_TO_ARG_TYPE = ImmutableMap.builder().putAll(JAVA_TO_ARG_TYPE).put(Object.class, (Object)ParamTypes.ANY).build();

    private UdfUtil() {
    }

    public static void ensureCorrectArgs(FunctionName functionName, Object[] args, Class<?> ... argTypes) {
        if (args == null) {
            throw new KsqlFunctionException("Null argument list for " + functionName.text() + ".");
        }
        if (args.length != argTypes.length) {
            throw new KsqlFunctionException("Incorrect arguments for " + functionName.text() + ".");
        }
        for (int i = 0; i < argTypes.length; ++i) {
            if (args[i] == null || argTypes[i].isAssignableFrom(args[i].getClass())) continue;
            throw new KsqlFunctionException(String.format("Incorrect arguments type for %s. Expected %s for arg number %d but found %s.", functionName.text(), argTypes[i].getCanonicalName(), i, args[i].getClass().getCanonicalName()));
        }
    }

    public static ParamType getVarArgsSchemaFromType(Type type) {
        return UdfUtil.getSchemaFromType(type, VARARGS_JAVA_TO_ARG_TYPE);
    }

    public static ParamType getSchemaFromType(Type type) {
        return UdfUtil.getSchemaFromType(type, JAVA_TO_ARG_TYPE);
    }

    private static ParamType getSchemaFromType(Type type, Map<Type, ParamType> javaToArgType) {
        GenericType schema;
        if (type instanceof TypeVariable) {
            schema = GenericType.of((String)((TypeVariable)type).getName());
        } else {
            schema = javaToArgType.get(type);
            if (schema == null) {
                schema = UdfUtil.handleParameterizedType(type, javaToArgType);
            }
        }
        return schema;
    }

    private static ParamType handleParameterizedType(Type type, Map<Type, ParamType> javaToArgType) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (parameterizedType.getRawType() == Map.class) {
                return UdfUtil.handleMapType(parameterizedType, javaToArgType);
            }
            if (parameterizedType.getRawType() == List.class) {
                return UdfUtil.handleListType((ParameterizedType)type, javaToArgType);
            }
            if (parameterizedType.getRawType() == Function.class || parameterizedType.getRawType() == BiFunction.class || parameterizedType.getRawType() == TriFunction.class) {
                return UdfUtil.handleLambdaType((ParameterizedType)type, javaToArgType);
            }
        } else {
            if (type instanceof Class && ((Class)type).isArray()) {
                return ArrayType.of((ParamType)UdfUtil.getSchemaFromType(((Class)type).getComponentType(), javaToArgType));
            }
            if (type instanceof GenericArrayType) {
                return ArrayType.of((ParamType)GenericType.of((String)((GenericArrayType)type).getGenericComponentType().getTypeName()));
            }
            if (type instanceof Class && Struct.class.isAssignableFrom((Class)type)) {
                return StructType.ANY_STRUCT;
            }
        }
        throw new KsqlException("Type inference is not supported for: " + type);
    }

    private static ParamType handleMapType(ParameterizedType type, Map<Type, ParamType> javaToArgType) {
        Type keyType = type.getActualTypeArguments()[0];
        ParamType keyParamType = keyType instanceof TypeVariable ? GenericType.of((String)((TypeVariable)keyType).getName()) : UdfUtil.getSchemaFromType(keyType, javaToArgType);
        Type valueType = type.getActualTypeArguments()[1];
        ParamType valueParamType = valueType instanceof TypeVariable ? GenericType.of((String)((TypeVariable)valueType).getName()) : UdfUtil.getSchemaFromType(valueType, javaToArgType);
        return MapType.of((ParamType)keyParamType, (ParamType)valueParamType);
    }

    private static ParamType handleListType(ParameterizedType type, Map<Type, ParamType> javaToArgType) {
        Type elementType = type.getActualTypeArguments()[0];
        ParamType elementParamType = elementType instanceof TypeVariable ? GenericType.of((String)((TypeVariable)elementType).getName()) : UdfUtil.getSchemaFromType(elementType, javaToArgType);
        return ArrayType.of((ParamType)elementParamType);
    }

    private static ParamType handleLambdaType(ParameterizedType type, Map<Type, ParamType> javaToArgType) {
        ArrayList<ParamType> inputParamTypes = new ArrayList<ParamType>();
        for (int i = 0; i < type.getActualTypeArguments().length - 1; ++i) {
            Type inputType = type.getActualTypeArguments()[i];
            ParamType inputParamType = inputType instanceof TypeVariable ? GenericType.of((String)((TypeVariable)inputType).getName()) : UdfUtil.getSchemaFromType(inputType, javaToArgType);
            inputParamTypes.add(inputParamType);
        }
        Type returnType = type.getActualTypeArguments()[type.getActualTypeArguments().length - 1];
        ParamType returnParamType = returnType instanceof TypeVariable ? GenericType.of((String)((TypeVariable)returnType).getName()) : UdfUtil.getSchemaFromType(returnType, javaToArgType);
        return LambdaType.of(inputParamTypes, (ParamType)returnParamType);
    }
}

