/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.interpreter;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.interpreter.TermEvaluationContext;
import io.confluent.ksql.execution.interpreter.terms.Term;
import io.confluent.ksql.execution.transform.ExpressionEvaluator;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.logging.processing.RecordProcessingError;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.util.function.Supplier;

public class InterpretedExpression
implements ExpressionEvaluator {
    private final Term term;
    private final Expression expression;
    private final SqlType expressionType;

    public InterpretedExpression(Expression expression, SqlType expressionType, Term term) {
        this.expression = expression;
        this.expressionType = expressionType;
        this.term = term;
    }

    @VisibleForTesting
    Object evaluate(GenericRow row) {
        return this.term.getValue(new TermEvaluationContext(row));
    }

    @Override
    public Object evaluate(GenericRow row, Object defaultValue, ProcessingLogger logger, Supplier<String> errorMsg) {
        try {
            return this.evaluate(row);
        }
        catch (Exception e) {
            logger.error(RecordProcessingError.recordProcessingError(errorMsg.get(), (Throwable)e, row));
            return defaultValue;
        }
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public SqlType getExpressionType() {
        return this.expressionType;
    }
}

