/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.interpreter.terms;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.execution.interpreter.TermEvaluationContext;
import io.confluent.ksql.execution.interpreter.terms.Term;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;

public final class LiteralTerms {
    private LiteralTerms() {
    }

    public static Term of(Boolean value) {
        return new BooleanTermImpl(value);
    }

    public static Term of(BigDecimal value, SqlType sqlType) {
        return new DecimalTermImpl(value, sqlType);
    }

    public static Term of(Double value) {
        return new DoubleTermImpl(value);
    }

    public static Term of(Integer value) {
        return new IntegerTermImpl(value);
    }

    public static Term of(Long value) {
        return new LongTermImpl(value);
    }

    public static Term of(String value) {
        return new StringTermImpl(value);
    }

    public static Term of(Timestamp value) {
        return new TimestampTermImpl(value);
    }

    public static Term of(Time value) {
        return new TimeTermImpl(value);
    }

    public static Term of(Date value) {
        return new DateTermImpl(value);
    }

    public static Term of(TimeUnit value) {
        return new IntervalUnitTermImpl(value);
    }

    public static Term of(ByteBuffer value) {
        return new BytesTermImpl(value);
    }

    public static NullTerm ofNull() {
        return new NullTerm();
    }

    public static class IntervalUnitTermImpl
    implements Term {
        private final TimeUnit value;

        public IntervalUnitTermImpl(TimeUnit timeUnit) {
            this.value = timeUnit;
        }

        @Override
        public Object getValue(TermEvaluationContext context) {
            return this.value;
        }

        @Override
        public SqlType getSqlType() {
            return null;
        }
    }

    public static class BytesTermImpl
    implements Term {
        private final ByteBuffer value;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
        public BytesTermImpl(ByteBuffer bytes) {
            this.value = bytes;
        }

        @Override
        @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
        public Object getValue(TermEvaluationContext context) {
            return this.value;
        }

        @Override
        public SqlType getSqlType() {
            return SqlTypes.BYTES;
        }
    }

    public static class DateTermImpl
    implements Term {
        private final long dateMs;

        public DateTermImpl(Date date) {
            this.dateMs = date.getTime();
        }

        @Override
        public Object getValue(TermEvaluationContext context) {
            return new Date(this.dateMs);
        }

        @Override
        public SqlType getSqlType() {
            return SqlTypes.DATE;
        }
    }

    public static class TimeTermImpl
    implements Term {
        private final long timeMs;

        public TimeTermImpl(Time time) {
            this.timeMs = time.getTime();
        }

        @Override
        public Object getValue(TermEvaluationContext context) {
            return new Time(this.timeMs);
        }

        @Override
        public SqlType getSqlType() {
            return SqlTypes.TIME;
        }
    }

    public static class TimestampTermImpl
    implements Term {
        private final long timeMs;

        public TimestampTermImpl(Timestamp timestamp) {
            this.timeMs = timestamp.getTime();
        }

        @Override
        public Object getValue(TermEvaluationContext context) {
            return new Timestamp(this.timeMs);
        }

        @Override
        public SqlType getSqlType() {
            return SqlTypes.TIMESTAMP;
        }
    }

    public static class DecimalTermImpl
    implements Term {
        private final BigDecimal value;
        private final SqlType sqlType;

        @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
        public DecimalTermImpl(BigDecimal value, SqlType sqlType) {
            this.value = value;
            this.sqlType = sqlType;
        }

        @Override
        @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
        public Object getValue(TermEvaluationContext context) {
            return this.value;
        }

        @Override
        public SqlType getSqlType() {
            return this.sqlType;
        }
    }

    public static class StringTermImpl
    implements Term {
        private final String value;

        public StringTermImpl(String value) {
            this.value = value;
        }

        @Override
        public Object getValue(TermEvaluationContext context) {
            return this.value;
        }

        @Override
        public SqlType getSqlType() {
            return SqlTypes.STRING;
        }
    }

    public static class LongTermImpl
    implements Term {
        private final Long value;

        public LongTermImpl(Long value) {
            this.value = value;
        }

        @Override
        public Object getValue(TermEvaluationContext context) {
            return this.value;
        }

        @Override
        public SqlType getSqlType() {
            return SqlTypes.BIGINT;
        }
    }

    public static class IntegerTermImpl
    implements Term {
        private final Integer value;

        public IntegerTermImpl(Integer value) {
            this.value = value;
        }

        @Override
        public Object getValue(TermEvaluationContext context) {
            return this.value;
        }

        @Override
        public SqlType getSqlType() {
            return SqlTypes.INTEGER;
        }
    }

    public static class DoubleTermImpl
    implements Term {
        private final Double value;

        public DoubleTermImpl(Double value) {
            this.value = value;
        }

        @Override
        public Object getValue(TermEvaluationContext context) {
            return this.value;
        }

        @Override
        public SqlType getSqlType() {
            return SqlTypes.DOUBLE;
        }
    }

    public static class BooleanTermImpl
    implements Term {
        private final Boolean value;

        public BooleanTermImpl(Boolean value) {
            this.value = value;
        }

        @Override
        public Object getValue(TermEvaluationContext context) {
            return this.value;
        }

        @Override
        public SqlType getSqlType() {
            return SqlTypes.BOOLEAN;
        }
    }

    public static class NullTerm
    implements Term {
        @Override
        public Object getValue(TermEvaluationContext context) {
            return null;
        }

        @Override
        public SqlType getSqlType() {
            return null;
        }
    }
}

