/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import io.confluent.ksql.execution.plan.ExecutionStep;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class PlanInfo {
    private final Sources allSources;
    private final Optional<SourceInfo> activeSource;

    public PlanInfo(ExecutionStep<?> sourceStep) {
        this.allSources = new Sources();
        SourceInfo sourceInfo = this.allSources.addSource(sourceStep);
        this.activeSource = Optional.of(sourceInfo);
    }

    private PlanInfo(Sources sources) {
        this.allSources = sources;
        this.activeSource = Optional.empty();
    }

    public boolean isRepartitionedInPlan(ExecutionStep<?> sourceStep) {
        SourceInfo sourceInfo = this.allSources.get(sourceStep);
        if (sourceInfo == null) {
            throw new IllegalStateException("Source not found");
        }
        return sourceInfo.isRepartitionedInPlan;
    }

    public PlanInfo setIsRepartitionedInPlan() {
        this.activeSource.ifPresent(sourceInfo -> {
            sourceInfo.isRepartitionedInPlan = true;
        });
        return this;
    }

    public PlanInfo merge(PlanInfo other) {
        return new PlanInfo(this.allSources.merge(other.allSources));
    }

    public Set<ExecutionStep<?>> getSources() {
        return this.allSources.sourceSet;
    }

    private static class Sources {
        private final HashMap<ExecutionStep<?>, SourceInfo> sources = new HashMap();
        Set<ExecutionStep<?>> sourceSet = this.sources.keySet();

        private Sources() {
        }

        SourceInfo addSource(ExecutionStep<?> sourceStep) {
            SourceInfo sourceInfo = new SourceInfo(sourceStep);
            this.sources.put(sourceStep, sourceInfo);
            return sourceInfo;
        }

        SourceInfo get(ExecutionStep<?> sourceStep) {
            return this.sources.get(sourceStep);
        }

        Sources merge(Sources other) {
            this.sources.putAll(other.sources);
            return this;
        }
    }

    private static class SourceInfo {
        final ExecutionStep<?> sourceStep;
        boolean isRepartitionedInPlan;

        SourceInfo(ExecutionStep<?> sourceStep) {
            this.sourceStep = Objects.requireNonNull(sourceStep);
        }
    }
}

