/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.execution.expression.tree.FunctionCall;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ExecutionStepPropertiesV1;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.PlanBuilder;
import io.confluent.ksql.execution.plan.PlanInfo;
import io.confluent.ksql.execution.plan.PlanInfoExtractor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Immutable
public class StreamFlatMap<K>
implements ExecutionStep<KStreamHolder<K>> {
    private final ExecutionStepPropertiesV1 properties;
    private final ExecutionStep<KStreamHolder<K>> source;
    private final ImmutableList<FunctionCall> tableFunctions;

    public StreamFlatMap(@JsonProperty(value="properties", required=true) ExecutionStepPropertiesV1 props, @JsonProperty(value="source", required=true) ExecutionStep<KStreamHolder<K>> source, @JsonProperty(value="tableFunctions", required=true) List<FunctionCall> tableFunctions) {
        this.properties = Objects.requireNonNull(props, "props");
        this.source = Objects.requireNonNull(source, "source");
        this.tableFunctions = ImmutableList.copyOf((Collection)Objects.requireNonNull(tableFunctions));
        if (tableFunctions.isEmpty()) {
            throw new IllegalArgumentException("Need at latest one table function");
        }
    }

    @Override
    public ExecutionStepPropertiesV1 getProperties() {
        return this.properties;
    }

    @Override
    @JsonIgnore
    public List<ExecutionStep<?>> getSources() {
        return Collections.singletonList(this.source);
    }

    @Override
    public KStreamHolder<K> build(PlanBuilder builder, PlanInfo info) {
        return builder.visitFlatMap(this, info);
    }

    @Override
    public PlanInfo extractPlanInfo(PlanInfoExtractor extractor) {
        return extractor.visitFlatMap(this);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="tableFunctions is ImmutableList")
    public List<FunctionCall> getTableFunctions() {
        return this.tableFunctions;
    }

    public ExecutionStep<KStreamHolder<K>> getSource() {
        return this.source;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamFlatMap that = (StreamFlatMap)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.source, that.source) && Objects.equals(this.tableFunctions, that.tableFunctions);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.source, this.tableFunctions);
    }
}

