/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ExecutionStepPropertiesV1;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.PlanBuilder;
import io.confluent.ksql.execution.plan.PlanInfo;
import io.confluent.ksql.execution.plan.PlanInfoExtractor;
import io.confluent.ksql.execution.timestamp.TimestampColumn;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

@Immutable
public class TableSink<K>
implements ExecutionStep<KTableHolder<K>> {
    private final ExecutionStepPropertiesV1 properties;
    private final ExecutionStep<KTableHolder<K>> source;
    private final Formats formats;
    private final String topicName;
    private final Optional<TimestampColumn> timestampColumn;
    private static final ImmutableList<ExecutionStep.Property> MUST_MATCH = ImmutableList.of((Object)new ExecutionStep.Property("class", Object::getClass), (Object)new ExecutionStep.Property("properties", ExecutionStep::getProperties), (Object)new ExecutionStep.Property("formats", s -> ((TableSink)s).formats), (Object)new ExecutionStep.Property("topicName", s -> ((TableSink)s).topicName), (Object)new ExecutionStep.Property("timestampColumn", s -> ((TableSink)s).timestampColumn));

    public TableSink(@JsonProperty(value="properties", required=true) ExecutionStepPropertiesV1 props, @JsonProperty(value="source", required=true) ExecutionStep<KTableHolder<K>> source, @JsonProperty(value="formats", required=true) Formats formats, @JsonProperty(value="topicName", required=true) String topicName, @JsonProperty(value="timestampColumn") Optional<TimestampColumn> timestampColumn) {
        this.properties = Objects.requireNonNull(props, "props");
        this.source = Objects.requireNonNull(source, "source");
        this.formats = Objects.requireNonNull(formats, "formats");
        this.topicName = Objects.requireNonNull(topicName, "topicName");
        this.timestampColumn = Objects.requireNonNull(timestampColumn, "timestampColumn");
    }

    @Override
    public ExecutionStepPropertiesV1 getProperties() {
        return this.properties;
    }

    public String getTopicName() {
        return this.topicName;
    }

    @Override
    @JsonIgnore
    public List<ExecutionStep<?>> getSources() {
        return Collections.singletonList(this.source);
    }

    public Formats getFormats() {
        return this.formats;
    }

    public ExecutionStep<KTableHolder<K>> getSource() {
        return this.source;
    }

    public Optional<TimestampColumn> getTimestampColumn() {
        return this.timestampColumn;
    }

    @Override
    public KTableHolder<K> build(PlanBuilder builder, PlanInfo info) {
        return builder.visitTableSink(this, info);
    }

    @Override
    public PlanInfo extractPlanInfo(PlanInfoExtractor extractor) {
        return extractor.visitTableSink(this);
    }

    @Override
    public void validateUpgrade(@Nonnull ExecutionStep<?> to) {
        this.mustMatch(to, (List<ExecutionStep.Property>)MUST_MATCH);
        this.getSource().validateUpgrade(((TableSink)to).source);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableSink tableSink = (TableSink)o;
        return Objects.equals(this.properties, tableSink.properties) && Objects.equals(this.source, tableSink.source) && Objects.equals(this.formats, tableSink.formats) && Objects.equals(this.topicName, tableSink.topicName) && Objects.equals(this.timestampColumn, tableSink.timestampColumn);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.source, this.formats, this.topicName, this.timestampColumn);
    }
}

