/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.ksql.test.tools.exceptions.InvalidFieldException;
import io.confluent.ksql.test.tools.exceptions.KsqlExpectedException;
import io.confluent.ksql.test.tools.exceptions.MissingFieldException;
import java.util.Optional;
import org.hamcrest.Matcher;

public final class ExpectedExceptionNode {
    private final Optional<String> type;
    private final Optional<String> message;

    ExpectedExceptionNode(@JsonProperty(value="type") String type, @JsonProperty(value="message") String message) {
        this.type = Optional.ofNullable(type);
        this.message = Optional.ofNullable(message);
        if (!this.type.isPresent() && !this.message.isPresent()) {
            throw new MissingFieldException("expectedException.type or expectedException.message");
        }
    }

    public Matcher<Throwable> build() {
        KsqlExpectedException expectedException = KsqlExpectedException.none();
        this.type.map(ExpectedExceptionNode::parseThrowable).ifPresent(expectedException::expect);
        this.message.ifPresent(expectedException::expectMessage);
        return expectedException.build();
    }

    private static Class<? extends Throwable> parseThrowable(String className) {
        try {
            Class<?> theClass = Class.forName(className);
            if (!Throwable.class.isAssignableFrom(theClass)) {
                throw new InvalidFieldException("expectedException.type", "Type was not a Throwable");
            }
            return theClass;
        }
        catch (ClassNotFoundException e) {
            throw new InvalidFieldException("expectedException.type", "Type was not found", e);
        }
    }
}

