/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.model;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.model.SemanticVersion;
import io.confluent.ksql.testing.EffectivelyImmutable;
import io.confluent.ksql.util.AppInfo;
import java.util.Comparator;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Immutable
public final class KsqlVersion
implements Comparable<KsqlVersion> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(?<major>\\d+)\\.(?<minor>\\d+)(?<patch>.\\d+)?(?:-([A-Za-z0-9]+|\\d+))*(\\.\\d+-\\d+)?(-rc\\d*)?");
    @EffectivelyImmutable
    private static final Comparator<KsqlVersion> COMPARATOR = Comparator.comparing(KsqlVersion::getVersion).thenComparingLong(v -> v.timestamp);
    private final transient String name;
    private final SemanticVersion version;
    private final long timestamp;

    public static KsqlVersion current() {
        return KsqlVersion.parse(AppInfo.getVersion());
    }

    public static KsqlVersion of(String name, SemanticVersion version) {
        return new KsqlVersion(name, version, Long.MAX_VALUE);
    }

    public static KsqlVersion parse(String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Failed to parse version: '" + version + "'. Version must be in format '" + VERSION_PATTERN.pattern() + "'. ");
        }
        int major = Integer.parseInt(matcher.group("major"));
        int minor = Integer.parseInt(matcher.group("minor"));
        int patch = matcher.group("patch") == null ? 0 : Integer.parseInt(matcher.group("patch").substring(1));
        SemanticVersion v = SemanticVersion.of((int)major, (int)minor, (int)patch);
        return new KsqlVersion(version, v, Long.MAX_VALUE);
    }

    public KsqlVersion withTimestamp(long timestamp) {
        return new KsqlVersion(this.name, this.version, timestamp);
    }

    public String getName() {
        return this.name;
    }

    public SemanticVersion getVersion() {
        return this.version;
    }

    public OptionalLong getTimestamp() {
        return this.timestamp == Long.MAX_VALUE ? OptionalLong.empty() : OptionalLong.of(this.timestamp);
    }

    @Override
    public int compareTo(KsqlVersion other) {
        return COMPARATOR.compare(this, other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KsqlVersion that = (KsqlVersion)o;
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.version);
    }

    public String toString() {
        return this.name + " (" + this.version + ")";
    }

    private KsqlVersion(String name, SemanticVersion version, long timestamp) {
        this.name = Objects.requireNonNull(name, "name");
        this.version = Objects.requireNonNull(version, "version");
        this.timestamp = timestamp;
    }
}

