/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.model;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.test.TestFrameworkException;
import io.confluent.ksql.test.model.PathLocation;
import io.confluent.ksql.tools.test.model.LocationWithinFile;
import io.confluent.ksql.tools.test.model.TestLocation;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public class TestFileContext {
    private static final Path RESOURCE_ROOT = TestFileContext.getRoot().resolve("src").resolve("test").resolve("resources");
    private final Path originalFileName;
    private final Path testPath;
    private final ImmutableList<String> lines;

    public TestFileContext(Path testPath, List<String> lines) {
        this.originalFileName = Objects.requireNonNull(testPath, "testPath");
        this.testPath = RESOURCE_ROOT.resolve(this.originalFileName);
        this.lines = ImmutableList.copyOf(lines);
    }

    public Path getOriginalFileName() {
        return this.originalFileName;
    }

    public TestLocation getFileLocation() {
        return new PathLocation(this.testPath);
    }

    public TestLocation getTestLocation(String testName) {
        return new LocationWithinFile(this.testPath, this.getLineNumber(testName));
    }

    private int getLineNumber(String testName) {
        Pattern pattern = Pattern.compile(".*\"name\"\\s*:\\s*\"" + Pattern.quote(testName) + "\".*");
        int lineNumber = 0;
        for (String line : this.lines) {
            ++lineNumber;
            if (!pattern.matcher(line).matches()) continue;
            return lineNumber;
        }
        throw new TestFrameworkException("Can't find test in test file" + System.lineSeparator() + "test: " + testName + System.lineSeparator() + "file: " + this.testPath);
    }

    private static Path getRoot() {
        Path currentDir = Paths.get("", new String[0]).toAbsolutePath();
        if (currentDir.endsWith("ksqldb-functional-tests")) {
            return currentDir;
        }
        return currentDir.resolve("ksqldb-functional-tests");
    }
}

