/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.ksql.serde.SerdeFeature;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.test.model.SchemaReferencesNode;
import io.confluent.ksql.test.tools.TestJsonMapper;
import io.confluent.ksql.test.tools.exceptions.InvalidFieldException;
import io.confluent.ksql.test.utils.SerdeUtil;
import io.confluent.ksql.tools.test.model.Topic;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class TopicNode {
    private static final ObjectMapper OBJECT_MAPPER = TestJsonMapper.INSTANCE.get();
    private final String name;
    private final Optional<Integer> keySchemaId;
    private final Optional<Integer> valueSchemaId;
    private final JsonNode keySchema;
    private final JsonNode valueSchema;
    private final List<SchemaReferencesNode> keySchemaReferences;
    private final List<SchemaReferencesNode> valueSchemaReferences;
    private final int numPartitions;
    private final int replicas;
    private final String keyFormat;
    private final String valueFormat;
    private final SerdeFeatures keySerdeFeatures;
    private final SerdeFeatures valueSerdeFeatures;

    public TopicNode(@JsonProperty(value="name") String name, @JsonProperty(value="keySchemaId") Optional<Integer> keySchemaId, @JsonProperty(value="valueSchemaId") Optional<Integer> valueSchemaId, @JsonProperty(value="keySchema") JsonNode keySchema, @JsonProperty(value="valueSchema") JsonNode valueSchema, @JsonProperty(value="keySchemaReferences") List<SchemaReferencesNode> keySchemaReferences, @JsonProperty(value="valueSchemaReferences") List<SchemaReferencesNode> valueSchemaReferences, @JsonProperty(value="keyFormat") String keyFormat, @JsonProperty(value="valueFormat") String valueFormat, @JsonProperty(value="partitions") Integer numPartitions, @JsonProperty(value="replicas") Integer replicas, @JsonProperty(value="keySerdeFeatures") SerdeFeatures keySerdeFeatures, @JsonProperty(value="valueSerdeFeatures") SerdeFeatures valueSerdeFeatures) {
        this.name = name == null ? "" : name;
        this.keySchemaId = keySchemaId;
        this.valueSchemaId = valueSchemaId;
        this.keySchema = keySchema;
        this.valueSchema = valueSchema;
        this.keySchemaReferences = keySchemaReferences == null ? ImmutableList.of() : ImmutableList.copyOf(keySchemaReferences);
        this.valueSchemaReferences = valueSchemaReferences == null ? ImmutableList.of() : ImmutableList.copyOf(valueSchemaReferences);
        this.keyFormat = keyFormat;
        this.valueFormat = valueFormat;
        this.numPartitions = numPartitions == null ? 1 : numPartitions;
        this.replicas = replicas == null ? 1 : replicas;
        this.keySerdeFeatures = keySerdeFeatures == null ? SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0]) : keySerdeFeatures;
        SerdeFeatures serdeFeatures = this.valueSerdeFeatures = valueSerdeFeatures == null ? SerdeFeatures.of((SerdeFeature[])new SerdeFeature[0]) : valueSerdeFeatures;
        if (this.name.isEmpty()) {
            throw new InvalidFieldException("name", "empty or missing");
        }
        SerdeUtil.buildSchema(keySchema, keyFormat);
        SerdeUtil.buildSchema(valueSchema, valueFormat);
    }

    public String getName() {
        return this.name;
    }

    public Optional<Integer> getKeySchemaId() {
        return this.keySchemaId;
    }

    public Optional<Integer> getValueSchemaId() {
        return this.valueSchemaId;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="keySchemaReferences is ImmutableList")
    public List<SchemaReferencesNode> getKeySchemaReferences() {
        return this.keySchemaReferences;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="valueSchemaReferences is ImmutableList")
    public List<SchemaReferencesNode> getValueSchemaReferences() {
        return this.valueSchemaReferences;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public JsonNode getKeySchema() {
        return this.keySchema instanceof NullNode ? null : this.keySchema;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public JsonNode getValueSchema() {
        return this.valueSchema instanceof NullNode ? null : this.valueSchema;
    }

    public String getKeyFormat() {
        return this.keyFormat;
    }

    public String getValueFormat() {
        return this.valueFormat;
    }

    public int getNumPartitions() {
        return this.numPartitions;
    }

    public int getReplicas() {
        return this.replicas;
    }

    public SerdeFeatures getKeySerdeFeatures() {
        return this.keySerdeFeatures;
    }

    public SerdeFeatures getValueSerdeFeatures() {
        return this.valueSerdeFeatures;
    }

    public Topic build() {
        List keyReferences = this.keySchemaReferences.stream().map(SchemaReferencesNode::build).collect(Collectors.toList());
        List valueReferences = this.valueSchemaReferences.stream().map(SchemaReferencesNode::build).collect(Collectors.toList());
        return new Topic(this.name, this.numPartitions, this.replicas, this.keySchemaId, this.valueSchemaId, SerdeUtil.buildSchema(this.keySchema, this.keyFormat).map(schema -> SerdeUtil.withSchemaReferences(schema, keyReferences)), SerdeUtil.buildSchema(this.valueSchema, this.valueFormat).map(schema -> SerdeUtil.withSchemaReferences(schema, valueReferences)), keyReferences, valueReferences, this.keySerdeFeatures, this.valueSerdeFeatures);
    }

    public static TopicNode from(Topic topic) {
        String keyFormat = topic.getKeySchema().map(ParsedSchema::schemaType).orElse(null);
        String valueFormat = topic.getValueSchema().map(ParsedSchema::schemaType).orElse(null);
        return new TopicNode(topic.getName(), topic.getKeySchemaId(), topic.getValueSchemaId(), topic.getKeySchema().map(schema -> TopicNode.buildSchemaNode(schema, keyFormat)).orElseGet(NullNode::getInstance), topic.getValueSchema().map(schema -> TopicNode.buildSchemaNode(schema, valueFormat)).orElseGet(NullNode::getInstance), topic.getKeySchemaReferences().stream().map(SchemaReferencesNode::from).collect(Collectors.toList()), topic.getValueSchemaReferences().stream().map(SchemaReferencesNode::from).collect(Collectors.toList()), keyFormat, valueFormat, topic.getNumPartitions(), Integer.valueOf(topic.getReplicas()), topic.getKeyFeatures(), topic.getValueFeatures());
    }

    private static JsonNode buildSchemaNode(ParsedSchema schema, String format) {
        String canonical = schema.canonicalString();
        try {
            if (schema.schemaType().equals("PROTOBUF")) {
                return new TextNode(canonical);
            }
            return OBJECT_MAPPER.readTree(canonical);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

