/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.test.serde;

import com.google.common.collect.ImmutableMap;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.test.serde.SerdeSupplier;
import io.confluent.ksql.test.serde.SpecToConnectConverter;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.KsqlException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.storage.Converter;

public abstract class ConnectSerdeSupplier<T extends ParsedSchema>
implements SerdeSupplier<Object> {
    private final Function<SchemaRegistryClient, Converter> converterFactory;

    protected ConnectSerdeSupplier(Function<SchemaRegistryClient, Converter> converterFactory) {
        this.converterFactory = Objects.requireNonNull(converterFactory, "converterFactory");
    }

    @Override
    public Serializer<Object> getSerializer(SchemaRegistryClient schemaRegistryClient, boolean isKey) {
        return new SpecSerializer(schemaRegistryClient, isKey);
    }

    @Override
    public Deserializer<Object> getDeserializer(SchemaRegistryClient schemaRegistryClient, boolean isKey) {
        return new SpecDeserializer(schemaRegistryClient, isKey);
    }

    protected abstract Schema fromParsedSchema(T var1);

    protected void configureConverter(Converter c, boolean isKey) {
        c.configure((Map)ImmutableMap.of((Object)"schema.registry.url", (Object)"foo"), isKey);
    }

    private class SpecDeserializer
    implements Deserializer<Object> {
        private final Converter converter;

        SpecDeserializer(SchemaRegistryClient srClient, boolean isKey) {
            this.converter = (Converter)ConnectSerdeSupplier.this.converterFactory.apply(srClient);
            ConnectSerdeSupplier.this.configureConverter(this.converter, isKey);
        }

        public Object deserialize(String topic, byte[] bytes) {
            if (bytes == null) {
                return null;
            }
            SchemaAndValue schemaAndValue = this.converter.toConnectData(topic, bytes);
            return SpecToConnectConverter.connectToSpec(schemaAndValue.value(), schemaAndValue.schema(), false);
        }
    }

    private final class SpecSerializer
    implements Serializer<Object> {
        private final SchemaRegistryClient srClient;
        private final Converter converter;
        private final boolean isKey;

        SpecSerializer(SchemaRegistryClient srClient, boolean isKey) {
            this.srClient = Objects.requireNonNull(srClient, "srClient");
            this.converter = (Converter)ConnectSerdeSupplier.this.converterFactory.apply(srClient);
            ConnectSerdeSupplier.this.configureConverter(this.converter, isKey);
            this.isKey = isKey;
        }

        public byte[] serialize(String topic, Object spec) {
            ParsedSchema schema;
            if (spec == null) {
                return null;
            }
            try {
                String subject = KsqlConstants.getSRSubject((String)topic, (boolean)this.isKey);
                int id = this.srClient.getLatestSchemaMetadata(subject).getId();
                schema = this.srClient.getSchemaBySubjectAndId(subject, id);
            }
            catch (Exception e) {
                throw new KsqlException((Throwable)e);
            }
            Schema connectSchema = ConnectSerdeSupplier.this.fromParsedSchema(schema);
            return this.converter.fromConnectData(topic, connectSchema, SpecToConnectConverter.specToConnect(spec, connectSchema));
        }
    }
}

